/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.vcard;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.event.UserEventAdapter;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.vcard.DefaultVCardProvider;
import org.jivesoftware.openfire.vcard.VCardEventDispatcher;
import org.jivesoftware.openfire.vcard.VCardListener;
import org.jivesoftware.openfire.vcard.VCardProvider;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.NotFoundException;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCardManager
extends BasicModule
implements ServerFeaturesProvider {
    private static final Logger Log = LoggerFactory.getLogger(VCardManager.class);
    private VCardProvider provider;
    private static VCardManager instance;
    private EventHandler eventHandler;
    private Cache<String, Element> vcardCache;

    public static VCardManager getInstance() {
        return instance;
    }

    public static VCardProvider getProvider() {
        return VCardManager.instance.provider;
    }

    public VCardManager() {
        super("VCard Manager");
        String cacheName = "VCard";
        this.vcardCache = CacheFactory.createCache(cacheName);
        this.eventHandler = new EventHandler();
        VCardEventDispatcher.addListener(new VCardListener(){

            @Override
            public void vCardCreated(String username, Element vCard) {
                VCardManager.this.vcardCache.put(username, vCard);
            }

            @Override
            public void vCardUpdated(String username, Element vCard) {
                VCardManager.this.vcardCache.put(username, vCard);
            }

            @Override
            public void vCardDeleted(String username, Element vCard) {
                VCardManager.this.vcardCache.remove(username);
            }
        });
    }

    public String getVCardProperty(String username, String name) {
        String answer = null;
        Element vCardElement = this.getOrLoadVCard(username);
        if (vCardElement != null) {
            Element subElement = null;
            StringTokenizer tokenizer = new StringTokenizer(name, ":");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if ((subElement = subElement == null ? vCardElement.element(tok) : subElement.element(tok)) != null) continue;
                break;
            }
            if (subElement != null) {
                answer = subElement.getTextTrim();
            }
        }
        return answer;
    }

    public void setVCard(String username, Element vCardElement) throws Exception {
        boolean created = false;
        boolean updated = false;
        if (this.provider.isReadOnly()) {
            throw new UnsupportedOperationException("VCard provider is read-only.");
        }
        Element oldVCard = this.getOrLoadVCard(username);
        Element newvCard = null;
        if (oldVCard != null) {
            if (!oldVCard.equals(vCardElement)) {
                try {
                    newvCard = this.provider.updateVCard(username, vCardElement);
                    this.vcardCache.put(username, newvCard);
                    updated = true;
                }
                catch (NotFoundException e) {
                    Log.warn("Tried to update a vCard that does not exist", (Throwable)e);
                    newvCard = this.provider.createVCard(username, vCardElement);
                    this.vcardCache.put(username, newvCard);
                    created = true;
                }
            }
        } else {
            try {
                newvCard = this.provider.createVCard(username, vCardElement);
                this.vcardCache.put(username, newvCard);
                created = true;
            }
            catch (AlreadyExistsException e) {
                Log.warn("Tried to create a vCard when one already exist", (Throwable)e);
                newvCard = this.provider.updateVCard(username, vCardElement);
                this.vcardCache.put(username, newvCard);
                updated = true;
            }
        }
        if (created) {
            VCardEventDispatcher.dispatchVCardCreated(username, newvCard);
        } else if (updated) {
            VCardEventDispatcher.dispatchVCardUpdated(username, newvCard);
        }
    }

    public void deleteVCard(String username) {
        if (this.provider.isReadOnly()) {
            throw new UnsupportedOperationException("VCard provider is read-only.");
        }
        Element oldVCard = this.getOrLoadVCard(username);
        if (oldVCard != null) {
            this.vcardCache.remove(username);
            this.provider.deleteVCard(username);
            VCardEventDispatcher.dispatchVCardDeleted(username, oldVCard);
        }
    }

    public Element getVCard(String username) {
        Element vCardElement = this.getOrLoadVCard(username);
        return vCardElement == null ? null : vCardElement.createCopy();
    }

    private Element getOrLoadVCard(String username) {
        Element vCardElement = (Element)this.vcardCache.get(username);
        if (vCardElement == null && (vCardElement = this.provider.loadVCard(username)) != null) {
            this.vcardCache.put(username, vCardElement);
        }
        return vCardElement;
    }

    @Override
    public void initialize(XMPPServer server) {
        instance = this;
        JiveGlobals.migrateProperty("provider.vcard.className");
        String className = JiveGlobals.getProperty("provider.vcard.className", DefaultVCardProvider.class.getName());
        try {
            Class c = ClassUtils.forName(className);
            this.provider = (VCardProvider)c.newInstance();
        }
        catch (Exception e) {
            Log.error("Error loading vcard provider: " + className, (Throwable)e);
            this.provider = new DefaultVCardProvider();
        }
    }

    @Override
    public void start() {
        if (!this.provider.isReadOnly()) {
            UserEventDispatcher.addListener(this.eventHandler);
        }
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("provider.vcard.className".equals(property)) {
                    VCardManager.this.initialize(XMPPServer.getInstance());
                }
            }

            public void propertyDeleted(String property, Map params) {
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }

    @Override
    public void stop() {
        UserEventDispatcher.removeListener(this.eventHandler);
    }

    public void reset() {
        this.vcardCache.clear();
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton("vcard-temp").iterator();
    }

    private class EventHandler
    extends UserEventAdapter {
        private EventHandler() {
        }

        @Override
        public void userDeleting(User user, Map params) {
            try {
                VCardManager.this.deleteVCard(user.getUsername());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

