/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.stats;

import org.jivesoftware.openfire.stats.Statistic;
import org.jivesoftware.util.LocaleUtils;

public abstract class i18nStatistic
implements Statistic {
    private String resourceKey;
    private String pluginName;
    private Statistic.Type statisticType;

    public i18nStatistic(String resourceKey, Statistic.Type statisticType) {
        this(resourceKey, null, statisticType);
    }

    public i18nStatistic(String resourceKey, String pluginName, Statistic.Type statisticType) {
        this.resourceKey = resourceKey;
        this.pluginName = pluginName;
        this.statisticType = statisticType;
    }

    @Override
    public final String getName() {
        return this.retrieveValue("name");
    }

    @Override
    public final Statistic.Type getStatType() {
        return this.statisticType;
    }

    @Override
    public final String getDescription() {
        return this.retrieveValue("desc");
    }

    @Override
    public final String getUnits() {
        return this.retrieveValue("units");
    }

    private String retrieveValue(String key) {
        String wholeKey = "stat." + this.resourceKey + "." + key;
        if (this.pluginName != null) {
            return LocaleUtils.getLocalizedString(wholeKey, this.pluginName);
        }
        return LocaleUtils.getLocalizedString(wholeKey);
    }
}

