/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.jivesoftware.openfire.XMPPServerInfo;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMPPServerInfoImpl
implements XMPPServerInfo {
    private static final Logger Log = LoggerFactory.getLogger(XMPPServerInfoImpl.class);
    private final Date startDate;
    public static final Version VERSION = new Version(4, 2, 0, Version.ReleaseStatus.Release, -1);

    public XMPPServerInfoImpl(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    @Override
    public String getHostname() {
        String fqdn = JiveGlobals.getProperty("xmpp.fqdn");
        if (fqdn != null && !fqdn.trim().isEmpty()) {
            return fqdn.trim().toLowerCase();
        }
        try {
            return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException ex) {
            Log.warn("Unable to determine local hostname.", (Throwable)ex);
            return "localhost";
        }
    }

    @Override
    public void setHostname(String fqdn) {
        if (fqdn == null || fqdn.isEmpty()) {
            JiveGlobals.deleteProperty("xmpp.fqdn");
        } else {
            JiveGlobals.setProperty("xmpp.fqdn", fqdn.toLowerCase());
        }
    }

    @Override
    public String getXMPPDomain() {
        return JiveGlobals.getProperty("xmpp.domain", this.getHostname()).toLowerCase();
    }

    @Override
    public Date getLastStarted() {
        return this.startDate;
    }
}

