/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.ConnectionManager;
import org.jivesoftware.openfire.ServerPort;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginManagerListener;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.CertificateStoreManager;
import org.jivesoftware.openfire.net.SocketSendingTracker;
import org.jivesoftware.openfire.spi.ConnectionListener;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.CertificateEventListener;
import org.jivesoftware.util.CertificateManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerImpl
extends BasicModule
implements ConnectionManager,
CertificateEventListener,
PropertyEventListener {
    public static final String EXECUTOR_FILTER_NAME = "threadModel";
    public static final String TLS_FILTER_NAME = "tls";
    public static final String COMPRESSION_FILTER_NAME = "compression";
    public static final String XMPP_CODEC_FILTER_NAME = "xmpp";
    public static final String CAPACITY_FILTER_NAME = "outCap";
    private static final Logger Log = LoggerFactory.getLogger(ConnectionManagerImpl.class);
    private final ConnectionListener clientListener;
    private final ConnectionListener clientSslListener;
    private final ConnectionListener boshListener;
    private final ConnectionListener boshSslListener;
    private final ConnectionListener serverListener;
    private final ConnectionListener componentListener;
    private final ConnectionListener componentSslListener;
    private final ConnectionListener connectionManagerListener;
    private final ConnectionListener connectionManagerSslListener;
    private final ConnectionListener webAdminListener;
    private final ConnectionListener webAdminSslListener;

    public ConnectionManagerImpl() throws IOException {
        super("Connection Manager");
        InetAddress bindAddress = null;
        InetAddress adminConsoleBindAddress = null;
        try {
            bindAddress = this.getListenAddress();
        }
        catch (UnknownHostException e) {
            Log.warn("Unable to resolve bind address: ", (Throwable)e);
        }
        try {
            adminConsoleBindAddress = this.getAdminConsoleListenAddress();
            if (adminConsoleBindAddress == null) {
                adminConsoleBindAddress = bindAddress;
            }
        }
        catch (UnknownHostException e) {
            Log.warn("Unable to resolve admin console bind address: ", (Throwable)e);
        }
        CertificateStoreManager certificateStoreManager = XMPPServer.getInstance().getCertificateStoreManager();
        this.clientListener = new ConnectionListener(ConnectionType.SOCKET_C2S, "xmpp.socket.plain.port", 5222, "xmpp.socket.plain.active", "xmpp.client.processing.threads", "xmpp.client.maxReadBufferSize", "xmpp.client.tls.policy", "xmpp.client.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.SOCKET_C2S), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.SOCKET_C2S), "xmpp.client.compression.policy");
        this.clientSslListener = new ConnectionListener(ConnectionType.SOCKET_C2S, "xmpp.socket.ssl.port", 5223, "xmpp.socket.ssl.active", "xmpp.client_ssl.processing.threads", "xmpp.client_ssl.maxReadBufferSize", Connection.TLSPolicy.legacyMode.name(), "xmpp.client.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.SOCKET_C2S), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.SOCKET_C2S), "xmpp.client.compression.policy");
        this.boshListener = new ConnectionListener(ConnectionType.BOSH_C2S, "httpbind.port.plain", 7070, "httpbind.enabled", "httpbind.client.processing.threads", null, Connection.TLSPolicy.disabled.name(), "httpbind.client.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.BOSH_C2S), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.BOSH_C2S), "xmpp.client.compression.policy");
        this.boshSslListener = new ConnectionListener(ConnectionType.BOSH_C2S, "httpbind.port.secure", 7443, "httpbind.enabled", "httpbind.client.processing.threads", null, Connection.TLSPolicy.legacyMode.name(), "httpbind.client.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.BOSH_C2S), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.BOSH_C2S), "xmpp.client.compression.policy");
        this.serverListener = new ConnectionListener(ConnectionType.SOCKET_S2S, "xmpp.server.socket.port", 5269, "xmpp.server.socket.active", "xmpp.server.processing.threads", null, "xmpp.server.tls.policy", "xmpp.server.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.SOCKET_S2S), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.SOCKET_S2S), "xmpp.server.compression.policy");
        this.componentListener = new ConnectionListener(ConnectionType.COMPONENT, "xmpp.component.socket.port", 5275, "xmpp.component.socket.active", "xmpp.component.processing.threads", null, "xmpp.component.tls.policy", "xmpp.component.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.COMPONENT), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.COMPONENT), "xmpp.component.compression.policy");
        this.componentSslListener = new ConnectionListener(ConnectionType.COMPONENT, "xmpp.component.ssl.port", 5276, "xmpp.component.ssl.active", "xmpp.component.ssl.processing.threads", null, Connection.TLSPolicy.legacyMode.name(), "xmpp.component.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.COMPONENT), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.COMPONENT), "xmpp.component.compression.policy");
        this.connectionManagerListener = new ConnectionListener(ConnectionType.CONNECTION_MANAGER, "xmpp.multiplex.socket.port", 5262, "xmpp.multiplex.socket.active", "xmpp.multiplex.processing.threads", null, "xmpp.multiplex.tls.policy", "xmpp.multiplex.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.CONNECTION_MANAGER), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.CONNECTION_MANAGER), "xmpp.multiplex.compression.policy");
        this.connectionManagerSslListener = new ConnectionListener(ConnectionType.CONNECTION_MANAGER, "xmpp.multiplex.ssl.port", 5263, "xmpp.multiplex.ssl.active", "xmpp.multiplex.ssl.processing.threads", null, Connection.TLSPolicy.legacyMode.name(), "xmpp.multiplex.cert.policy", bindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.CONNECTION_MANAGER), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.CONNECTION_MANAGER), "xmpp.multiplex.compression.policy");
        this.webAdminListener = new ConnectionListener(ConnectionType.WEBADMIN, "adminConsole.port", 9090, null, "adminConsole.serverThreads", null, Connection.TLSPolicy.disabled.name(), null, adminConsoleBindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.WEBADMIN), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.WEBADMIN), null);
        this.webAdminSslListener = new ConnectionListener(ConnectionType.WEBADMIN, "adminConsole.securePort", 9091, null, "adminConsole.serverThreads", null, Connection.TLSPolicy.legacyMode.name(), null, adminConsoleBindAddress, certificateStoreManager.getIdentityStoreConfiguration(ConnectionType.WEBADMIN), certificateStoreManager.getTrustStoreConfiguration(ConnectionType.WEBADMIN), null);
    }

    private synchronized void startListeners() {
        Log.debug("Received a request to start listeners. Have plugins been loaded?");
        PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        if (!pluginManager.isExecuted()) {
            Log.debug("Plugins not yet loaded. Waiting for plugins to be loaded...");
            pluginManager.addPluginManagerListener(new PluginManagerListener(){

                @Override
                public void pluginsMonitored() {
                    Log.debug("Received plugin monitor event! Plugins should now be loaded.");
                    XMPPServer.getInstance().getPluginManager().removePluginManagerListener(this);
                    ConnectionManagerImpl.this.startListeners();
                }
            });
            return;
        }
        Log.debug("Starting listeners...");
        for (ConnectionListener listener : this.getListeners()) {
            try {
                listener.start();
                Log.debug("Started '{}' (port {}) listener.", (Object)listener.getType(), (Object)listener.getPort());
            }
            catch (RuntimeException ex) {
                Log.error("An exception occurred while starting listener " + listener, (Throwable)ex);
            }
        }
        try {
            HttpBindManager.getInstance().start();
            Log.debug("Started HTTP client listener.");
        }
        catch (RuntimeException ex) {
            Log.error("An exception occurred while starting HTTP Bind listener ", (Throwable)ex);
        }
    }

    private synchronized void stopListeners() {
        for (ConnectionListener listener : this.getListeners()) {
            try {
                listener.stop();
            }
            catch (RuntimeException ex) {
                Log.error("An exception occurred while stopping listener " + listener, (Throwable)ex);
            }
        }
        try {
            HttpBindManager.getInstance().stop();
        }
        catch (RuntimeException ex) {
            Log.error("An exception occurred while stopping HTTP Bind listener ", (Throwable)ex);
        }
    }

    public InetAddress getListenAddress() throws UnknownHostException {
        String interfaceName = JiveGlobals.getXMLProperty("network.interface");
        InetAddress bindInterface = null;
        if (interfaceName != null && interfaceName.trim().length() > 0) {
            bindInterface = InetAddress.getByName(interfaceName);
        }
        return bindInterface;
    }

    public InetAddress getAdminConsoleListenAddress() throws UnknownHostException {
        String acInterfaceName = JiveGlobals.getXMLProperty("adminConsole.interface");
        InetAddress acBindInterface = null;
        if (acInterfaceName != null && acInterfaceName.trim().length() > 0) {
            acBindInterface = InetAddress.getByName(acInterfaceName);
        }
        return acBindInterface;
    }

    public Set<ConnectionListener> getListeners() {
        LinkedHashSet<ConnectionListener> listeners = new LinkedHashSet<ConnectionListener>();
        listeners.add(this.clientListener);
        listeners.add(this.clientSslListener);
        listeners.add(this.boshListener);
        listeners.add(this.boshSslListener);
        listeners.add(this.serverListener);
        listeners.add(this.componentListener);
        listeners.add(this.componentSslListener);
        listeners.add(this.connectionManagerListener);
        listeners.add(this.connectionManagerSslListener);
        listeners.add(this.webAdminListener);
        listeners.add(this.webAdminSslListener);
        return listeners;
    }

    public ConnectionListener getListener(ConnectionType type, boolean startInSslMode) {
        switch (type) {
            case SOCKET_C2S: {
                if (startInSslMode) {
                    return this.clientSslListener;
                }
                return this.clientListener;
            }
            case BOSH_C2S: {
                if (startInSslMode) {
                    return this.boshSslListener;
                }
                return this.boshListener;
            }
            case SOCKET_S2S: {
                return this.serverListener;
            }
            case COMPONENT: {
                if (startInSslMode) {
                    return this.componentSslListener;
                }
                return this.componentListener;
            }
            case CONNECTION_MANAGER: {
                if (startInSslMode) {
                    return this.connectionManagerSslListener;
                }
                return this.connectionManagerListener;
            }
            case WEBADMIN: {
                if (startInSslMode) {
                    return this.webAdminSslListener;
                }
                return this.webAdminListener;
            }
        }
        throw new IllegalStateException("Unknown connection type: " + (Object)((Object)type));
    }

    public Set<ConnectionListener> getListeners(ConnectionType type) {
        HashSet<ConnectionListener> result = new HashSet<ConnectionListener>();
        switch (type) {
            case SOCKET_C2S: {
                result.add(this.clientListener);
                result.add(this.clientSslListener);
                break;
            }
            case BOSH_C2S: {
                result.add(this.boshListener);
                result.add(this.boshSslListener);
            }
            case SOCKET_S2S: {
                result.add(this.serverListener);
                break;
            }
            case COMPONENT: {
                result.add(this.componentListener);
                result.add(this.componentSslListener);
                break;
            }
            case CONNECTION_MANAGER: {
                result.add(this.connectionManagerListener);
                result.add(this.connectionManagerSslListener);
                break;
            }
            case WEBADMIN: {
                result.add(this.webAdminListener);
                result.add(this.webAdminSslListener);
            }
            default: {
                throw new IllegalStateException("Unknown connection type: " + (Object)((Object)type));
            }
        }
        return result;
    }

    public boolean isEnabled(ConnectionType type, boolean startInSslMode) {
        return this.getListener(type, startInSslMode).isEnabled();
    }

    public void enable(ConnectionType type, boolean startInSslMode, boolean enabled) {
        this.getListener(type, startInSslMode).enable(enabled);
    }

    public int getPort(ConnectionType type, boolean startInSslMode) {
        return this.getListener(type, startInSslMode).getPort();
    }

    public void setPort(ConnectionType type, boolean startInSslMode, int port) {
        this.getListener(type, startInSslMode).setPort(port);
    }

    public NioSocketAcceptor getSocketAcceptor(ConnectionType type, boolean startInSslMode) {
        return this.getListener(type, startInSslMode).getSocketAcceptor();
    }

    @Override
    public void storeContentChanged(CertificateStore store) {
        for (ConnectionListener listener : this.getListeners()) {
            if (!listener.getIdentityStoreConfiguration().equals(store.getConfiguration()) && !listener.getTrustStoreConfiguration().equals(store.getConfiguration())) continue;
            try {
                listener.reloadConfiguration();
            }
            catch (RuntimeException ex) {
                Log.error("An exception occurred while reloading listener " + listener + ". The reason for the reload was a certificate store change.", (Throwable)ex);
            }
        }
    }

    @Override
    public void propertySet(String property, Map<String, Object> params) {
        this.processPropertyValueChange(property, params);
    }

    @Override
    public void propertyDeleted(String property, Map<String, Object> params) {
        this.processPropertyValueChange(property, params);
    }

    @Override
    public void xmlPropertySet(String property, Map<String, Object> params) {
        this.processPropertyValueChange(property, params);
    }

    @Override
    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
        this.processPropertyValueChange(property, params);
    }

    private void processPropertyValueChange(String property, Map<String, Object> params) {
        Log.debug("Processing property value change for '" + property + "'. Params: " + params);
        if ("xmpp.client.cert.policy".equalsIgnoreCase(property)) {
            this.clientSslListener.restart();
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        if (JiveGlobals.getBooleanProperty("xmpp.socket.heapBuffer", true)) {
            IoBuffer.setUseDirectBuffer((boolean)false);
            IoBuffer.setAllocator((IoBufferAllocator)new SimpleBufferAllocator());
        }
    }

    @Override
    public void start() {
        super.start();
        this.startListeners();
        SocketSendingTracker.getInstance().start();
        CertificateManager.addListener(this);
    }

    @Override
    public void stop() {
        CertificateManager.removeListener(this);
        SocketSendingTracker.getInstance().shutdown();
        this.stopListeners();
        super.stop();
    }

    @Override
    @Deprecated
    public void enableClientListener(boolean enabled) {
        this.enable(ConnectionType.SOCKET_C2S, false, enabled);
    }

    @Override
    @Deprecated
    public boolean isClientListenerEnabled() {
        return this.isEnabled(ConnectionType.SOCKET_C2S, false);
    }

    @Deprecated
    public NioSocketAcceptor getSocketAcceptor() {
        return this.getSocketAcceptor(ConnectionType.SOCKET_C2S, false);
    }

    @Override
    @Deprecated
    public void setClientListenerPort(int port) {
        this.setPort(ConnectionType.SOCKET_C2S, false, port);
    }

    @Override
    @Deprecated
    public int getClientListenerPort() {
        return this.getPort(ConnectionType.SOCKET_C2S, false);
    }

    @Override
    @Deprecated
    public void enableClientSSLListener(boolean enabled) {
        this.enable(ConnectionType.SOCKET_C2S, true, enabled);
    }

    @Override
    @Deprecated
    public boolean isClientSSLListenerEnabled() {
        return this.isEnabled(ConnectionType.SOCKET_C2S, true);
    }

    @Deprecated
    public NioSocketAcceptor getSSLSocketAcceptor() {
        return this.getSocketAcceptor(ConnectionType.SOCKET_C2S, true);
    }

    @Override
    @Deprecated
    public void setClientSSLListenerPort(int port) {
        this.setPort(ConnectionType.SOCKET_C2S, true, port);
    }

    @Override
    @Deprecated
    public int getClientSSLListenerPort() {
        return this.getPort(ConnectionType.SOCKET_C2S, true);
    }

    @Override
    @Deprecated
    public void enableComponentListener(boolean enabled) {
        this.enable(ConnectionType.COMPONENT, false, enabled);
    }

    @Override
    @Deprecated
    public boolean isComponentListenerEnabled() {
        return this.isEnabled(ConnectionType.COMPONENT, false);
    }

    @Deprecated
    public NioSocketAcceptor getComponentAcceptor() {
        return this.getSocketAcceptor(ConnectionType.COMPONENT, false);
    }

    @Override
    @Deprecated
    public void setComponentListenerPort(int port) {
        this.setPort(ConnectionType.COMPONENT, false, port);
    }

    @Override
    @Deprecated
    public int getComponentListenerPort() {
        return this.getPort(ConnectionType.COMPONENT, false);
    }

    @Deprecated
    public void enableComponentSslListener(boolean enabled) {
        this.enable(ConnectionType.COMPONENT, true, enabled);
    }

    @Deprecated
    public boolean isComponentSslListenerEnabled() {
        return this.isEnabled(ConnectionType.COMPONENT, true);
    }

    @Deprecated
    public NioSocketAcceptor getComponentSslAcceptor() {
        return this.getSocketAcceptor(ConnectionType.COMPONENT, true);
    }

    @Deprecated
    public void setComponentSslListenerPort(int port) {
        this.setPort(ConnectionType.COMPONENT, true, port);
    }

    @Deprecated
    public int getComponentSslListenerPort() {
        return this.getPort(ConnectionType.COMPONENT, true);
    }

    @Override
    @Deprecated
    public void enableServerListener(boolean enabled) {
        this.enable(ConnectionType.SOCKET_S2S, false, enabled);
    }

    @Override
    @Deprecated
    public boolean isServerListenerEnabled() {
        return this.isEnabled(ConnectionType.SOCKET_S2S, false);
    }

    @Deprecated
    public NioSocketAcceptor getServerListenerSocketAcceptor() {
        return this.getSocketAcceptor(ConnectionType.SOCKET_S2S, false);
    }

    @Override
    @Deprecated
    public void setServerListenerPort(int port) {
        this.setPort(ConnectionType.SOCKET_S2S, false, port);
    }

    @Override
    @Deprecated
    public int getServerListenerPort() {
        return this.getPort(ConnectionType.SOCKET_S2S, false);
    }

    @Override
    @Deprecated
    public void enableConnectionManagerListener(boolean enabled) {
        this.enable(ConnectionType.CONNECTION_MANAGER, false, enabled);
    }

    @Override
    @Deprecated
    public boolean isConnectionManagerListenerEnabled() {
        return this.isEnabled(ConnectionType.CONNECTION_MANAGER, false);
    }

    @Deprecated
    public NioSocketAcceptor getMultiplexerSocketAcceptor() {
        return this.getSocketAcceptor(ConnectionType.CONNECTION_MANAGER, false);
    }

    @Deprecated
    public NioSocketAcceptor getConnectionManagerSocketAcceptor() {
        return this.getSocketAcceptor(ConnectionType.CONNECTION_MANAGER, false);
    }

    @Override
    @Deprecated
    public void setConnectionManagerListenerPort(int port) {
        this.setPort(ConnectionType.CONNECTION_MANAGER, false, port);
    }

    @Override
    @Deprecated
    public int getConnectionManagerListenerPort() {
        return this.getPort(ConnectionType.CONNECTION_MANAGER, false);
    }

    @Deprecated
    public void enableConnectionManagerSslListener(boolean enabled) {
        this.enable(ConnectionType.CONNECTION_MANAGER, true, enabled);
    }

    @Deprecated
    public boolean isConnectionManagerSslListenerEnabled() {
        return this.isEnabled(ConnectionType.CONNECTION_MANAGER, true);
    }

    @Deprecated
    public NioSocketAcceptor getConnectionManagerSslSocketAcceptor() {
        return this.getSocketAcceptor(ConnectionType.CONNECTION_MANAGER, true);
    }

    @Deprecated
    public void setConnectionManagerSslListenerPort(int port) {
        this.setPort(ConnectionType.CONNECTION_MANAGER, true, port);
    }

    @Deprecated
    public int getConnectionManagerSslListenerPort() {
        return this.getPort(ConnectionType.CONNECTION_MANAGER, true);
    }

    @Override
    @Deprecated
    public Collection<ServerPort> getPorts() {
        LinkedHashSet<ServerPort> result = new LinkedHashSet<ServerPort>();
        for (ConnectionListener listener : this.getListeners()) {
            if (listener.getServerPort() == null) continue;
            result.add(listener.getServerPort());
        }
        return result;
    }
}

