/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.util.Locale;
import java.util.Set;
import org.dom4j.Element;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.multiplex.ConnectionMultiplexerManager;
import org.jivesoftware.openfire.multiplex.MultiplexerPacketDeliverer;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.session.ConnectionMultiplexerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.StreamError;

public class LocalConnectionMultiplexerSession
extends LocalSession
implements ConnectionMultiplexerSession {
    private static final Logger Log = LoggerFactory.getLogger(LocalConnectionMultiplexerSession.class);

    public static LocalConnectionMultiplexerSession createSession(String serverName, XmlPullParser xpp, Connection connection) throws XmlPullParserException {
        String domain = xpp.getAttributeValue("", "to");
        Log.debug("LocalConnectionMultiplexerSession: [ConMng] Starting registration of new connection manager for domain: " + domain);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='");
        sb.append(CHARSET);
        sb.append("'?>");
        sb.append("<stream:stream ");
        sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" ");
        sb.append("xmlns=\"jabber:connectionmanager\" from=\"");
        sb.append(domain);
        sb.append("\" version=\"1.0\">");
        if (domain == null) {
            Log.debug("LocalConnectionMultiplexerSession: [ConMng] Domain not specified in stanza: " + xpp.getText());
            StreamError error = new StreamError(StreamError.Condition.bad_format);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        JID address = new JID(domain);
        String secretKey = ConnectionMultiplexerManager.getDefaultSecret();
        if (secretKey == null) {
            Log.debug("LocalConnectionMultiplexerSession: [ConMng] A shared secret for connection manager was not found.");
            StreamError error = new StreamError(StreamError.Condition.internal_server_error);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        if (SessionManager.getInstance().getConnectionMultiplexerSession(address) != null) {
            Log.debug("LocalConnectionMultiplexerSession: [ConMng] Another connection manager is already using domain: " + domain);
            StreamError error = new StreamError(StreamError.Condition.conflict);
            sb.append(error.toXML());
            connection.deliverRawText(sb.toString());
            connection.close();
            return null;
        }
        connection.setTlsPolicy(connection.getConfiguration().getTlsPolicy());
        connection.setCompressionPolicy(connection.getConfiguration().getCompressionPolicy());
        ((MultiplexerPacketDeliverer)connection.getPacketDeliverer()).setConnectionManagerDomain(address.getDomain());
        LocalConnectionMultiplexerSession session = SessionManager.getInstance().createMultiplexerSession(connection, address);
        session.setAddress(address);
        connection.init(session);
        try {
            String specificFeatures;
            Log.debug("LocalConnectionMultiplexerSession: [ConMng] Send stream header with ID: " + session.getStreamID() + " for connection manager with domain: " + domain);
            sb = new StringBuilder();
            sb.append("<?xml version='1.0' encoding='");
            sb.append(CHARSET);
            sb.append("'?>");
            sb.append("<stream:stream ");
            sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" ");
            sb.append("xmlns=\"jabber:connectionmanager\" from=\"");
            sb.append(domain);
            sb.append("\" id=\"");
            sb.append(session.getStreamID().toString());
            sb.append("\" version=\"1.0\" >");
            connection.deliverRawText(sb.toString());
            sb = new StringBuilder(490);
            sb.append("<stream:features>");
            if (connection.getTlsPolicy() != Connection.TLSPolicy.disabled) {
                sb.append("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\">");
                if (connection.getTlsPolicy() == Connection.TLSPolicy.required) {
                    sb.append("<required/>");
                }
                sb.append("</starttls>");
            }
            if ((specificFeatures = session.getAvailableStreamFeatures()) != null) {
                sb.append(specificFeatures);
            }
            sb.append("</stream:features>");
            connection.deliverRawText(sb.toString());
            return session;
        }
        catch (Exception e) {
            Log.error("An error occured while creating a Connection Manager Session", (Throwable)e);
            connection.close();
            return null;
        }
    }

    public LocalConnectionMultiplexerSession(String serverName, Connection connection, StreamID streamID) {
        super(serverName, connection, streamID, Locale.getDefault());
    }

    @Override
    public String getAvailableStreamFeatures() {
        if (this.conn.getTlsPolicy() == Connection.TLSPolicy.required && !this.conn.isSecure()) {
            return null;
        }
        if (this.conn.getCompressionPolicy() != Connection.CompressionPolicy.disabled && !this.conn.isCompressed()) {
            return "<compression xmlns=\"http://jabber.org/features/compress\"><method>zlib</method></compression>";
        }
        return null;
    }

    public boolean authenticate(String digest) {
        String anticipatedDigest = AuthFactory.createDigest(this.getStreamID().getID(), ConnectionMultiplexerManager.getDefaultSecret());
        if (!anticipatedDigest.equalsIgnoreCase(digest)) {
            Log.debug("LocalConnectionMultiplexerSession: [ConMng] Incorrect handshake for connection manager with domain: " + this.getAddress().getDomain());
            this.conn.deliverRawText(new StreamError(StreamError.Condition.not_authorized).toXML());
            this.conn.close();
            return false;
        }
        this.setStatus(3);
        this.conn.deliverRawText("<handshake></handshake>");
        Log.debug("LocalConnectionMultiplexerSession: [ConMng] Connection manager was AUTHENTICATED with domain: " + this.getAddress());
        this.sendClientOptions();
        return true;
    }

    private void sendClientOptions() {
        Set<String> mechanisms;
        ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        ConnectionConfiguration configuration = connectionManager.getListener(ConnectionType.SOCKET_C2S, false).generateConnectionConfiguration();
        IQ options = new IQ(IQ.Type.set);
        Element child = options.setChildElement("configuration", "http://jabber.org/protocol/connectionmanager");
        if (configuration.getTlsPolicy() != Connection.TLSPolicy.disabled) {
            Element tls = child.addElement("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
            if (configuration.getTlsPolicy() == Connection.TLSPolicy.required) {
                tls.addElement("required");
            }
        }
        if (!(mechanisms = SASLAuthentication.getSupportedMechanisms()).isEmpty()) {
            Element sasl = child.addElement("mechanisms", "urn:ietf:params:xml:ns:xmpp-sasl");
            for (String mechanism : mechanisms) {
                sasl.addElement("mechanism").setText(mechanism);
            }
        }
        if (configuration.getCompressionPolicy() == Connection.CompressionPolicy.optional) {
            Element comp = child.addElement("compression", "http://jabber.org/features/compress");
            comp.addElement("method").setText("zlib");
        }
        if (XMPPServer.getInstance().getIQRouter().supports("jabber:iq:auth")) {
            child.addElement("auth", "http://jabber.org/features/iq-auth");
        }
        if (XMPPServer.getInstance().getIQRegisterHandler().isInbandRegEnabled()) {
            child.addElement("register", "http://jabber.org/features/iq-register");
        }
        this.process((Packet)options);
    }

    @Override
    boolean canProcess(Packet packet) {
        return true;
    }

    @Override
    void deliver(Packet packet) throws UnauthorizedException {
        if (!this.conn.isClosed()) {
            this.conn.deliver(packet);
        }
    }
}

