/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.Presence;

public class ClientSessionInfo
implements Externalizable {
    private Presence presence;
    private String defaultList;
    private String activeList;
    private boolean offlineFloodStopped;

    public ClientSessionInfo() {
    }

    public ClientSessionInfo(LocalClientSession session) {
        this.presence = session.getPresence();
        this.defaultList = session.getDefaultList() != null ? session.getDefaultList().getName() : null;
        this.activeList = session.getActiveList() != null ? session.getActiveList().getName() : null;
        this.offlineFloodStopped = session.isOfflineFloodStopped();
    }

    public Presence getPresence() {
        return this.presence;
    }

    public String getDefaultList() {
        return this.defaultList;
    }

    public String getActiveList() {
        return this.activeList;
    }

    public boolean isOfflineFloodStopped() {
        return this.offlineFloodStopped;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((DefaultElement)this.presence.getElement()));
        ExternalizableUtil.getInstance().writeBoolean(out, this.defaultList != null);
        if (this.defaultList != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.defaultList);
        }
        ExternalizableUtil.getInstance().writeBoolean(out, this.activeList != null);
        if (this.activeList != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.activeList);
        }
        ExternalizableUtil.getInstance().writeBoolean(out, this.offlineFloodStopped);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Element packetElement = (Element)ExternalizableUtil.getInstance().readSerializable(in);
        this.presence = new Presence(packetElement, true);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.defaultList = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.activeList = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
        this.offlineFloodStopped = ExternalizableUtil.getInstance().readBoolean(in);
    }
}

