/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.LocalOutgoingServerSession;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class OutgoingSessionPromise
implements RoutableChannelHandler {
    private static final Logger Log = LoggerFactory.getLogger(OutgoingSessionPromise.class);
    private static OutgoingSessionPromise instance = new OutgoingSessionPromise();
    private BlockingQueue<Packet> packets = new LinkedBlockingQueue<Packet>(10000);
    private ThreadPoolExecutor threadPool;
    private Map<String, PacketsProcessor> packetsProcessors = new HashMap<String, PacketsProcessor>();
    private Cache<String, byte[]> serversCache;
    private boolean shutdown = false;
    private RoutingTable routingTable;

    private OutgoingSessionPromise() {
        this.init();
    }

    private void init() {
        this.serversCache = CacheFactory.createCache("Routing Servers Cache");
        this.routingTable = XMPPServer.getInstance().getRoutingTable();
        int maxThreads = JiveGlobals.getIntProperty("xmpp.server.outgoing.max.threads", 20);
        int queueSize = JiveGlobals.getIntProperty("xmpp.server.outgoing.queue", 50);
        if (maxThreads < 10) {
            maxThreads = 10;
        }
        this.threadPool = new ThreadPoolExecutor(maxThreads / 4, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!OutgoingSessionPromise.this.shutdown) {
                    try {
                        if (OutgoingSessionPromise.this.threadPool.getActiveCount() < OutgoingSessionPromise.this.threadPool.getMaximumPoolSize()) {
                            PacketsProcessor packetsProcessor;
                            Packet packet = (Packet)OutgoingSessionPromise.this.packets.take();
                            boolean newProcessor = false;
                            String domain = packet.getTo().getDomain();
                            String string = domain.intern();
                            synchronized (string) {
                                packetsProcessor = (PacketsProcessor)OutgoingSessionPromise.this.packetsProcessors.get(domain);
                                if (packetsProcessor == null) {
                                    packetsProcessor = new PacketsProcessor(OutgoingSessionPromise.this, domain);
                                    OutgoingSessionPromise.this.packetsProcessors.put(domain, packetsProcessor);
                                    newProcessor = true;
                                }
                                packetsProcessor.addPacket(packet);
                            }
                            if (!newProcessor) continue;
                            OutgoingSessionPromise.this.threadPool.execute(packetsProcessor);
                            continue;
                        }
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException packet) {
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }, "Queued Packets Processor");
        thread.setDaemon(true);
        thread.start();
    }

    public static OutgoingSessionPromise getInstance() {
        return instance;
    }

    public void shutdown() {
        this.threadPool.shutdown();
        this.shutdown = true;
    }

    @Override
    public JID getAddress() {
        return null;
    }

    @Override
    public void process(Packet packet) {
        this.packets.add(packet.createCopy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processorDone(PacketsProcessor packetsProcessor) {
        String string = packetsProcessor.getDomain().intern();
        synchronized (string) {
            if (packetsProcessor.isDone()) {
                this.packetsProcessors.remove(packetsProcessor.getDomain());
            } else {
                this.threadPool.execute(packetsProcessor);
            }
        }
    }

    private class PacketsProcessor
    implements Runnable {
        private final Logger Log = LoggerFactory.getLogger(PacketsProcessor.class);
        private OutgoingSessionPromise promise;
        private String domain;
        private Queue<Packet> packetQueue = new ArrayBlockingQueue<Packet>(JiveGlobals.getIntProperty("xmpp.server.outgoing.queue", 50));
        private long failureTimestamp = -1L;

        public PacketsProcessor(OutgoingSessionPromise promise, String domain) {
            this.promise = promise;
            this.domain = domain;
        }

        @Override
        public void run() {
            while (!this.isDone()) {
                Packet packet = this.packetQueue.poll();
                if (packet == null) continue;
                if (this.failureTimestamp > 0L) {
                    if (System.currentTimeMillis() - this.failureTimestamp < 5000L) {
                        this.returnErrorToSender(packet);
                        this.Log.debug("Error sending packet to domain '{}' (fast discard): {}", (Object)this.domain, (Object)packet);
                        continue;
                    }
                    this.failureTimestamp = -1L;
                }
                try {
                    this.sendPacket(packet);
                }
                catch (Exception e) {
                    this.returnErrorToSender(packet);
                    this.Log.debug("Error sending packet to domain '{}': {}", new Object[]{this.domain, packet, e});
                    this.failureTimestamp = System.currentTimeMillis();
                }
            }
            this.promise.processorDone(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPacket(Packet packet) throws Exception {
            boolean created;
            Lock lock = CacheFactory.getLock(this.domain + "oss", OutgoingSessionPromise.this.serversCache);
            try {
                lock.lock();
                created = LocalOutgoingServerSession.authenticateDomain(packet.getFrom().getDomain(), packet.getTo().getDomain());
            }
            finally {
                lock.unlock();
            }
            if (created) {
                if (!OutgoingSessionPromise.this.routingTable.hasServerRoute(new DomainPair(packet.getFrom().getDomain(), packet.getTo().getDomain()))) {
                    throw new Exception("Route created but not found!!!");
                }
            } else {
                throw new Exception("Failed to create connection to remote server");
            }
            OutgoingSessionPromise.this.routingTable.routePacket(packet.getTo(), packet, false);
        }

        private void returnErrorToSender(Packet packet) {
            XMPPServer server = XMPPServer.getInstance();
            JID from = packet.getFrom();
            JID to = packet.getTo();
            if (!(server.isLocal(from) || XMPPServer.getInstance().matchesComponent(from) || server.isLocal(to) || XMPPServer.getInstance().matchesComponent(to))) {
                return;
            }
            HashSet<Object> replies = new HashSet<Object>();
            try {
                IQ reply;
                if (packet instanceof IQ) {
                    reply = new IQ();
                    reply.setID(packet.getID());
                    reply.setTo(from);
                    reply.setFrom(to);
                    reply.setChildElement(((IQ)packet).getChildElement().createCopy());
                    reply.setError(PacketError.Condition.remote_server_not_found);
                    replies.add(reply);
                } else if (packet instanceof Presence) {
                    ArrayList<JID> routes = new ArrayList<JID>();
                    if (from.getResource() == null || from.getResource().trim().length() == 0) {
                        routes.addAll(OutgoingSessionPromise.this.routingTable.getRoutes(from, null));
                    } else {
                        routes.add(from);
                    }
                    for (JID jID : routes) {
                        Presence reply2 = new Presence();
                        reply2.setID(packet.getID());
                        reply2.setTo(jID);
                        reply2.setFrom(to);
                        reply2.setError(PacketError.Condition.remote_server_not_found);
                        replies.add(reply2);
                    }
                } else if (packet instanceof Message) {
                    reply = new Message();
                    reply.setID(packet.getID());
                    reply.setTo(from);
                    reply.setFrom(to);
                    reply.setType(((Message)packet).getType());
                    reply.setThread(((Message)packet).getThread());
                    reply.setError(PacketError.Condition.remote_server_not_found);
                    replies.add(reply);
                }
                SessionManager sessionManager = SessionManager.getInstance();
                for (Packet packet2 : replies) {
                    try {
                        ClientSession session = sessionManager.getSession(packet2.getTo());
                        InterceptorManager.getInstance().invokeInterceptors(packet2, session, false, false);
                        OutgoingSessionPromise.this.routingTable.routePacket(packet2.getTo(), packet2, true);
                        InterceptorManager.getInstance().invokeInterceptors(packet2, session, false, true);
                    }
                    catch (PacketRejectedException ex) {
                        this.Log.debug("Reply got rejected by an interceptor: ", (Object)packet2, (Object)ex);
                    }
                }
            }
            catch (Exception e) {
                this.Log.warn("An exception occurred while trying to returning a remote-server-not-found error (for domain '{}') to the original sender. Original packet: {}", new Object[]{this.domain, packet, e});
            }
        }

        void addPacket(Packet packet) {
            if (!this.packetQueue.offer(packet)) {
                this.returnErrorToSender(packet);
                this.Log.debug("Error sending packet to domain '{}' (outbound queue full): {}", (Object)this.domain, (Object)packet);
            }
        }

        public String getDomain() {
            return this.domain;
        }

        public boolean isDone() {
            return this.packetQueue.isEmpty();
        }
    }
}

