/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.roster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.UserNameManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;
import org.xmpp.packet.Roster;

public class RosterItem
implements Cacheable,
Externalizable {
    public static final SubType SUB_REMOVE = SubType.REMOVE;
    public static final SubType SUB_NONE = SubType.NONE;
    public static final SubType SUB_TO = SubType.TO;
    public static final SubType SUB_FROM = SubType.FROM;
    public static final SubType SUB_BOTH = SubType.BOTH;
    public static final AskType ASK_NONE = AskType.NONE;
    public static final AskType ASK_SUBSCRIBE = AskType.SUBSCRIBE;
    public static final AskType ASK_UNSUBSCRIBE = AskType.UNSUBSCRIBE;
    public static final RecvType RECV_NONE = RecvType.NONE;
    public static final RecvType RECV_SUBSCRIBE = RecvType.SUBSCRIBE;
    public static final RecvType RECV_UNSUBSCRIBE = RecvType.UNSUBSCRIBE;
    protected RecvType recvStatus;
    protected JID jid;
    protected String nickname;
    protected List<String> groups;
    protected Set<String> sharedGroups = new HashSet<String>();
    protected Set<String> invisibleSharedGroups = new HashSet<String>();
    protected SubType subStatus;
    protected AskType askStatus;
    private long rosterID;

    public RosterItem() {
    }

    public RosterItem(long id, JID jid, SubType subStatus, AskType askStatus, RecvType recvStatus, String nickname, List<String> groups) {
        this(jid, subStatus, askStatus, recvStatus, nickname, groups);
        this.rosterID = id;
    }

    public RosterItem(JID jid, SubType subStatus, AskType askStatus, RecvType recvStatus, String nickname, List<String> groups) {
        this.jid = jid;
        this.subStatus = subStatus;
        this.askStatus = askStatus;
        this.recvStatus = recvStatus;
        this.nickname = nickname;
        this.groups = new LinkedList<String>();
        if (groups != null) {
            for (String group : groups) {
                this.groups.add(group);
            }
        }
    }

    public RosterItem(Roster.Item item) {
        this(item.getJID(), RosterItem.getSubType(item), RosterItem.getAskStatus(item), RECV_NONE, item.getName(), new LinkedList<String>(item.getGroups()));
    }

    public static AskType getAskStatus(Roster.Item item) {
        if (item.getAsk() == Roster.Ask.subscribe) {
            return ASK_SUBSCRIBE;
        }
        if (item.getAsk() == Roster.Ask.unsubscribe) {
            return ASK_UNSUBSCRIBE;
        }
        return ASK_NONE;
    }

    public static SubType getSubType(Roster.Item item) {
        if (item.getSubscription() == Roster.Subscription.to) {
            return SUB_TO;
        }
        if (item.getSubscription() == Roster.Subscription.from) {
            return SUB_FROM;
        }
        if (item.getSubscription() == Roster.Subscription.both) {
            return SUB_BOTH;
        }
        if (item.getSubscription() == Roster.Subscription.remove) {
            return SUB_REMOVE;
        }
        return SUB_NONE;
    }

    public SubType getSubStatus() {
        return this.subStatus;
    }

    public void setSubStatus(SubType subStatus) {
        if ("".equals(this.nickname) && (subStatus == SUB_BOTH || subStatus == SUB_TO)) {
            try {
                this.nickname = UserNameManager.getUserName(this.jid);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
        this.subStatus = subStatus;
    }

    public AskType getAskStatus() {
        if (this.isShared()) {
            return ASK_NONE;
        }
        return this.askStatus;
    }

    public void setAskStatus(AskType askStatus) {
        this.askStatus = askStatus;
    }

    public RecvType getRecvStatus() {
        return this.recvStatus;
    }

    public void setRecvStatus(RecvType recvStatus) {
        this.recvStatus = recvStatus;
    }

    public JID getJid() {
        return this.jid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) throws SharedGroupException {
        if (groups == null) {
            this.groups = new LinkedList<String>();
        } else {
            for (Group group : this.getSharedGroups()) {
                String groupName = (String)group.getProperties().get("sharedRoster.displayName");
                if (groups.contains(groupName)) continue;
                throw new SharedGroupException("Cannot remove item from shared group");
            }
            Iterator<String> it = groups.iterator();
            while (it.hasNext()) {
                String groupName = it.next();
                try {
                    Group group = GroupManager.getInstance().getGroup(groupName);
                    if (!RosterManager.isSharedGroup(group)) continue;
                    it.remove();
                }
                catch (GroupNotFoundException e) {
                    Collection<Group> groupsWithProp = GroupManager.getInstance().search("sharedRoster.displayName", groupName);
                    for (Group group : groupsWithProp) {
                        if (!RosterManager.isSharedGroup(group)) continue;
                        it.remove();
                    }
                }
            }
            this.groups = groups;
        }
    }

    public Collection<Group> getSharedGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.sharedGroups.size());
        for (String groupName : this.sharedGroups) {
            try {
                groups.add(GroupManager.getInstance().getGroup(groupName));
            }
            catch (GroupNotFoundException groupNotFoundException) {}
        }
        return groups;
    }

    public Collection<Group> getInvisibleSharedGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.invisibleSharedGroups.size());
        for (String groupName : this.invisibleSharedGroups) {
            try {
                groups.add(GroupManager.getInstance().getGroup(groupName));
            }
            catch (GroupNotFoundException groupNotFoundException) {}
        }
        return groups;
    }

    Set<String> getInvisibleSharedGroupsNames() {
        return this.invisibleSharedGroups;
    }

    void setInvisibleSharedGroupsNames(Set<String> groupsNames) {
        this.invisibleSharedGroups = groupsNames;
    }

    public void addSharedGroup(Group sharedGroup) {
        this.sharedGroups.add(sharedGroup.getName());
        this.invisibleSharedGroups.remove(sharedGroup.getName());
    }

    public void addInvisibleSharedGroup(Group sharedGroup) {
        this.invisibleSharedGroups.add(sharedGroup.getName());
    }

    public void removeSharedGroup(Group sharedGroup) {
        this.sharedGroups.remove(sharedGroup.getName());
        this.invisibleSharedGroups.remove(sharedGroup.getName());
    }

    public boolean isShared() {
        return !this.sharedGroups.isEmpty() || !this.invisibleSharedGroups.isEmpty();
    }

    public boolean isOnlyShared() {
        return this.isShared() && this.groups.isEmpty();
    }

    public long getID() {
        return this.rosterID;
    }

    public void setID(long rosterID) {
        this.rosterID = rosterID;
    }

    public void setAsCopyOf(Roster.Item item) throws SharedGroupException {
        this.setGroups(new LinkedList<String>(item.getGroups()));
        this.setNickname(item.getName());
    }

    @Override
    public int getCachedSize() throws CannotCalculateSizeException {
        int size = this.jid.toBareJID().length();
        size += CacheSizes.sizeOfString(this.nickname);
        size += CacheSizes.sizeOfCollection(this.groups);
        size += CacheSizes.sizeOfCollection(this.invisibleSharedGroups);
        size += CacheSizes.sizeOfCollection(this.sharedGroups);
        size += CacheSizes.sizeOfInt();
        size += CacheSizes.sizeOfInt();
        size += CacheSizes.sizeOfInt();
        return size += CacheSizes.sizeOfLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.jid);
        ExternalizableUtil.getInstance().writeBoolean(out, this.nickname != null);
        if (this.nickname != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.nickname);
        }
        ExternalizableUtil.getInstance().writeStrings(out, this.groups);
        ExternalizableUtil.getInstance().writeStrings(out, this.sharedGroups);
        ExternalizableUtil.getInstance().writeStrings(out, this.invisibleSharedGroups);
        ExternalizableUtil.getInstance().writeInt(out, this.recvStatus.getValue());
        ExternalizableUtil.getInstance().writeInt(out, this.subStatus.getValue());
        ExternalizableUtil.getInstance().writeInt(out, this.askStatus.getValue());
        ExternalizableUtil.getInstance().writeLong(out, this.rosterID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jid = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.nickname = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
        this.groups = new LinkedList<String>();
        ExternalizableUtil.getInstance().readStrings(in, this.groups);
        ExternalizableUtil.getInstance().readStrings(in, this.sharedGroups);
        ExternalizableUtil.getInstance().readStrings(in, this.invisibleSharedGroups);
        this.recvStatus = RecvType.getTypeFromInt(ExternalizableUtil.getInstance().readInt(in));
        this.subStatus = SubType.getTypeFromInt(ExternalizableUtil.getInstance().readInt(in));
        this.askStatus = AskType.getTypeFromInt(ExternalizableUtil.getInstance().readInt(in));
        this.rosterID = ExternalizableUtil.getInstance().readLong(in);
    }

    public static enum RecvType {
        NONE(-1),
        SUBSCRIBE(1),
        UNSUBSCRIBE(2);

        private final int value;

        private RecvType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecvType getTypeFromInt(int value) {
            for (RecvType recvType : RecvType.values()) {
                if (recvType.value != value) continue;
                return recvType;
            }
            return null;
        }
    }

    public static enum AskType {
        NONE(-1),
        SUBSCRIBE(0),
        UNSUBSCRIBE(1);

        private final int value;

        private AskType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AskType getTypeFromInt(int value) {
            for (AskType askType : AskType.values()) {
                if (askType.value != value) continue;
                return askType;
            }
            return null;
        }
    }

    public static enum SubType {
        REMOVE(-1),
        NONE(0),
        TO(1),
        FROM(2),
        BOTH(3);

        private final int value;

        private SubType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public static SubType getTypeFromInt(int value) {
            for (SubType subType : SubType.values()) {
                if (subType.value != value) continue;
                return subType;
            }
            return null;
        }
    }
}

