/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.pep.PEPServiceManager;
import org.jivesoftware.openfire.pubsub.LeafNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class PublishedItem
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PublishedItem.class);
    private static final int POOL_SIZE = 50;
    private static BlockingQueue<SAXReader> xmlReaders = new LinkedBlockingQueue<SAXReader>(50);
    private static final long serialVersionUID = 7012925993623144574L;
    private JID publisher;
    private volatile transient LeafNode node;
    private String nodeId;
    private String serviceId;
    private String id;
    private Date creationDate;
    private volatile transient Element payload;
    private String payloadXML;

    PublishedItem(LeafNode node, JID publisher, String id, Date creationDate) {
        this.node = node;
        this.nodeId = node.getNodeID();
        this.serviceId = node.getService().getServiceID();
        this.publisher = publisher;
        this.id = id;
        this.creationDate = creationDate;
    }

    public String getNodeID() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeafNode getNode() {
        if (this.node == null) {
            PublishedItem publishedItem = this;
            synchronized (publishedItem) {
                if (this.node == null) {
                    PEPServiceManager serviceMgr;
                    this.node = XMPPServer.getInstance().getPubSubModule().getServiceID().equals(this.serviceId) ? (LeafNode)XMPPServer.getInstance().getPubSubModule().getNode(this.nodeId) : ((serviceMgr = XMPPServer.getInstance().getIQPEPHandler().getServiceManager()).hasCachedService(new JID(this.serviceId)) ? (LeafNode)serviceMgr.getPEPService(this.serviceId).getNode(this.nodeId) : null);
                }
            }
        }
        return this.node;
    }

    public String getID() {
        return this.id;
    }

    public JID getPublisher() {
        return this.publisher;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getPayload() {
        if (this.payload == null && this.payloadXML != null) {
            PublishedItem publishedItem = this;
            synchronized (publishedItem) {
                if (this.payload == null) {
                    SAXReader xmlReader = null;
                    try {
                        xmlReader = xmlReaders.take();
                        this.payload = xmlReader.read((Reader)new StringReader(this.payloadXML)).getRootElement();
                    }
                    catch (Exception ex) {
                        log.error("Failed to parse payload XML", (Throwable)ex);
                    }
                    finally {
                        if (xmlReader != null) {
                            xmlReaders.add(xmlReader);
                        }
                    }
                }
            }
        }
        return this.payload;
    }

    public String getPayloadXML() {
        return this.payloadXML;
    }

    void setPayloadXML(String payloadXML) {
        this.payloadXML = payloadXML;
        this.payload = null;
    }

    void setPayload(Element payload) {
        this.payload = payload;
        this.payloadXML = payload == null ? null : payload.asXML();
    }

    boolean containsKeyword(String keyword) {
        if (this.getPayloadXML() == null || keyword == null) {
            return true;
        }
        return this.payloadXML.contains(keyword);
    }

    public boolean canDelete(JID user) {
        return this.publisher.equals((Object)user) || this.publisher.toBareJID().equals(user.toBareJID()) || this.getNode().isAdmin(user);
    }

    public String getItemKey() {
        return PublishedItem.getItemKey(this.nodeId, this.id);
    }

    public static String getItemKey(LeafNode node, String itemId) {
        return PublishedItem.getItemKey(node.getNodeID(), itemId);
    }

    public static String getItemKey(String nodeId, String itemId) {
        return nodeId + ':' + itemId;
    }

    static {
        for (int i = 0; i < 50; ++i) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            xmlReaders.add(xmlReader);
        }
    }
}

