/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.pubsub.LeafNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class NodeAffiliate {
    private JID jid;
    private Node node;
    private Affiliation affiliation;

    public NodeAffiliate(Node node, JID jid) {
        this.node = node;
        this.jid = jid;
    }

    public Node getNode() {
        return this.node;
    }

    public JID getJID() {
        return this.jid;
    }

    public Affiliation getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(Affiliation affiliation) {
        this.affiliation = affiliation;
    }

    public Collection<NodeSubscription> getSubscriptions() {
        return this.node.getSubscriptions(this.jid);
    }

    void sendPublishedNotifications(Message notification, Element event, LeafNode leafNode, List<PublishedItem> publishedItems) {
        if (!publishedItems.isEmpty()) {
            Map<List<NodeSubscription>, List<PublishedItem>> itemsBySubs = this.getItemsBySubscriptions(leafNode, publishedItems);
            for (List<NodeSubscription> nodeSubscriptions : itemsBySubs.keySet()) {
                Element items = event.addElement("items");
                items.addAttribute("node", this.getNode().getNodeID());
                for (PublishedItem publishedItem : itemsBySubs.get(nodeSubscriptions)) {
                    if (this.getNode().getNodeID().contains("@")) {
                        items.addAttribute("node", publishedItem.getNodeID());
                    }
                    Element item = items.addElement("item");
                    if (leafNode.isItemRequired()) {
                        item.addAttribute("id", publishedItem.getID());
                    }
                    if (leafNode.isPayloadDelivered()) {
                        item.add(publishedItem.getPayload().createCopy());
                    }
                    if (leafNode == this.getNode()) continue;
                    item.addAttribute("node", leafNode.getNodeID());
                }
                this.sendEventNotification(notification, nodeSubscriptions);
                event.remove(items);
            }
        } else {
            ArrayList<NodeSubscription> affectedSubscriptions = new ArrayList<NodeSubscription>();
            for (NodeSubscription subscription : this.getSubscriptions()) {
                if (!subscription.canSendPublicationEvent(leafNode, null)) continue;
                affectedSubscriptions.add(subscription);
            }
            Element items = event.addElement("items");
            items.addAttribute("node", leafNode.getNodeID());
            this.sendEventNotification(notification, affectedSubscriptions);
            event.remove(items);
        }
    }

    void sendDeletionNotifications(Message notification, Element event, LeafNode leafNode, List<PublishedItem> publishedItems) {
        if (!publishedItems.isEmpty()) {
            Map<List<NodeSubscription>, List<PublishedItem>> itemsBySubs = this.getItemsBySubscriptions(leafNode, publishedItems);
            for (List<NodeSubscription> nodeSubscriptions : itemsBySubs.keySet()) {
                Element items = event.addElement("items");
                items.addAttribute("node", leafNode.getNodeID());
                for (PublishedItem publishedItem : itemsBySubs.get(nodeSubscriptions)) {
                    Element item = items.addElement("retract");
                    if (!leafNode.isItemRequired()) continue;
                    item.addAttribute("id", publishedItem.getID());
                }
                this.sendEventNotification(notification, nodeSubscriptions);
                event.remove(items);
            }
        }
    }

    private void sendEventNotification(Message notification, List<NodeSubscription> notifySubscriptions) {
        block5: {
            block4: {
                ArrayList<String> subIDs;
                if (!this.node.isMultipleSubscriptionsEnabled()) break block4;
                HashMap<JID, ArrayList<String>> groupedSubs = new HashMap<JID, ArrayList<String>>();
                for (NodeSubscription subscription : notifySubscriptions) {
                    subIDs = (ArrayList<String>)groupedSubs.get(subscription.getJID());
                    if (subIDs == null) {
                        subIDs = new ArrayList<String>();
                        groupedSubs.put(subscription.getJID(), subIDs);
                    }
                    subIDs.add(subscription.getID());
                }
                for (JID subscriberJID : groupedSubs.keySet()) {
                    subIDs = (Collection)groupedSubs.get(subscriberJID);
                    this.node.sendEventNotification(subscriberJID, notification, subIDs);
                }
                break block5;
            }
            if (notifySubscriptions.isEmpty()) break block5;
            ArrayList<JID> subs = new ArrayList<JID>();
            for (NodeSubscription subscription : notifySubscriptions) {
                JID sub = subscription.getJID();
                if (subs.contains(sub)) continue;
                this.node.sendEventNotification(sub, notification, null);
                subs.add(sub);
            }
        }
    }

    private Map<List<NodeSubscription>, List<PublishedItem>> getItemsBySubscriptions(LeafNode leafNode, List<PublishedItem> publishedItems) {
        HashMap<PublishedItem, ArrayList<NodeSubscription>> subsByItem = new HashMap<PublishedItem, ArrayList<NodeSubscription>>();
        Collection<NodeSubscription> subscriptions = this.getSubscriptions();
        for (PublishedItem publishedItem : publishedItems) {
            for (NodeSubscription subscription : subscriptions) {
                if (!subscription.canSendPublicationEvent(leafNode, publishedItem)) continue;
                ArrayList<NodeSubscription> nodeSubscriptions = (ArrayList<NodeSubscription>)subsByItem.get(publishedItem);
                if (nodeSubscriptions == null) {
                    nodeSubscriptions = new ArrayList<NodeSubscription>();
                    subsByItem.put(publishedItem, nodeSubscriptions);
                }
                nodeSubscriptions.add(subscription);
            }
        }
        HashMap<List<NodeSubscription>, List<PublishedItem>> itemsBySubs = new HashMap<List<NodeSubscription>, List<PublishedItem>>();
        for (PublishedItem publishedItem : subsByItem.keySet()) {
            List affectedSubscriptions = (List)itemsBySubs.get(subsByItem.get(publishedItem));
            if (affectedSubscriptions == null) {
                ArrayList<PublishedItem> items = new ArrayList<PublishedItem>(publishedItems.size());
                items.add(publishedItem);
                itemsBySubs.put((List<NodeSubscription>)subsByItem.get(publishedItem), (List<PublishedItem>)items);
                continue;
            }
            affectedSubscriptions.add(publishedItem);
        }
        return itemsBySubs;
    }

    public String toString() {
        return super.toString() + " - JID: " + this.getJID() + " - Affiliation: " + this.getAffiliation().name();
    }

    public static enum Affiliation {
        owner,
        publisher,
        none,
        outcast;

    }
}

