/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.privacy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.privacy.PrivacyItem;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class PrivacyList
implements Cacheable,
Externalizable {
    private static final Logger Log = LoggerFactory.getLogger(PrivacyList.class);
    private static XmlPullParserFactory factory = null;
    private static ThreadLocal<XMPPPacketReader> localParser = null;
    private JID userJID;
    private String name;
    private boolean isDefault;
    private List<PrivacyItem> items = new ArrayList<PrivacyItem>();

    public PrivacyList() {
    }

    public PrivacyList(String username, String name, boolean isDefault, Element listElement) {
        this.userJID = XMPPServer.getInstance().createJID(username, null, true);
        this.name = name;
        this.isDefault = isDefault;
        this.updateList(listElement);
    }

    public JID getUserJID() {
        return this.userJID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefaultList(boolean isDefault) {
        this.isDefault = isDefault;
        PrivacyListManager.getInstance().dispatchModifiedEvent(this);
    }

    public boolean shouldBlockPacket(Packet packet) {
        if (packet.getFrom() == null) {
            return false;
        }
        Roster roster = this.getRoster();
        for (PrivacyItem item : this.items) {
            if (!item.matchesCondition(packet, roster, this.userJID)) continue;
            if (item.isAllow()) {
                return false;
            }
            if (Log.isDebugEnabled()) {
                Log.debug("PrivacyList: Packet was blocked: " + packet);
            }
            return true;
        }
        return false;
    }

    public Element asElement() {
        Element listElement = DocumentFactory.getInstance().createDocument().addElement("list", "jabber:iq:privacy");
        listElement.addAttribute("name", this.getName());
        for (PrivacyItem item : this.items) {
            listElement.add(item.asElement());
        }
        return listElement;
    }

    public void updateList(Element listElement) {
        this.updateList(listElement, true);
    }

    private void updateList(Element listElement, boolean notify) {
        this.items = new ArrayList<PrivacyItem>();
        List itemsElements = listElement.elements("item");
        for (Element itemElement : itemsElements) {
            Roster roster;
            PrivacyItem newItem = new PrivacyItem(itemElement);
            this.items.add(newItem);
            if (!newItem.isRosterRequired() || (roster = this.getRoster()) != null) continue;
            Log.warn("Privacy item removed since roster of user was not found: " + this.userJID.getNode());
            this.items.remove(newItem);
        }
        Collections.sort(this.items);
        if (notify) {
            PrivacyListManager.getInstance().dispatchModifiedEvent(this);
        }
    }

    private Roster getRoster() {
        try {
            return XMPPServer.getInstance().getRosterManager().getRoster(this.userJID.getNode());
        }
        catch (UserNotFoundException e) {
            Log.warn("Roster not found for user: " + this.userJID);
            return null;
        }
    }

    @Override
    public int getCachedSize() throws CannotCalculateSizeException {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfString(this.userJID.toString());
        size += CacheSizes.sizeOfString(this.name);
        size += CacheSizes.sizeOfBoolean();
        return size += CacheSizes.sizeOfCollection(this.items);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof PrivacyList) {
            return this.name.equals(((PrivacyList)object).getName());
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.userJID);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.name);
        ExternalizableUtil.getInstance().writeBoolean(out, this.isDefault);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.asElement().asXML());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.userJID = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.name = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.isDefault = ExternalizableUtil.getInstance().readBoolean(in);
        String xml = ExternalizableUtil.getInstance().readSafeUTF(in);
        try {
            Element element = localParser.get().read(new StringReader(xml)).getRootElement();
            this.updateList(element, false);
        }
        catch (Exception e) {
            Log.error("Error while parsing Privacy Property", (Throwable)e);
        }
    }

    static {
        try {
            factory = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
            factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            Log.error("Error creating a parser factory", (Throwable)e);
        }
        localParser = new ThreadLocal<XMPPPacketReader>(){

            @Override
            protected XMPPPacketReader initialValue() {
                XMPPPacketReader parser = new XMPPPacketReader();
                factory.setNamespaceAware(true);
                parser.setXPPFactory(factory);
                return parser;
            }
        };
    }
}

