/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.privacy;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

class PrivacyItem
implements Cacheable,
Comparable {
    private int order;
    private boolean allow;
    private Type type;
    private JID jidValue;
    private RosterItem.SubType subscriptionValue;
    private String groupValue;
    private boolean filterEverything;
    private boolean filterIQ;
    private boolean filterMessage;
    private boolean filterPresence_in;
    private boolean filterPresence_out;
    private Element itemElement;

    PrivacyItem(Element itemElement) {
        this.allow = "allow".equals(itemElement.attributeValue("action"));
        this.order = Integer.parseInt(itemElement.attributeValue("order"));
        String typeAttribute = itemElement.attributeValue("type");
        if (typeAttribute != null) {
            this.type = Type.valueOf(typeAttribute);
            String value = itemElement.attributeValue("value");
            if (this.type == Type.jid) {
                this.jidValue = new JID(value);
            } else if (this.type == Type.subscription) {
                this.subscriptionValue = "both".equals(value) ? RosterItem.SUB_BOTH : ("to".equals(value) ? RosterItem.SUB_TO : ("from".equals(value) ? RosterItem.SUB_FROM : RosterItem.SUB_NONE));
            } else {
                this.groupValue = value;
            }
        }
        this.filterIQ = itemElement.element("iq") != null;
        this.filterMessage = itemElement.element("message") != null;
        this.filterPresence_in = itemElement.element("presence-in") != null;
        boolean bl = this.filterPresence_out = itemElement.element("presence-out") != null;
        if (!(this.filterIQ || this.filterMessage || this.filterPresence_in || this.filterPresence_out)) {
            this.filterEverything = true;
        }
        this.itemElement = itemElement.createCopy();
    }

    Element asElement() {
        return this.itemElement.createCopy();
    }

    boolean isRosterRequired() {
        return this.type == Type.group || this.type == Type.subscription;
    }

    public int compareTo(Object object) {
        if (object instanceof PrivacyItem) {
            return this.order - ((PrivacyItem)object).order;
        }
        return this.getClass().getName().compareTo(object.getClass().getName());
    }

    boolean matchesCondition(Packet packet, Roster roster, JID userJID) {
        return this.matchesPacketSenderCondition(packet, roster, userJID) && this.matchesPacketTypeCondition(packet, userJID);
    }

    boolean isAllow() {
        return this.allow;
    }

    private boolean matchesPacketSenderCondition(Packet packet, Roster roster, JID userJID) {
        if (this.type == null) {
            return true;
        }
        boolean isPresence = packet.getClass().equals(Presence.class);
        boolean incoming = true;
        if (packet.getFrom() != null) {
            incoming = !userJID.toBareJID().equals(packet.getFrom().toBareJID());
        }
        boolean matches = false;
        if (isPresence && !incoming && (this.filterEverything || this.filterPresence_out)) {
            matches = this.verifyJID(packet.getTo(), roster);
        }
        if (!matches && incoming && (this.filterEverything || this.filterPresence_in || this.filterIQ || this.filterMessage)) {
            matches = this.verifyJID(packet.getFrom(), roster);
        }
        return matches;
    }

    private boolean verifyJID(JID jid, Roster roster) {
        if (jid == null) {
            return false;
        }
        if (this.type == Type.jid) {
            if (this.jidValue.getResource() != null) {
                return jid.equals((Object)this.jidValue);
            }
            if (this.jidValue.getNode() != null) {
                return jid.toBareJID().equals(this.jidValue.toBareJID());
            }
            return jid.getDomain().equals(this.jidValue.getDomain());
        }
        if (this.type == Type.group) {
            List<Object> contactGroups;
            try {
                RosterItem item = roster.getRosterItem(jid);
                contactGroups = item.getGroups();
            }
            catch (UserNotFoundException e) {
                contactGroups = Collections.emptyList();
            }
            return contactGroups.contains(this.groupValue);
        }
        RosterItem.SubType contactSubscription = RosterItem.SUB_NONE;
        try {
            RosterItem item = roster.getRosterItem(jid);
            contactSubscription = item.getSubStatus();
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        return contactSubscription == this.subscriptionValue;
    }

    private boolean matchesPacketTypeCondition(Packet packet, JID userJID) {
        if (this.filterEverything) {
            return true;
        }
        Class<?> packetClass = packet.getClass();
        if (Message.class.equals(packetClass)) {
            return this.filterMessage;
        }
        if (Presence.class.equals(packetClass)) {
            Presence.Type presenceType = ((Presence)packet).getType();
            if (presenceType == null || presenceType == Presence.Type.unavailable) {
                boolean incoming;
                JID to = packet.getTo();
                boolean bl = incoming = to != null && to.toBareJID().equals(userJID.toBareJID());
                if (incoming) {
                    return this.filterPresence_in;
                }
                return this.filterPresence_out;
            }
        } else if (IQ.class.equals(packetClass)) {
            return this.filterIQ;
        }
        return false;
    }

    @Override
    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfInt();
        size += CacheSizes.sizeOfBoolean();
        if (this.jidValue != null) {
            size += CacheSizes.sizeOfString(this.jidValue.toString());
        }
        if (this.groupValue != null) {
            size += CacheSizes.sizeOfString(this.groupValue);
        }
        size += CacheSizes.sizeOfBoolean();
        size += CacheSizes.sizeOfBoolean();
        size += CacheSizes.sizeOfBoolean();
        size += CacheSizes.sizeOfBoolean();
        return size += CacheSizes.sizeOfBoolean();
    }

    private static enum Type {
        group,
        jid,
        subscription;

    }
}

