/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pep;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommandManager;
import org.jivesoftware.openfire.entitycaps.EntityCapabilities;
import org.jivesoftware.openfire.entitycaps.EntityCapabilitiesManager;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.PendingSubscriptionsCommand;
import org.jivesoftware.openfire.pubsub.PubSubEngine;
import org.jivesoftware.openfire.pubsub.PubSubPersistenceManager;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.pubsub.models.PublisherModel;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.jivesoftware.util.cache.Cacheable;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketExtension;

public class PEPService
implements PubSubService,
Cacheable {
    private String serviceOwnerJID;
    private CollectionNode rootCollectionNode = null;
    private Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();
    private PacketRouter router = null;
    private DefaultNodeConfiguration leafDefaultConfiguration;
    private DefaultNodeConfiguration collectionDefaultConfiguration;
    private boolean nodeCreationRestricted = true;
    private Map<String, Map<String, String>> barePresences = new ConcurrentHashMap<String, Map<String, String>>();
    private AdHocCommandManager adHocCommandManager;
    private EntityCapabilitiesManager entityCapsManager = EntityCapabilitiesManager.getInstance();

    public PEPService(XMPPServer server, String bareJID) {
        this.serviceOwnerJID = bareJID;
        this.router = server.getPacketRouter();
        this.adHocCommandManager = new AdHocCommandManager();
        this.adHocCommandManager.addCommand(new PendingSubscriptionsCommand(this));
        this.leafDefaultConfiguration = PubSubPersistenceManager.loadDefaultConfiguration(this, true);
        if (this.leafDefaultConfiguration == null) {
            this.leafDefaultConfiguration = new DefaultNodeConfiguration(true);
            this.leafDefaultConfiguration.setAccessModel(AccessModel.presence);
            this.leafDefaultConfiguration.setPublisherModel(PublisherModel.publishers);
            this.leafDefaultConfiguration.setDeliverPayloads(true);
            this.leafDefaultConfiguration.setLanguage("English");
            this.leafDefaultConfiguration.setMaxPayloadSize(5120);
            this.leafDefaultConfiguration.setNotifyConfigChanges(true);
            this.leafDefaultConfiguration.setNotifyDelete(true);
            this.leafDefaultConfiguration.setNotifyRetract(true);
            this.leafDefaultConfiguration.setPersistPublishedItems(false);
            this.leafDefaultConfiguration.setMaxPublishedItems(1);
            this.leafDefaultConfiguration.setPresenceBasedDelivery(false);
            this.leafDefaultConfiguration.setSendItemSubscribe(true);
            this.leafDefaultConfiguration.setSubscriptionEnabled(true);
            this.leafDefaultConfiguration.setReplyPolicy(null);
            PubSubPersistenceManager.createDefaultConfiguration(this, this.leafDefaultConfiguration);
        }
        this.collectionDefaultConfiguration = PubSubPersistenceManager.loadDefaultConfiguration(this, false);
        if (this.collectionDefaultConfiguration == null) {
            this.collectionDefaultConfiguration = new DefaultNodeConfiguration(false);
            this.collectionDefaultConfiguration.setAccessModel(AccessModel.presence);
            this.collectionDefaultConfiguration.setPublisherModel(PublisherModel.publishers);
            this.collectionDefaultConfiguration.setDeliverPayloads(false);
            this.collectionDefaultConfiguration.setLanguage("English");
            this.collectionDefaultConfiguration.setNotifyConfigChanges(true);
            this.collectionDefaultConfiguration.setNotifyDelete(true);
            this.collectionDefaultConfiguration.setNotifyRetract(true);
            this.collectionDefaultConfiguration.setPresenceBasedDelivery(false);
            this.collectionDefaultConfiguration.setSubscriptionEnabled(true);
            this.collectionDefaultConfiguration.setReplyPolicy(null);
            this.collectionDefaultConfiguration.setAssociationPolicy(CollectionNode.LeafNodeAssociationPolicy.all);
            this.collectionDefaultConfiguration.setMaxLeafNodes(-1);
            PubSubPersistenceManager.createDefaultConfiguration(this, this.collectionDefaultConfiguration);
        }
        PubSubPersistenceManager.loadNodes(this);
        if (this.nodes.isEmpty()) {
            JID creatorJID = new JID(bareJID);
            this.rootCollectionNode = new CollectionNode(this, null, bareJID, creatorJID);
            this.rootCollectionNode.addOwner(creatorJID);
            this.rootCollectionNode.saveToDB();
        } else {
            this.rootCollectionNode = (CollectionNode)this.getNode(bareJID);
        }
    }

    @Override
    public void addNode(Node node) {
        this.nodes.put(node.getNodeID(), node);
    }

    @Override
    public void removeNode(String nodeID) {
        this.nodes.remove(nodeID);
    }

    @Override
    public Node getNode(String nodeID) {
        return this.nodes.get(nodeID);
    }

    @Override
    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public CollectionNode getRootCollectionNode() {
        return this.rootCollectionNode;
    }

    @Override
    public JID getAddress() {
        return new JID(this.serviceOwnerJID);
    }

    @Override
    public String getServiceID() {
        return this.serviceOwnerJID;
    }

    @Override
    public DefaultNodeConfiguration getDefaultNodeConfiguration(boolean leafType) {
        if (leafType) {
            return this.leafDefaultConfiguration;
        }
        return this.collectionDefaultConfiguration;
    }

    @Override
    public Collection<String> getShowPresences(JID subscriber) {
        return PubSubEngine.getShowPresences(this, subscriber);
    }

    @Override
    public boolean canCreateNode(JID creator) {
        return !this.isNodeCreationRestricted() || this.isServiceAdmin(creator);
    }

    private boolean canProbePresence(JID prober, JID probee) throws UserNotFoundException {
        Roster roster = XMPPServer.getInstance().getRosterManager().getRoster(prober.getNode());
        RosterItem item = roster.getRosterItem(probee);
        return item.getSubStatus() == RosterItem.SUB_BOTH || item.getSubStatus() == RosterItem.SUB_FROM;
    }

    @Override
    public boolean isCollectionNodesSupported() {
        return true;
    }

    @Override
    public boolean isInstantNodeSupported() {
        return true;
    }

    @Override
    public boolean isMultipleSubscriptionsEnabled() {
        return false;
    }

    @Override
    public boolean isServiceAdmin(JID user) {
        return this.serviceOwnerJID.equals(user.toBareJID());
    }

    public boolean isNodeCreationRestricted() {
        return this.nodeCreationRestricted;
    }

    @Override
    public void presenceSubscriptionNotRequired(Node node, JID user) {
        PubSubEngine.presenceSubscriptionNotRequired(this, node, user);
    }

    @Override
    public void presenceSubscriptionRequired(Node node, JID user) {
        PubSubEngine.presenceSubscriptionRequired(this, node, user);
    }

    @Override
    public void send(Packet packet) {
        this.router.route(packet);
    }

    @Override
    public void broadcast(Node node, Message message, Collection<JID> jids) {
        message.setFrom(this.getAddress());
        for (JID jid : jids) {
            message.setTo(jid);
            message.setID(StringUtils.randomString(8));
            this.router.route(message);
        }
    }

    @Override
    public void sendNotification(Node node, Message message, JID recipientJID) {
        message.setTo(recipientJID);
        message.setFrom(this.getAddress());
        message.setID(StringUtils.randomString(8));
        HashSet<JID> recipientFullJIDs = new HashSet<JID>();
        if (XMPPServer.getInstance().isLocal(recipientJID)) {
            if (recipientJID.getResource() == null) {
                for (ClientSession clientSession : SessionManager.getInstance().getSessions(recipientJID.getNode())) {
                    recipientFullJIDs.add(clientSession.getAddress());
                }
            }
        } else {
            recipientFullJIDs.add(recipientJID);
        }
        if (recipientFullJIDs.isEmpty()) {
            this.router.route(message);
            return;
        }
        for (JID recipientFullJID : recipientFullJIDs) {
            try {
                JID publisher = null;
                Element itemsElement = message.getElement().element("event").element("items");
                String nodeID = itemsElement.attributeValue("node");
                String itemID = null;
                Element itemElement = itemsElement.element("item");
                if (itemElement == null) {
                    Element retractElement = itemsElement.element("retract");
                    if (retractElement != null) {
                        itemID = retractElement.attributeValue("id");
                    }
                } else {
                    itemID = itemElement.attributeValue("id");
                }
                EntityCapabilities entityCaps = this.entityCapsManager.getEntityCapabilities(recipientFullJID);
                if (entityCaps != null && !entityCaps.containsFeature(nodeID + "+notify")) {
                    return;
                }
                if (node.isCollectionNode()) {
                    for (Node leafNode : node.getNodes()) {
                        if (!leafNode.getNodeID().equals(nodeID)) continue;
                        publisher = leafNode.getPublishedItem(itemID).getPublisher();
                        AccessModel accessModel = leafNode.getAccessModel();
                        if (!accessModel.canAccessItems(leafNode, recipientFullJID, publisher)) {
                            return;
                        }
                        break;
                    }
                } else {
                    publisher = node.getPublishedItem(itemID).getPublisher();
                }
                if (!this.canProbePresence(publisher, recipientFullJID)) continue;
                Element addresses = DocumentHelper.createElement((QName)QName.get((String)"addresses", (String)"http://jabber.org/protocol/address"));
                Element address = addresses.addElement("address");
                address.addAttribute("type", "replyto");
                address.addAttribute("jid", publisher.toString());
                Message extendedMessage = message.createCopy();
                extendedMessage.addExtension(new PacketExtension(addresses));
                extendedMessage.setTo(recipientFullJID);
                this.router.route(extendedMessage);
            }
            catch (IndexOutOfBoundsException publisher) {
            }
            catch (UserNotFoundException e) {
                this.router.route(message);
            }
            catch (NullPointerException e) {
                try {
                    if (this.canProbePresence(this.getAddress(), recipientFullJID)) {
                        message.setTo(recipientFullJID);
                    }
                }
                catch (UserNotFoundException userNotFoundException) {
                    // empty catch block
                }
                this.router.route(message);
            }
        }
    }

    public void sendLastPublishedItems(JID recipientJID) {
        NodeSubscription subscription = this.rootCollectionNode.getSubscription(recipientJID);
        if (subscription == null) {
            subscription = this.rootCollectionNode.getSubscription(new JID(recipientJID.toBareJID()));
        }
        if (subscription == null) {
            return;
        }
        for (Node leafNode : this.rootCollectionNode.getNodes()) {
            PublishedItem leafLastPublishedItem = null;
            leafLastPublishedItem = leafNode.getLastPublishedItem();
            if (leafLastPublishedItem == null) continue;
            if (!subscription.canSendPublicationEvent(leafLastPublishedItem.getNode(), leafLastPublishedItem)) {
                return;
            }
            Message notification = new Message();
            Element event = notification.getElement().addElement("event", "http://jabber.org/protocol/pubsub#event");
            Element items = event.addElement("items");
            items.addAttribute("node", leafLastPublishedItem.getNodeID());
            Element item = items.addElement("item");
            if (leafLastPublishedItem.getNode().isItemRequired()) {
                item.addAttribute("id", leafLastPublishedItem.getID());
            }
            if (leafLastPublishedItem.getNode().isPayloadDelivered() && leafLastPublishedItem.getPayload() != null) {
                item.add(leafLastPublishedItem.getPayload().createCopy());
            }
            if (subscription.isIncludingBody()) {
                notification.setBody(LocaleUtils.getLocalizedString("pubsub.notification.message.body"));
            }
            notification.getElement().addElement("delay", "urn:xmpp:delay").addAttribute("stamp", XMPPDateTimeFormat.format(leafLastPublishedItem.getCreationDate()));
            this.sendNotification(subscription.getNode(), notification, subscription.getJID());
        }
    }

    @Override
    public Map<String, Map<String, String>> getBarePresences() {
        return this.barePresences;
    }

    @Override
    public AdHocCommandManager getManager() {
        return this.adHocCommandManager;
    }

    @Override
    public int getCachedSize() {
        return 600;
    }
}

