/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.disco.ServerIdentitiesProvider;
import org.jivesoftware.openfire.disco.UserIdentitiesProvider;
import org.jivesoftware.openfire.disco.UserItemsProvider;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.pep.PEPService;
import org.jivesoftware.openfire.pep.PEPServiceManager;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.LeafNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.PubSubModule;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterEventDispatcher;
import org.jivesoftware.openfire.roster.RosterEventListener;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.PresenceEventDispatcher;
import org.jivesoftware.openfire.user.PresenceEventListener;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class IQPEPHandler
extends IQHandler
implements ServerIdentitiesProvider,
ServerFeaturesProvider,
UserIdentitiesProvider,
UserItemsProvider,
PresenceEventListener,
RosterEventListener,
UserEventListener,
DiscoInfoProvider {
    private static final Logger Log = LoggerFactory.getLogger(IQPEPHandler.class);
    private final IQHandlerInfo info = new IQHandlerInfo("pubsub", "http://jabber.org/protocol/pubsub");
    private PEPServiceManager pepServiceManager = null;
    private ExecutorService executor = null;

    public IQPEPHandler() {
        super("Personal Eventing Handler");
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.pepServiceManager = new PEPServiceManager();
    }

    public PEPServiceManager getServiceManager() {
        return this.pepServiceManager;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public void start() {
        super.start();
        this.pepServiceManager.start();
        this.startExecutor();
        PresenceEventDispatcher.addListener(this);
        RosterEventDispatcher.addListener(this);
        UserEventDispatcher.addListener(this);
    }

    @Override
    public void stop() {
        super.stop();
        PresenceEventDispatcher.removeListener(this);
        RosterEventDispatcher.removeListener(this);
        UserEventDispatcher.removeListener(this);
        this.stopExecutor();
        this.pepServiceManager.stop();
    }

    private void startExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            Log.debug("Starting executor service...");
            this.executor = Executors.newScheduledThreadPool(2);
        }
    }

    private void stopExecutor() {
        Log.debug("Stopping executor service...");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                Log.debug("Forcing a shutdown for the executor service (after a two-second timeout has elapsed...");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<Element> getIdentities() {
        Element identity = DocumentHelper.createElement((String)"identity");
        identity.addAttribute("category", "pubsub");
        identity.addAttribute("type", "pep");
        return Collections.singleton(identity).iterator();
    }

    @Override
    public Iterator<String> getFeatures() {
        Iterator<String> it = XMPPServer.getInstance().getPubSubModule().getFeatures(null, null, null);
        ArrayList<String> features = new ArrayList<String>();
        while (it.hasNext()) {
            features.add(it.next());
        }
        features.add("http://jabber.org/protocol/pubsub#auto-create");
        return features.iterator();
    }

    public boolean isEnabled() {
        return JiveGlobals.getBooleanProperty("xmpp.pep.enabled", true);
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        if (!this.isEnabled()) {
            IQ reply = IQ.createResultIQ((IQ)packet);
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.service_unavailable);
            return reply;
        }
        JID senderJID = packet.getFrom();
        if (packet.getTo() == null) {
            String jidFrom = senderJID.toBareJID();
            packet = packet.createCopy();
            packet.setTo(jidFrom);
            if (packet.getType() == IQ.Type.set) {
                Element childElement;
                Element publishElement;
                PEPService pepService = this.pepServiceManager.getPEPService(jidFrom);
                if (pepService == null) {
                    try {
                        pepService = this.pepServiceManager.create(senderJID);
                    }
                    catch (IllegalArgumentException ex) {
                        IQ reply = IQ.createResultIQ((IQ)packet);
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.not_allowed);
                        return reply;
                    }
                    this.pepServiceManager.start(pepService);
                    try {
                        RosterManager rm = XMPPServer.getInstance().getRosterManager();
                        Roster roster = rm.getRoster(senderJID.getNode());
                        for (RosterItem item : roster.getRosterItems()) {
                            if (item.getSubStatus() != RosterItem.SUB_BOTH && item.getSubStatus() != RosterItem.SUB_FROM) continue;
                            this.createSubscriptionToPEPService(pepService, item.getJid(), senderJID);
                        }
                    }
                    catch (UserNotFoundException rm) {
                        // empty catch block
                    }
                }
                if ((publishElement = (childElement = packet.getChildElement()).element("publish")) != null) {
                    String nodeID = publishElement.attributeValue("node");
                    if (nodeID.startsWith("http://www.xmpp.org/extensions/xep-0084.html")) {
                        IQ reply = IQ.createResultIQ((IQ)packet);
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.feature_not_implemented);
                        return reply;
                    }
                    if (pepService.getNode(nodeID) == null) {
                        JID creator = new JID(jidFrom);
                        LeafNode newNode = new LeafNode(pepService, pepService.getRootCollectionNode(), nodeID, creator);
                        newNode.addOwner(creator);
                        newNode.saveToDB();
                    }
                }
                this.pepServiceManager.process(pepService, packet);
            } else if (packet.getType() == IQ.Type.get) {
                PEPService pepService = this.pepServiceManager.getPEPService(jidFrom);
                if (pepService != null) {
                    this.pepServiceManager.process(pepService, packet);
                } else {
                    PEPService dummyService = new PEPService(XMPPServer.getInstance(), senderJID.toBareJID());
                    this.pepServiceManager.process(dummyService, packet);
                }
            }
        } else if (packet.getType() == IQ.Type.get || packet.getType() == IQ.Type.set) {
            String jidTo = packet.getTo().toBareJID();
            PEPService pepService = this.pepServiceManager.getPEPService(jidTo);
            if (pepService != null) {
                this.pepServiceManager.process(pepService, packet);
            } else {
                PEPService dummyService = new PEPService(XMPPServer.getInstance(), senderJID.toBareJID());
                this.pepServiceManager.process(dummyService, packet);
            }
        } else {
            return null;
        }
        return null;
    }

    private void createSubscriptionToPEPService(PEPService pepService, JID subscriber, JID owner) {
        IQ subscriptionPacket = new IQ(IQ.Type.set);
        subscriptionPacket.setFrom(subscriber);
        subscriptionPacket.setTo(owner.toBareJID());
        Element pubsubElement = subscriptionPacket.setChildElement("pubsub", "http://jabber.org/protocol/pubsub");
        Element subscribeElement = pubsubElement.addElement("subscribe");
        subscribeElement.addAttribute("jid", subscriber.toBareJID());
        Element optionsElement = pubsubElement.addElement("options");
        Element xElement = optionsElement.addElement(QName.get((String)"x", (String)"jabber:x:data"));
        DataForm dataForm = new DataForm(xElement);
        FormField formField = dataForm.addField();
        formField.setVariable("FORM_TYPE");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)"http://jabber.org/protocol/pubsub#subscribe_options");
        formField = dataForm.addField();
        formField.setVariable("pubsub#subscription_type");
        formField.addValue((Object)"items");
        formField = dataForm.addField();
        formField.setVariable("pubsub#subscription_depth");
        formField.addValue((Object)"all");
        this.pepServiceManager.process(pepService, subscriptionPacket);
    }

    private void cancelSubscriptionToPEPService(JID unsubscriber, JID serviceOwner) {
        PEPService pepService = this.pepServiceManager.getPEPService(serviceOwner.toBareJID());
        if (pepService == null) {
            return;
        }
        CollectionNode rootNode = pepService.getRootCollectionNode();
        NodeSubscription nodeSubscription = rootNode.getSubscription(unsubscriber);
        if (nodeSubscription != null) {
            rootNode.cancelSubscription(nodeSubscription);
        }
    }

    @Override
    public Iterator<Element> getUserItems(String name, JID senderJID) {
        ArrayList<Element> items = new ArrayList<Element>();
        String recipientJID = XMPPServer.getInstance().createJID(name, null, true).toBareJID();
        PEPService pepService = this.pepServiceManager.getPEPService(recipientJID);
        if (pepService != null) {
            CollectionNode rootNode = pepService.getRootCollectionNode();
            Element defaultItem = DocumentHelper.createElement((String)"item");
            defaultItem.addAttribute("jid", recipientJID);
            for (Node node : pepService.getNodes()) {
                AccessModel accessModel;
                if (node == rootNode || !(accessModel = node.getAccessModel()).canAccessItems(node, senderJID, new JID(recipientJID))) continue;
                Element item = defaultItem.createCopy();
                item.addAttribute("node", node.getNodeID());
                items.add(item);
            }
        }
        return items.iterator();
    }

    @Override
    public void subscribedToPresence(JID subscriberJID, JID authorizerJID) {
        PEPService pepService = this.pepServiceManager.getPEPService(authorizerJID.toBareJID());
        if (pepService != null) {
            this.createSubscriptionToPEPService(pepService, subscriberJID, authorizerJID);
            CollectionNode rootNode = pepService.getRootCollectionNode();
            for (Node node : pepService.getNodes()) {
                if (!rootNode.isChildNode(node)) continue;
                for (NodeSubscription subscription : node.getSubscriptions(subscriberJID)) {
                    node.cancelSubscription(subscription);
                }
            }
            pepService.sendLastPublishedItems(subscriberJID);
        }
    }

    @Override
    public void unsubscribedToPresence(JID unsubscriberJID, JID recipientJID) {
        this.cancelSubscriptionToPEPService(unsubscriberJID, recipientJID);
    }

    @Override
    public void availableSession(ClientSession session, Presence presence) {
        if (!this.isEnabled()) {
            return;
        }
        JID newlyAvailableJID = presence.getFrom();
        if (newlyAvailableJID == null) {
            return;
        }
        GetNotificationsOnInitialPresence task = new GetNotificationsOnInitialPresence(newlyAvailableJID);
        this.executor.submit(task);
    }

    @Override
    public void contactDeleted(Roster roster, RosterItem item) {
        JID rosterOwner = XMPPServer.getInstance().createJID(roster.getUsername(), null);
        JID deletedContact = item.getJid();
        this.cancelSubscriptionToPEPService(deletedContact, rosterOwner);
    }

    @Override
    public void userDeleting(User user, Map<String, Object> params) {
        JID bareJID = XMPPServer.getInstance().createJID(user.getUsername(), null);
        PEPService pepService = this.pepServiceManager.getPEPService(bareJID.toString());
        if (pepService == null) {
            return;
        }
        this.pepServiceManager.remove(bareJID);
    }

    @Override
    public void unavailableSession(ClientSession session, Presence presence) {
    }

    @Override
    public void presenceChanged(ClientSession session, Presence presence) {
    }

    @Override
    public boolean addingContact(Roster roster, RosterItem item, boolean persistent) {
        return true;
    }

    @Override
    public void contactAdded(Roster roster, RosterItem item) {
    }

    @Override
    public void contactUpdated(Roster roster, RosterItem item) {
    }

    @Override
    public void rosterLoaded(Roster roster) {
    }

    @Override
    public void userCreated(User user, Map<String, Object> params) {
    }

    @Override
    public void userModified(User user, Map<String, Object> params) {
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        String recipientJID = XMPPServer.getInstance().createJID(name, null, true).toBareJID();
        PEPService pepService = this.pepServiceManager.getPEPService(recipientJID);
        if (node != null && pepService != null) {
            Node pubNode = pepService.getNode(node);
            if (pubNode == null) {
                return null;
            }
            Element identity = DocumentHelper.createElement((String)"identity");
            identity.addAttribute("category", "pubsub");
            identity.addAttribute("type", pubNode.isCollectionNode() ? "collection" : "leaf");
            LinkedList<Element> identities = new LinkedList<Element>();
            identities.add(identity);
            return identities.iterator();
        }
        if (node != null) {
            return null;
        }
        PubSubModule pubsub = XMPPServer.getInstance().getPubSubModule();
        return pubsub.getIdentities(null, null, senderJID);
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        if (node == null) {
            PubSubModule pubsub = XMPPServer.getInstance().getPubSubModule();
            return pubsub.getFeatures(null, null, senderJID);
        }
        LinkedList<String> features = new LinkedList<String>();
        features.add("http://jabber.org/protocol/pubsub");
        return features.iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        String recipientJID = XMPPServer.getInstance().createJID(name, null, true).toBareJID();
        PEPService pepService = this.pepServiceManager.getPEPService(recipientJID);
        if (node != null) {
            Node pubNode = pepService.getNode(node);
            return pubNode.getMetadataForm();
        }
        return null;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        if (node == null) {
            return true;
        }
        String recipientJID = XMPPServer.getInstance().createJID(name, null, true).toBareJID();
        PEPService pepService = this.pepServiceManager.getPEPService(recipientJID);
        return pepService.getNode(node) != null;
    }

    private class GetNotificationsOnInitialPresence
    implements Runnable {
        private final JID availableSessionJID;

        public GetNotificationsOnInitialPresence(JID availableSessionJID) {
            this.availableSessionJID = availableSessionJID;
        }

        @Override
        public void run() {
            try {
                XMPPServer server = XMPPServer.getInstance();
                Roster roster = server.getRosterManager().getRoster(this.availableSessionJID.getNode());
                for (RosterItem item : roster.getRosterItems()) {
                    PEPService pepService;
                    if (!server.isLocal(item.getJid()) || item.getSubStatus() != RosterItem.SUB_BOTH && item.getSubStatus() != RosterItem.SUB_TO || (pepService = IQPEPHandler.this.pepServiceManager.getPEPService(item.getJid().toBareJID())) == null) continue;
                    pepService.sendLastPublishedItems(this.availableSessionJID);
                }
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
    }
}

