/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.muc.CannotBeInvitedException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.HistoryRequest;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MUCUser;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAcceptableException;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.RegistrationRequiredException;
import org.jivesoftware.openfire.muc.RoomLockedException;
import org.jivesoftware.openfire.muc.ServiceUnavailableException;
import org.jivesoftware.openfire.muc.spi.LocalMUCRole;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class LocalMUCUser
implements MUCUser {
    private static final Logger Log = LoggerFactory.getLogger(LocalMUCUser.class);
    private MultiUserChatService server;
    private JID realjid;
    private Map<String, LocalMUCRole> roles = new ConcurrentHashMap<String, LocalMUCRole>();
    private PacketRouter router;
    private long lastPacketTime;

    LocalMUCUser(MultiUserChatService chatservice, PacketRouter packetRouter, JID jid) {
        this.realjid = jid;
        this.router = packetRouter;
        this.server = chatservice;
    }

    public boolean isJoined() {
        return !this.roles.isEmpty();
    }

    public Collection<LocalMUCRole> getRoles() {
        return Collections.unmodifiableCollection(this.roles.values());
    }

    public void addRole(String roomName, LocalMUCRole role) {
        this.roles.put(roomName, role);
    }

    public void removeRole(String roomName) {
        this.roles.remove(roomName);
    }

    public long getLastPacketTime() {
        return this.lastPacketTime;
    }

    private void sendErrorPacket(Packet packet, PacketError.Condition error) {
        if (packet instanceof IQ) {
            IQ reply = IQ.createResultIQ((IQ)((IQ)packet));
            reply.setChildElement(((IQ)packet).getChildElement().createCopy());
            reply.setError(error);
            this.router.route(reply);
        } else {
            Packet reply = packet.createCopy();
            reply.setError(error);
            reply.setFrom(packet.getTo());
            reply.setTo(packet.getFrom());
            this.router.route(reply);
        }
    }

    @Override
    public JID getAddress() {
        return this.realjid;
    }

    @Override
    public void process(Packet packet) throws UnauthorizedException, PacketException {
        if (packet instanceof IQ) {
            this.process((IQ)packet);
        } else if (packet instanceof Message) {
            this.process((Message)packet);
        } else if (packet instanceof Presence) {
            this.process((Presence)packet);
        }
    }

    @Override
    public void process(Message packet) {
        if (Message.Type.error == packet.getType()) {
            return;
        }
        this.lastPacketTime = System.currentTimeMillis();
        JID recipient = packet.getTo();
        String group = recipient.getNode();
        if (group == null) {
            Log.warn(LocaleUtils.getLocalizedString("muc.error.not-supported") + " " + packet.toString());
        } else {
            MUCRole role = this.roles.get(group);
            if (role == null) {
                if (this.server.hasChatRoom(group)) {
                    boolean declinedInvitation = false;
                    Element userInfo = null;
                    if (Message.Type.normal == packet.getType() && (userInfo = packet.getChildElement("x", "http://jabber.org/protocol/muc#user")) != null && userInfo.element("decline") != null) {
                        declinedInvitation = true;
                    }
                    if (declinedInvitation) {
                        Element info = userInfo.element("decline");
                        this.server.getChatRoom(group).sendInvitationRejection(new JID(info.attributeValue("to")), info.elementTextTrim("reason"), packet.getFrom());
                    } else {
                        this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                    }
                } else {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.recipient_unavailable);
                }
            } else if (!role.getUserAddress().equals((Object)packet.getFrom())) {
                this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
            } else {
                try {
                    if (role.getChatRoom().getRoomHistory().isSubjectChangeRequest(packet)) {
                        role.getChatRoom().changeSubject(packet, role);
                    } else {
                        Message.Type type = packet.getType();
                        String resource = packet.getTo().getResource();
                        if (resource == null || resource.trim().length() == 0) {
                            resource = null;
                        }
                        if (resource == null && Message.Type.groupchat == type) {
                            role.getChatRoom().sendPublicMessage(packet, role);
                        } else if (resource != null && (Message.Type.chat == type || Message.Type.normal == type)) {
                            role.getChatRoom().sendPrivatePacket((Packet)packet, role);
                        } else if (resource == null && Message.Type.normal == type) {
                            Element userInfo = packet.getChildElement("x", "http://jabber.org/protocol/muc#user");
                            LocalMUCRoom room = (LocalMUCRoom)role.getChatRoom();
                            if (userInfo != null && userInfo.element("invite") != null) {
                                ArrayList<Element> extensions = new ArrayList<Element>(packet.getElement().elements());
                                extensions.remove(userInfo);
                                Iterator it = userInfo.elementIterator("invite");
                                while (it.hasNext()) {
                                    Element info = (Element)it.next();
                                    JID jid = new JID(info.attributeValue("to"));
                                    if (room.isMembersOnly()) {
                                        room.addMember(jid, null, role);
                                    }
                                    room.sendInvitation(jid, info.elementTextTrim("reason"), role, extensions);
                                }
                            } else if (userInfo != null && userInfo.element("decline") != null) {
                                Element info = userInfo.element("decline");
                                room.sendInvitationRejection(new JID(info.attributeValue("to")), info.elementTextTrim("reason"), packet.getFrom());
                            } else {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.bad_request);
                            }
                        } else {
                            this.sendErrorPacket((Packet)packet, PacketError.Condition.bad_request);
                        }
                    }
                }
                catch (ForbiddenException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.forbidden);
                }
                catch (NotFoundException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.recipient_unavailable);
                }
                catch (ConflictException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
                }
                catch (CannotBeInvitedException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                }
                catch (IllegalArgumentException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.jid_malformed);
                }
            }
        }
    }

    @Override
    public void process(IQ packet) {
        this.lastPacketTime = System.currentTimeMillis();
        JID recipient = packet.getTo();
        String group = recipient.getNode();
        if (group == null) {
            if (packet.isRequest()) {
                this.sendErrorPacket((Packet)packet, PacketError.Condition.feature_not_implemented);
            }
            Log.warn(LocaleUtils.getLocalizedString("muc.error.not-supported") + " " + packet.toString());
        } else {
            MUCRole role = this.roles.get(group);
            if (role == null) {
                Log.debug("Ignoring stanza received from a non-occupant of '{}': {}", (Object)group, (Object)packet.toXML());
                if (packet.isRequest()) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.bad_request);
                }
            } else if (IQ.Type.result == packet.getType() || IQ.Type.error == packet.getType()) {
                if (packet.getTo().getResource() != null) {
                    try {
                        role.getChatRoom().sendPrivatePacket((Packet)packet, role);
                    }
                    catch (ForbiddenException | NotFoundException exception) {}
                }
            } else if (!role.getUserAddress().equals((Object)packet.getFrom())) {
                this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
            } else {
                try {
                    Element query = packet.getElement().element("query");
                    if (query != null && "http://jabber.org/protocol/muc#owner".equals(query.getNamespaceURI())) {
                        role.getChatRoom().getIQOwnerHandler().handleIQ(packet, role);
                    } else if (query != null && "http://jabber.org/protocol/muc#admin".equals(query.getNamespaceURI())) {
                        role.getChatRoom().getIQAdminHandler().handleIQ(packet, role);
                    } else if (packet.getTo().getResource() != null) {
                        role.getChatRoom().sendPrivatePacket((Packet)packet, role);
                    } else {
                        this.sendErrorPacket((Packet)packet, PacketError.Condition.bad_request);
                    }
                }
                catch (NotAcceptableException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                }
                catch (ForbiddenException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.forbidden);
                }
                catch (NotFoundException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.recipient_unavailable);
                }
                catch (ConflictException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
                }
                catch (NotAllowedException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.not_allowed);
                }
                catch (CannotBeInvitedException e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                }
                catch (Exception e) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.internal_server_error);
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void process(Presence packet) {
        block34: {
            this.lastPacketTime = System.currentTimeMillis();
            JID recipient = packet.getTo();
            String group = recipient.getNode();
            if (group != null) {
                MUCRole role = this.roles.get(group);
                Element mucInfo = packet.getChildElement("x", "http://jabber.org/protocol/muc");
                if (role == null || mucInfo != null) {
                    if (recipient.getResource() != null && recipient.getResource().trim().length() > 0) {
                        if (packet.isAvailable()) {
                            try {
                                MUCRoom room = this.server.getChatRoom(group, packet.getFrom());
                                HistoryRequest historyRequest = null;
                                String password = null;
                                if (mucInfo != null) {
                                    password = mucInfo.elementTextTrim("password");
                                    if (mucInfo.element("history") != null) {
                                        historyRequest = new HistoryRequest(mucInfo);
                                    }
                                }
                                role = room.joinRoom(recipient.getResource().trim(), password, historyRequest, this, packet.createCopy());
                                if (mucInfo == null && room.isLocked() && !room.isManuallyLocked()) {
                                    room.unlock(role);
                                }
                            }
                            catch (UnauthorizedException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.not_authorized);
                            }
                            catch (ServiceUnavailableException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.service_unavailable);
                            }
                            catch (ConflictException | UserAlreadyExistsException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
                            }
                            catch (RoomLockedException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.item_not_found);
                            }
                            catch (ForbiddenException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.forbidden);
                            }
                            catch (RegistrationRequiredException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.registration_required);
                            }
                            catch (NotAcceptableException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                            }
                            catch (NotAllowedException e) {
                                this.sendErrorPacket((Packet)packet, PacketError.Condition.not_allowed);
                            }
                        } else if (packet.getType() != Presence.Type.error) {
                            this.sendErrorPacket((Packet)packet, PacketError.Condition.unexpected_request);
                        }
                    } else if (packet.getType() != Presence.Type.error) {
                        this.sendErrorPacket((Packet)packet, PacketError.Condition.jid_malformed);
                    }
                } else if (!role.getUserAddress().equals((Object)packet.getFrom())) {
                    this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
                } else if (Presence.Type.unavailable == packet.getType()) {
                    try {
                        this.removeRole(group);
                        role.getChatRoom().leaveRoom(role);
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        String resource;
                        String string = resource = recipient.getResource() == null || recipient.getResource().trim().length() == 0 ? null : recipient.getResource().trim();
                        if (resource == null || role.getNickname().equalsIgnoreCase(resource)) {
                            role.getChatRoom().presenceUpdated(role, packet);
                            break block34;
                        }
                        if (role.getChatRoom().getOccupantsByBareJID(packet.getFrom().asBareJID()).size() > 1) {
                            this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                            break block34;
                        }
                        if (!role.getChatRoom().canChangeNickname()) {
                            this.sendErrorPacket((Packet)packet, PacketError.Condition.not_acceptable);
                            break block34;
                        }
                        if (role.getChatRoom().hasOccupant(resource)) {
                            this.sendErrorPacket((Packet)packet, PacketError.Condition.conflict);
                            break block34;
                        }
                        Presence presence = role.getPresence().createCopy();
                        presence.setType(Presence.Type.unavailable);
                        presence.setStatus(null);
                        Element frag = presence.getChildElement("x", "http://jabber.org/protocol/muc#user");
                        frag.element("item").addAttribute("nick", resource);
                        frag.addElement("status").addAttribute("code", "303");
                        role.getChatRoom().send((Packet)presence);
                        String oldNick = role.getNickname();
                        role.getChatRoom().nicknameChanged(role, packet, oldNick, resource);
                    }
                    catch (Exception e) {
                        Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                    }
                }
            } else {
                Log.warn(LocaleUtils.getLocalizedString("muc.error.not-supported") + " " + packet.toString());
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.realjid == null ? 0 : this.realjid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalMUCUser other = (LocalMUCUser)obj;
        return !(this.realjid == null ? other.realjid != null : !this.realjid.equals((Object)other.realjid));
    }
}

