/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Element;
import org.jivesoftware.database.SequenceManager;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.event.GroupEventListener;
import org.jivesoftware.openfire.group.ConcurrentGroupList;
import org.jivesoftware.openfire.group.ConcurrentGroupMap;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAwareList;
import org.jivesoftware.openfire.group.GroupAwareMap;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.muc.CannotBeInvitedException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.HistoryRequest;
import org.jivesoftware.openfire.muc.HistoryStrategy;
import org.jivesoftware.openfire.muc.MUCEventDispatcher;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MUCRoomHistory;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAcceptableException;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.RegistrationRequiredException;
import org.jivesoftware.openfire.muc.RoomLockedException;
import org.jivesoftware.openfire.muc.ServiceUnavailableException;
import org.jivesoftware.openfire.muc.cluster.AddAffiliation;
import org.jivesoftware.openfire.muc.cluster.AddMember;
import org.jivesoftware.openfire.muc.cluster.BroadcastMessageRequest;
import org.jivesoftware.openfire.muc.cluster.BroadcastPresenceRequest;
import org.jivesoftware.openfire.muc.cluster.ChangeNickname;
import org.jivesoftware.openfire.muc.cluster.DestroyRoomRequest;
import org.jivesoftware.openfire.muc.cluster.OccupantAddedEvent;
import org.jivesoftware.openfire.muc.cluster.OccupantLeftEvent;
import org.jivesoftware.openfire.muc.cluster.RoomUpdatedEvent;
import org.jivesoftware.openfire.muc.cluster.UpdateOccupant;
import org.jivesoftware.openfire.muc.cluster.UpdateOccupantRequest;
import org.jivesoftware.openfire.muc.cluster.UpdatePresence;
import org.jivesoftware.openfire.muc.spi.IQAdminHandler;
import org.jivesoftware.openfire.muc.spi.IQOwnerHandler;
import org.jivesoftware.openfire.muc.spi.LocalMUCRole;
import org.jivesoftware.openfire.muc.spi.LocalMUCUser;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.openfire.muc.spi.MultiUserChatServiceImpl;
import org.jivesoftware.openfire.muc.spi.RemoteMUCRole;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.NotFoundException;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class LocalMUCRoom
implements MUCRoom,
GroupEventListener {
    private static final Logger Log = LoggerFactory.getLogger(LocalMUCRoom.class);
    private MultiUserChatService mucService;
    private Map<String, List<MUCRole>> occupantsByNickname = new ConcurrentHashMap<String, List<MUCRole>>();
    private Map<JID, List<MUCRole>> occupantsByBareJID = new ConcurrentHashMap<JID, List<MUCRole>>();
    private Map<JID, MUCRole> occupantsByFullJID = new ConcurrentHashMap<JID, MUCRole>();
    private String name;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private MUCRole role = new RoomRole(this);
    private PacketRouter router;
    long startTime;
    long endTime;
    boolean isDestroyed = false;
    private MUCRoomHistory roomHistory;
    private long lockedTime;
    GroupAwareList<JID> owners = new ConcurrentGroupList<JID>();
    GroupAwareList<JID> admins = new ConcurrentGroupList<JID>();
    GroupAwareMap<JID, String> members = new ConcurrentGroupMap<JID, String>();
    private GroupAwareList<JID> outcasts = new ConcurrentGroupList<JID>();
    private String naturalLanguageName;
    private String description;
    private boolean canOccupantsChangeSubject;
    private int maxUsers;
    private List<String> rolesToBroadcastPresence = new ArrayList<String>();
    private boolean publicRoom;
    private boolean persistent;
    private boolean moderated;
    private boolean membersOnly;
    private boolean canOccupantsInvite;
    private String password = null;
    private boolean canAnyoneDiscoverJID;
    private String canSendPrivateMessage;
    private boolean logEnabled;
    private boolean loginRestrictedToNickname;
    private boolean canChangeNickname;
    private boolean registrationEnabled;
    private IQOwnerHandler iqOwnerHandler;
    private IQAdminHandler iqAdminHandler;
    private String subject = "";
    private long roomID = -1L;
    private Date creationDate;
    private Date modificationDate;
    private Date emptyDate;
    private boolean savedToDB = false;

    public LocalMUCRoom() {
    }

    LocalMUCRoom(MultiUserChatService chatservice, String roomname, PacketRouter packetRouter) {
        this.mucService = chatservice;
        this.name = roomname;
        this.naturalLanguageName = roomname;
        this.description = roomname;
        this.router = packetRouter;
        this.startTime = System.currentTimeMillis();
        this.creationDate = new Date(this.startTime);
        this.modificationDate = new Date(this.startTime);
        this.emptyDate = new Date(this.startTime);
        this.canOccupantsChangeSubject = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.canOccupantsChangeSubject", false);
        this.maxUsers = MUCPersistenceManager.getIntProperty(this.mucService.getServiceName(), "room.maxUsers", 30);
        this.publicRoom = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.publicRoom", true);
        this.persistent = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.persistent", false);
        this.moderated = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.moderated", false);
        this.membersOnly = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.membersOnly", false);
        this.canOccupantsInvite = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.canOccupantsInvite", false);
        this.canAnyoneDiscoverJID = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.canAnyoneDiscoverJID", true);
        this.logEnabled = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.logEnabled", false);
        this.loginRestrictedToNickname = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.loginRestrictedToNickname", false);
        this.canChangeNickname = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.canChangeNickname", true);
        this.registrationEnabled = MUCPersistenceManager.getBooleanProperty(this.mucService.getServiceName(), "room.registrationEnabled", true);
        this.roomHistory = new MUCRoomHistory(this, new HistoryStrategy(this.mucService.getHistoryStrategy()));
        this.iqOwnerHandler = new IQOwnerHandler(this, packetRouter);
        this.iqAdminHandler = new IQAdminHandler(this, packetRouter);
        this.lockedTime = this.startTime;
        this.rolesToBroadcastPresence.add("moderator");
        this.rolesToBroadcastPresence.add("participant");
        this.rolesToBroadcastPresence.add("visitor");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JID getJID() {
        return new JID(this.getName(), this.getMUCService().getServiceDomain(), null);
    }

    @Override
    public MultiUserChatService getMUCService() {
        return this.mucService;
    }

    @Override
    public void setMUCService(MultiUserChatService service) {
        this.mucService = service;
    }

    @Override
    public long getID() {
        if ((this.isPersistent() || this.isLogEnabled()) && this.roomID == -1L) {
            this.roomID = SequenceManager.nextID(23);
        }
        return this.roomID;
    }

    @Override
    public void setID(long roomID) {
        this.roomID = roomID;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    public void setEmptyDate(Date emptyDate) {
        if (this.emptyDate == emptyDate) {
            return;
        }
        this.emptyDate = emptyDate;
        MUCPersistenceManager.updateRoomEmptyDate(this);
    }

    @Override
    public Date getEmptyDate() {
        return this.emptyDate;
    }

    @Override
    public MUCRole getRole() {
        return this.role;
    }

    @Override
    public MUCRole getOccupant(String nickname) throws UserNotFoundException {
        if (nickname == null) {
            throw new UserNotFoundException();
        }
        List<MUCRole> roles = this.getOccupantsByNickname(nickname);
        if (roles != null && roles.size() > 0) {
            return roles.get(0);
        }
        throw new UserNotFoundException();
    }

    @Override
    public List<MUCRole> getOccupantsByNickname(String nickname) throws UserNotFoundException {
        if (nickname == null) {
            throw new UserNotFoundException();
        }
        List<MUCRole> roles = this.occupantsByNickname.get(nickname.toLowerCase());
        if (roles != null && roles.size() > 0) {
            return roles;
        }
        throw new UserNotFoundException();
    }

    @Override
    public List<MUCRole> getOccupantsByBareJID(JID jid) throws UserNotFoundException {
        List<MUCRole> roles = this.occupantsByBareJID.get(jid);
        if (roles != null && !roles.isEmpty()) {
            return Collections.unmodifiableList(roles);
        }
        throw new UserNotFoundException();
    }

    @Override
    public MUCRole getOccupantByFullJID(JID jid) {
        MUCRole role = this.occupantsByFullJID.get(jid);
        if (role != null) {
            return role;
        }
        return null;
    }

    @Override
    public Collection<MUCRole> getOccupants() {
        return Collections.unmodifiableCollection(this.occupantsByFullJID.values());
    }

    @Override
    public int getOccupantsCount() {
        return this.occupantsByNickname.size();
    }

    @Override
    public boolean hasOccupant(String nickname) {
        return this.occupantsByNickname.containsKey(nickname.toLowerCase());
    }

    @Override
    public String getReservedNickname(JID jid) {
        JID bareJID = jid.asBareJID();
        String answer = (String)this.members.get(bareJID);
        if (answer == null || answer.trim().length() == 0) {
            return null;
        }
        return answer;
    }

    @Override
    public MUCRole.Affiliation getAffiliation(JID jid) {
        JID bareJID = jid.asBareJID();
        if (this.owners.includes(bareJID)) {
            return MUCRole.Affiliation.owner;
        }
        if (this.admins.includes(bareJID)) {
            return MUCRole.Affiliation.admin;
        }
        if (this.members.includesKey(bareJID)) {
            return MUCRole.Affiliation.member;
        }
        if (this.outcasts.includes(bareJID)) {
            return MUCRole.Affiliation.outcast;
        }
        return MUCRole.Affiliation.none;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalMUCRole joinRoom(String nickname, String password, HistoryRequest historyRequest, LocalMUCUser user, Presence presence) throws UnauthorizedException, UserAlreadyExistsException, RoomLockedException, ForbiddenException, RegistrationRequiredException, ConflictException, ServiceUnavailableException, NotAcceptableException {
        if (((MultiUserChatServiceImpl)this.mucService).getMUCDelegate() != null && !((MultiUserChatServiceImpl)this.mucService).getMUCDelegate().joiningRoom(this, user.getAddress())) {
            throw new UnauthorizedException();
        }
        LocalMUCRole joinRole = null;
        this.lock.writeLock().lock();
        boolean clientOnlyJoin = false;
        try {
            MUCRole.Affiliation affiliation;
            MUCRole.Role role;
            String reservedNickname;
            if (!this.canJoinRoom(user)) {
                throw new ServiceUnavailableException();
            }
            JID bareJID = user.getAddress().asBareJID();
            boolean isOwner = this.owners.includes(bareJID);
            if (this.isLocked() && !isOwner) {
                throw new RoomLockedException();
            }
            if (this.occupantsByNickname.containsKey(nickname.toLowerCase())) {
                MUCRole occupant;
                List<MUCRole> occupants = this.occupantsByNickname.get(nickname.toLowerCase());
                MUCRole mUCRole = occupant = occupants.size() > 0 ? occupants.get(0) : null;
                if (occupant != null && !occupant.getUserAddress().toBareJID().equals(bareJID.toBareJID())) {
                    throw new UserAlreadyExistsException();
                }
                for (MUCRole mucRole : occupants) {
                    if (!mucRole.getUserAddress().equals((Object)user.getAddress())) continue;
                    clientOnlyJoin = true;
                    break;
                }
            }
            if (this.isPasswordProtected() && (password == null || !password.equals(this.getPassword()))) {
                throw new UnauthorizedException();
            }
            if (this.members.containsValue(nickname.toLowerCase()) && !nickname.toLowerCase().equals(this.members.get(bareJID))) {
                throw new ConflictException();
            }
            if (this.isLoginRestrictedToNickname() && (reservedNickname = (String)this.members.get(bareJID)) != null && !nickname.toLowerCase().equals(reservedNickname)) {
                throw new NotAcceptableException();
            }
            if (isOwner) {
                role = MUCRole.Role.moderator;
                affiliation = MUCRole.Affiliation.owner;
            } else if (this.mucService.isSysadmin(bareJID)) {
                role = MUCRole.Role.moderator;
                affiliation = MUCRole.Affiliation.owner;
            } else if (this.admins.includes(bareJID)) {
                role = MUCRole.Role.moderator;
                affiliation = MUCRole.Affiliation.admin;
            } else {
                if (this.outcasts.contains(bareJID)) {
                    throw new ForbiddenException();
                }
                if (this.members.includesKey(bareJID)) {
                    role = MUCRole.Role.participant;
                    affiliation = MUCRole.Affiliation.member;
                } else {
                    if (this.outcasts.includes(bareJID)) {
                        throw new ForbiddenException();
                    }
                    if (this.isMembersOnly()) {
                        throw new RegistrationRequiredException();
                    }
                    role = this.isModerated() ? MUCRole.Role.visitor : MUCRole.Role.participant;
                    affiliation = MUCRole.Affiliation.none;
                }
            }
            if (!clientOnlyJoin) {
                joinRole = new LocalMUCRole(this.mucService, this, nickname, role, affiliation, user, presence, this.router);
                List<MUCRole> occupants = this.occupantsByNickname.get(nickname.toLowerCase());
                if (occupants == null) {
                    occupants = new ArrayList<MUCRole>();
                    this.occupantsByNickname.put(nickname.toLowerCase(), occupants);
                }
                occupants.add(joinRole);
                List<MUCRole> list = this.occupantsByBareJID.get(bareJID);
                if (list == null) {
                    list = new ArrayList<MUCRole>();
                    this.occupantsByBareJID.put(bareJID, list);
                }
                list.add(joinRole);
                this.occupantsByFullJID.put(user.getAddress(), joinRole);
            } else {
                joinRole = (LocalMUCRole)this.occupantsByFullJID.get(user.getAddress());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        CacheFactory.doClusterTask(new OccupantAddedEvent(this, joinRole));
        this.sendInitialPresences(joinRole);
        boolean isRoomNew = this.isLocked() && this.creationDate.getTime() == this.lockedTime;
        try {
            Presence joinPresence = joinRole.getPresence().createCopy();
            this.broadcastPresence(joinPresence, true);
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        if (!isRoomNew && this.isLocked()) {
            Presence presenceItemNotFound = new Presence(Presence.Type.error);
            presenceItemNotFound.setError(PacketError.Condition.item_not_found);
            presenceItemNotFound.setFrom(this.role.getRoleAddress());
            joinRole.send((Packet)presenceItemNotFound);
        }
        if (historyRequest == null) {
            Iterator<Message> history = this.roomHistory.getMessageHistory();
            while (history.hasNext()) {
                joinRole.send((Packet)history.next());
            }
        } else {
            historyRequest.sendHistory(joinRole, this.roomHistory);
        }
        Message roomSubject = this.roomHistory.getChangedSubject();
        if (roomSubject != null) {
            joinRole.send((Packet)roomSubject);
        }
        if (!clientOnlyJoin) {
            this.setEmptyDate(null);
            MUCEventDispatcher.occupantJoined(this.getRole().getRoleAddress(), user.getAddress(), joinRole.getNickname());
        }
        return joinRole;
    }

    private boolean canJoinRoom(LocalMUCUser user) {
        boolean isOwner = this.owners.includes(user.getAddress().asBareJID());
        boolean isAdmin = this.admins.includes(user.getAddress().asBareJID());
        return !this.isDestroyed && (!this.hasOccupancyLimit() || isAdmin || isOwner || this.getOccupantsCount() < this.getMaxUsers());
    }

    private boolean hasOccupancyLimit() {
        return this.getMaxUsers() != 0;
    }

    private void sendInitialPresences(LocalMUCRole joinRole) {
        for (MUCRole occupant : this.occupantsByFullJID.values()) {
            Element frag;
            if (occupant == joinRole) continue;
            Presence occupantPresence = occupant.getPresence();
            if (this.hasToCheckRoleToBroadcastPresence() && !this.canBroadcastPresence((frag = occupantPresence.getChildElement("x", "http://jabber.org/protocol/muc#user")).element("item").attributeValue("role"))) continue;
            if (!this.canAnyoneDiscoverJID() && MUCRole.Role.moderator != joinRole.getRole()) {
                occupantPresence = occupantPresence.createCopy();
                frag = occupantPresence.getChildElement("x", "http://jabber.org/protocol/muc#user");
                frag.element("item").addAttribute("jid", null);
            }
            joinRole.send((Packet)occupantPresence);
        }
    }

    public void occupantAdded(OccupantAddedEvent event) {
        JID existingJID;
        RemoteMUCRole joinRole = new RemoteMUCRole(this.mucService, event);
        JID bareJID = event.getUserAddress().asBareJID();
        String nickname = event.getNickname();
        List<MUCRole> occupants = this.occupantsByNickname.get(nickname.toLowerCase());
        if (occupants == null) {
            occupants = new ArrayList<MUCRole>();
            this.occupantsByNickname.put(nickname.toLowerCase(), occupants);
        } else if (occupants.size() > 0 && !bareJID.equals((Object)(existingJID = occupants.get(0).getUserAddress().asBareJID()))) {
            Log.warn(MessageFormat.format("Conflict detected; {0} requested nickname '{1}'; already being used by {2}", bareJID, nickname, existingJID));
            return;
        }
        occupants.add(joinRole);
        List<MUCRole> list = this.occupantsByBareJID.get(bareJID);
        if (list == null) {
            list = new ArrayList<MUCRole>();
            this.occupantsByBareJID.put(bareJID, list);
        }
        list.add(joinRole);
        this.occupantsByFullJID.put(event.getUserAddress(), joinRole);
        this.setEmptyDate(null);
        if (event.isOriginator()) {
            MUCEventDispatcher.occupantJoined(this.getRole().getRoleAddress(), event.getUserAddress(), joinRole.getNickname());
        }
        if (event.isSendPresence()) {
            for (MUCRole occupant : this.occupantsByFullJID.values()) {
                if (!occupant.isLocal()) continue;
                occupant.send((Packet)event.getPresence().createCopy());
            }
        }
    }

    @Override
    public void leaveRoom(MUCRole leaveRole) {
        OccupantLeftEvent event;
        if (leaveRole.isLocal()) {
            event = new OccupantLeftEvent(this, leaveRole);
            CacheFactory.doClusterTask(event);
        }
        try {
            Element item;
            Presence originalPresence = leaveRole.getPresence();
            Presence presence = originalPresence.createCopy();
            presence.setType(Presence.Type.unavailable);
            presence.setStatus(null);
            Element childElement = presence.getChildElement("x", "http://jabber.org/protocol/muc#user");
            if (childElement == null) {
                childElement = presence.addChildElement("x", "http://jabber.org/protocol/muc#user");
            }
            if ((item = childElement.element("item")) == null) {
                item = childElement.addElement("item");
            }
            item.addAttribute("role", "none");
            if (!this.shouldBroadcastPresence(originalPresence)) {
                leaveRole.send((Packet)presence);
            } else if (this.getOccupantsByNickname(leaveRole.getNickname()).size() <= 1) {
                this.broadcastPresence(presence, false);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        event = new OccupantLeftEvent(this, leaveRole);
        event.setOriginator(true);
        event.run();
    }

    public void leaveRoom(OccupantLeftEvent event) {
        MUCRole leaveRole = event.getRole();
        if (leaveRole == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.removeOccupantRole(leaveRole, event.isOriginator());
            if (this.occupantsByFullJID.isEmpty() && !this.isPersistent()) {
                this.endTime = System.currentTimeMillis();
                if (event.isOriginator()) {
                    this.mucService.removeChatRoom(this.name);
                    MUCEventDispatcher.roomDestroyed(this.getRole().getRoleAddress());
                }
            }
            if (this.occupantsByFullJID.isEmpty()) {
                this.setEmptyDate(new Date());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void removeOccupantRole(MUCRole leaveRole, boolean originator) {
        List<MUCRole> list;
        JID userAddress = leaveRole.getUserAddress();
        leaveRole.destroy();
        JID bareJID = userAddress.asBareJID();
        String nickname = leaveRole.getNickname();
        List<MUCRole> occupants = this.occupantsByNickname.get(nickname.toLowerCase());
        if (occupants != null) {
            occupants.remove(leaveRole);
            if (occupants.isEmpty()) {
                this.occupantsByNickname.remove(nickname.toLowerCase());
            }
        }
        if ((list = this.occupantsByBareJID.get(bareJID)) != null) {
            list.remove(leaveRole);
            if (list.isEmpty()) {
                this.occupantsByBareJID.remove(bareJID);
            }
        }
        this.occupantsByFullJID.remove(userAddress);
        if (originator) {
            MUCEventDispatcher.occupantLeft(this.getRole().getRoleAddress(), userAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyRoom(DestroyRoomRequest destroyRequest) {
        JID alternateJID = destroyRequest.getAlternateJID();
        String reason = destroyRequest.getReason();
        ArrayList<MUCRole> removedRoles = new ArrayList<MUCRole>();
        this.lock.writeLock().lock();
        try {
            boolean hasRemoteOccupants = false;
            for (MUCRole leaveRole : this.occupantsByFullJID.values()) {
                if (leaveRole == null) continue;
                if (leaveRole.isLocal()) {
                    removedRoles.add(leaveRole);
                } else {
                    hasRemoteOccupants = true;
                }
                this.removeOccupantRole(leaveRole, destroyRequest.isOriginator());
            }
            this.endTime = System.currentTimeMillis();
            this.isDestroyed = true;
            if (destroyRequest.isOriginator()) {
                if (hasRemoteOccupants) {
                    CacheFactory.doClusterTask(new DestroyRoomRequest(this, alternateJID, reason));
                }
                this.mucService.removeChatRoom(this.name);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (MUCRole removedRole : removedRoles) {
            try {
                Presence presence = this.createPresence(Presence.Type.unavailable);
                presence.setFrom(removedRole.getRoleAddress());
                Element fragment = presence.addChildElement("x", "http://jabber.org/protocol/muc#user");
                Element item = fragment.addElement("item");
                item.addAttribute("affiliation", "none");
                item.addAttribute("role", "none");
                if (alternateJID != null) {
                    fragment.addElement("destroy").addAttribute("jid", alternateJID.toString());
                }
                if (reason != null && reason.length() > 0) {
                    Element destroy = fragment.element("destroy");
                    if (destroy == null) {
                        destroy = fragment.addElement("destroy");
                    }
                    destroy.addElement("reason").setText(reason);
                }
                removedRole.send((Packet)presence);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (destroyRequest.isOriginator()) {
            MUCPersistenceManager.deleteFromDB(this);
            MUCEventDispatcher.roomDestroyed(this.getRole().getRoleAddress());
        }
    }

    @Override
    public void destroyRoom(JID alternateJID, String reason) {
        DestroyRoomRequest destroyRequest = new DestroyRoomRequest(this, alternateJID, reason);
        destroyRequest.setOriginator(true);
        destroyRequest.run();
    }

    @Override
    public Presence createPresence(Presence.Type presenceType) throws UnauthorizedException {
        Presence presence = new Presence();
        presence.setType(presenceType);
        presence.setFrom(this.role.getRoleAddress());
        return presence;
    }

    @Override
    public void serverBroadcast(String msg) {
        Message message = new Message();
        message.setType(Message.Type.groupchat);
        message.setBody(msg);
        message.setFrom(this.role.getRoleAddress());
        this.broadcast(message);
    }

    @Override
    public void sendPublicMessage(Message message, MUCRole senderRole) throws ForbiddenException {
        if (this.isModerated() && senderRole.getRole().compareTo(MUCRole.Role.participant) > 0) {
            throw new ForbiddenException();
        }
        message.setFrom(senderRole.getRoleAddress());
        this.send((Packet)message);
        MUCEventDispatcher.messageReceived(this.getRole().getRoleAddress(), senderRole.getUserAddress(), senderRole.getNickname(), message);
    }

    @Override
    public void sendPrivatePacket(Packet packet, MUCRole senderRole) throws NotFoundException, ForbiddenException {
        switch (senderRole.getRole()) {
            case none: {
                throw new ForbiddenException();
            }
            default: {
                if (this.canSendPrivateMessage().equals("participants")) {
                    throw new ForbiddenException();
                }
            }
            case participant: {
                if (!this.canSendPrivateMessage().equals("moderators")) break;
                throw new ForbiddenException();
            }
            case moderator: 
        }
        if (this.canSendPrivateMessage().equals("none")) {
            throw new ForbiddenException();
        }
        String resource = packet.getTo().getResource();
        List<MUCRole> occupants = this.occupantsByNickname.get(resource.toLowerCase());
        if (occupants == null || occupants.size() == 0) {
            throw new NotFoundException();
        }
        for (MUCRole occupant : occupants) {
            packet.setFrom(senderRole.getRoleAddress());
            occupant.send(packet);
            if (!(packet instanceof Message)) continue;
            Message message = (Message)packet;
            MUCEventDispatcher.privateMessageRecieved(occupant.getUserAddress(), senderRole.getUserAddress(), message);
        }
    }

    @Override
    public void send(Packet packet) {
        if (packet instanceof Message) {
            this.broadcast((Message)packet);
        } else if (packet instanceof Presence) {
            this.broadcastPresence((Presence)packet, false);
        } else if (packet instanceof IQ) {
            IQ reply = IQ.createResultIQ((IQ)((IQ)packet));
            reply.setChildElement(((IQ)packet).getChildElement());
            reply.setError(PacketError.Condition.bad_request);
            this.router.route(reply);
        }
    }

    private boolean shouldBroadcastPresence(Presence presence) {
        Element frag;
        if (presence == null) {
            return false;
        }
        return !this.hasToCheckRoleToBroadcastPresence() || this.canBroadcastPresence((frag = presence.getChildElement("x", "http://jabber.org/protocol/muc#user")).element("item").attributeValue("role"));
    }

    private void broadcastPresence(Presence presence, boolean isJoinPresence) {
        if (presence == null) {
            return;
        }
        if (!this.shouldBroadcastPresence(presence)) {
            try {
                for (MUCRole occupant : this.getOccupantsByNickname(presence.getFrom().getResource())) {
                    occupant.send((Packet)presence);
                }
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
            return;
        }
        BroadcastPresenceRequest request = new BroadcastPresenceRequest(this, presence, isJoinPresence);
        CacheFactory.doClusterTask(request);
        request = new BroadcastPresenceRequest(this, presence, isJoinPresence);
        request.setOriginator(true);
        request.run();
    }

    public void broadcast(BroadcastPresenceRequest presenceRequest) {
        String jid = null;
        Presence presence = presenceRequest.getPresence();
        JID to = presence.getTo();
        Element frag = presence.getChildElement("x", "http://jabber.org/protocol/muc#user");
        if (!this.canAnyoneDiscoverJID()) {
            jid = frag.element("item").attributeValue("jid");
        }
        for (MUCRole occupant : this.occupantsByFullJID.values()) {
            if (!occupant.isLocal()) continue;
            if (!this.canAnyoneDiscoverJID()) {
                if (MUCRole.Role.moderator == occupant.getRole()) {
                    frag.element("item").addAttribute("jid", jid);
                } else {
                    frag.element("item").addAttribute("jid", null);
                }
            }
            if (occupant.getPresence().getFrom().equals((Object)to)) {
                Presence selfPresence = presence.createCopy();
                Element fragSelfPresence = selfPresence.getChildElement("x", "http://jabber.org/protocol/muc#user");
                fragSelfPresence.addElement("status").addAttribute("code", "110");
                if (presenceRequest.isJoinPresence()) {
                    boolean isRoomNew;
                    boolean bl = isRoomNew = this.isLocked() && this.creationDate.getTime() == this.lockedTime;
                    if (this.canAnyoneDiscoverJID()) {
                        fragSelfPresence.addElement("status").addAttribute("code", "100");
                    }
                    if (isRoomNew) {
                        fragSelfPresence.addElement("status").addAttribute("code", "201");
                    }
                }
                occupant.send((Packet)selfPresence);
                continue;
            }
            occupant.send((Packet)presence);
        }
    }

    private void broadcast(Message message) {
        BroadcastMessageRequest request = new BroadcastMessageRequest(this, message, this.occupantsByFullJID.size());
        CacheFactory.doClusterTask(request);
        request = new BroadcastMessageRequest(this, message, this.occupantsByFullJID.size());
        request.setOriginator(true);
        request.run();
    }

    public void broadcast(BroadcastMessageRequest messageRequest) {
        Message message = messageRequest.getMessage();
        this.roomHistory.addMessage(message);
        for (MUCRole occupant : this.occupantsByFullJID.values()) {
            if (!occupant.isLocal() || occupant.isVoiceOnly()) continue;
            occupant.send((Packet)message);
        }
        if (messageRequest.isOriginator() && this.isLogEnabled()) {
            MUCRole senderRole = null;
            if (message.getFrom() != null && message.getFrom().getResource() != null) {
                List<MUCRole> occupants = this.occupantsByNickname.get(message.getFrom().getResource().toLowerCase());
                senderRole = occupants == null ? null : occupants.get(0);
            }
            JID senderAddress = senderRole == null ? this.getRole().getRoleAddress() : senderRole.getUserAddress();
            this.mucService.logConversation(this, message, senderAddress);
        }
        this.mucService.messageBroadcastedTo(messageRequest.getOccupants());
    }

    @Override
    public long getChatLength() {
        return this.endTime - this.startTime;
    }

    private List<Presence> changeOccupantAffiliation(MUCRole senderRole, JID jid, MUCRole.Affiliation newAffiliation, MUCRole.Role newRole) throws NotAllowedException {
        ArrayList<Presence> presences = new ArrayList<Presence>();
        JID bareJID = jid.asBareJID();
        List<MUCRole> roles = this.occupantsByBareJID.get(bareJID);
        if (roles == null) {
            return presences;
        }
        for (MUCRole role : roles) {
            if (role.isLocal()) {
                role.setAffiliation(newAffiliation);
                role.setRole(newRole);
                CacheFactory.doClusterTask(new UpdateOccupant(this, role));
                presences.add(role.getPresence().createCopy());
                continue;
            }
            Element element = (Element)CacheFactory.doSynchronousClusterTask(new UpdateOccupantRequest(this, role.getNickname(), newAffiliation, newRole), role.getNodeID().toByteArray());
            if (element != null) {
                presences.add(new Presence(element, true));
                continue;
            }
            throw new NotAllowedException();
        }
        return presences;
    }

    private Presence changeOccupantRole(JID jid, MUCRole.Role newRole) throws NotAllowedException {
        MUCRole role = this.occupantsByFullJID.get(jid);
        if (role != null) {
            if (role.isLocal()) {
                role.setRole(newRole);
                CacheFactory.doClusterTask(new UpdateOccupant(this, role));
                return role.getPresence().createCopy();
            }
            Element element = (Element)CacheFactory.doSynchronousClusterTask(new UpdateOccupantRequest(this, role.getNickname(), null, newRole), role.getNodeID().toByteArray());
            if (element != null) {
                return new Presence(element, true);
            }
            throw new NotAllowedException();
        }
        return null;
    }

    static boolean isPrivilegedToChangeAffiliationAndRole(MUCRole.Affiliation actorAffiliation, MUCRole.Role actorRole, MUCRole.Affiliation occupantAffiliation, MUCRole.Role occupantRole, MUCRole.Affiliation newAffiliation, MUCRole.Role newRole) {
        switch (actorAffiliation) {
            case owner: {
                return true;
            }
            case admin: {
                if (occupantAffiliation == newAffiliation) {
                    return occupantAffiliation != MUCRole.Affiliation.owner;
                }
                return occupantAffiliation != MUCRole.Affiliation.owner && newAffiliation != MUCRole.Affiliation.admin && newAffiliation != MUCRole.Affiliation.owner;
            }
        }
        if (actorRole == MUCRole.Role.moderator && occupantAffiliation == newAffiliation && occupantRole == MUCRole.Role.moderator && newRole != MUCRole.Role.moderator) {
            return occupantAffiliation != MUCRole.Affiliation.owner && occupantAffiliation != MUCRole.Affiliation.admin;
        }
        return false;
    }

    @Override
    public void addFirstOwner(JID bareJID) {
        this.owners.add(bareJID.asBareJID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Presence> addOwner(JID jid, MUCRole sendRole) throws ForbiddenException {
        JID bareJID = jid.asBareJID();
        this.lock.writeLock().lock();
        try {
            MUCRole.Affiliation oldAffiliation = MUCRole.Affiliation.none;
            if (MUCRole.Affiliation.owner != sendRole.getAffiliation()) {
                throw new ForbiddenException();
            }
            if (this.owners.contains(bareJID)) {
                List<Presence> list = Collections.emptyList();
                return list;
            }
            this.owners.add(bareJID);
            if (this.removeAdmin(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.admin;
            } else if (this.removeMember(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.member;
            } else if (this.removeOutcast(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.outcast;
            }
            MUCPersistenceManager.saveAffiliationToDB(this, bareJID, null, MUCRole.Affiliation.owner, oldAffiliation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        CacheFactory.doClusterTask(new AddAffiliation(this, jid.toBareJID(), MUCRole.Affiliation.owner));
        return this.applyAffiliationChange(this.getRole(), bareJID, null);
    }

    private boolean removeOwner(JID jid) {
        return this.owners.remove(jid.asBareJID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Presence> addAdmin(JID jid, MUCRole sendRole) throws ForbiddenException, ConflictException {
        JID bareJID = jid.asBareJID();
        this.lock.writeLock().lock();
        try {
            MUCRole.Affiliation oldAffiliation = MUCRole.Affiliation.none;
            if (MUCRole.Affiliation.owner != sendRole.getAffiliation()) {
                throw new ForbiddenException();
            }
            if (this.owners.contains(bareJID) && this.owners.size() == 1) {
                throw new ConflictException();
            }
            if (this.admins.contains(bareJID)) {
                List<Presence> list = Collections.emptyList();
                return list;
            }
            this.admins.add(bareJID);
            if (this.removeOwner(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.owner;
            } else if (this.removeMember(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.member;
            } else if (this.removeOutcast(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.outcast;
            }
            MUCPersistenceManager.saveAffiliationToDB(this, bareJID, null, MUCRole.Affiliation.admin, oldAffiliation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        CacheFactory.doClusterTask(new AddAffiliation(this, jid.toBareJID(), MUCRole.Affiliation.admin));
        return this.applyAffiliationChange(this.getRole(), bareJID, null);
    }

    private boolean removeAdmin(JID bareJID) {
        return this.admins.remove(bareJID.asBareJID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Presence> addMember(JID jid, String nickname, MUCRole sendRole) throws ForbiddenException, ConflictException {
        JID bareJID = jid.asBareJID();
        this.lock.writeLock().lock();
        try {
            MUCRole.Affiliation oldAffiliation;
            MUCRole.Affiliation affiliation = oldAffiliation = this.members.containsKey(bareJID) ? MUCRole.Affiliation.member : MUCRole.Affiliation.none;
            if (this.isMembersOnly() ? !this.canOccupantsInvite() && MUCRole.Affiliation.admin != sendRole.getAffiliation() && MUCRole.Affiliation.owner != sendRole.getAffiliation() : MUCRole.Affiliation.admin != sendRole.getAffiliation() && MUCRole.Affiliation.owner != sendRole.getAffiliation()) {
                throw new ForbiddenException();
            }
            if (nickname != null && nickname.trim().length() > 0 && this.members.containsValue(nickname.toLowerCase()) ? !nickname.equals(this.members.get(bareJID)) : this.isLoginRestrictedToNickname() && (nickname == null || nickname.trim().length() == 0)) {
                throw new ConflictException();
            }
            if (this.owners.contains(bareJID) && this.owners.size() == 1) {
                throw new ConflictException();
            }
            if (this.members.containsKey(bareJID)) {
                List<Presence> list = Collections.emptyList();
                return list;
            }
            this.members.put(bareJID, nickname == null ? "" : nickname.toLowerCase());
            if (this.removeOwner(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.owner;
            } else if (this.removeAdmin(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.admin;
            } else if (this.removeOutcast(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.outcast;
            }
            MUCPersistenceManager.saveAffiliationToDB(this, bareJID, nickname, MUCRole.Affiliation.member, oldAffiliation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        CacheFactory.doClusterTask(new AddMember(this, jid.toBareJID(), nickname == null ? "" : nickname));
        return this.applyAffiliationChange(this.getRole(), bareJID, null);
    }

    private boolean removeMember(JID jid) {
        return this.members.remove(jid.asBareJID()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Presence> addOutcast(JID jid, String reason, MUCRole senderRole) throws NotAllowedException, ForbiddenException, ConflictException {
        JID bareJID = jid.asBareJID();
        this.lock.writeLock().lock();
        try {
            MUCRole.Affiliation oldAffiliation = MUCRole.Affiliation.none;
            if (MUCRole.Affiliation.admin != senderRole.getAffiliation() && MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
                throw new ForbiddenException();
            }
            if (this.owners.contains(bareJID) && this.owners.size() == 1) {
                throw new ConflictException();
            }
            if (this.outcasts.contains(bareJID)) {
                List<Presence> list = Collections.emptyList();
                return list;
            }
            this.outcasts.add(bareJID);
            if (this.removeOwner(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.owner;
            } else if (this.removeAdmin(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.admin;
            } else if (this.removeMember(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.member;
            }
            MUCPersistenceManager.saveAffiliationToDB(this, bareJID, null, MUCRole.Affiliation.outcast, oldAffiliation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        CacheFactory.doClusterTask(new AddAffiliation(this, jid.toBareJID(), MUCRole.Affiliation.outcast));
        return this.applyAffiliationChange(senderRole, bareJID, reason);
    }

    private boolean removeOutcast(JID bareJID) {
        return this.outcasts.remove(bareJID.asBareJID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Presence> addNone(JID jid, MUCRole senderRole) throws ForbiddenException, ConflictException {
        JID bareJID = jid.asBareJID();
        MUCRole.Affiliation oldAffiliation = MUCRole.Affiliation.none;
        boolean jidWasAffiliated = false;
        this.lock.writeLock().lock();
        try {
            if (MUCRole.Affiliation.admin != senderRole.getAffiliation() && MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
                throw new ForbiddenException();
            }
            if (this.owners.contains(bareJID) && this.owners.size() == 1) {
                throw new ConflictException();
            }
            if (this.removeOwner(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.owner;
                jidWasAffiliated = true;
            } else if (this.removeAdmin(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.admin;
                jidWasAffiliated = true;
            } else if (this.removeMember(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.member;
                jidWasAffiliated = true;
            } else if (this.removeOutcast(bareJID)) {
                oldAffiliation = MUCRole.Affiliation.outcast;
            }
            MUCPersistenceManager.removeAffiliationFromDB(this, bareJID, oldAffiliation);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        CacheFactory.doClusterTask(new AddAffiliation(this, jid.toBareJID(), MUCRole.Affiliation.none));
        if (jidWasAffiliated) {
            return this.applyAffiliationChange(senderRole, bareJID, null);
        }
        return Collections.emptyList();
    }

    private List<Presence> applyAffiliationChange(MUCRole senderRole, JID affiliationJID, String reason) {
        ArrayList<JID> affectedOccupants = new ArrayList<JID>();
        if (GroupJID.isGroup(affiliationJID)) {
            try {
                Group group = GroupManager.getInstance().getGroup(affiliationJID);
                for (JID groupMember : group.getAll()) {
                    if (!this.occupantsByBareJID.containsKey(groupMember)) continue;
                    affectedOccupants.add(groupMember);
                }
            }
            catch (GroupNotFoundException gnfe) {
                Log.error("Error updating group presences for " + affiliationJID, (Throwable)gnfe);
            }
        } else if (this.occupantsByBareJID.containsKey(affiliationJID)) {
            affectedOccupants.add(affiliationJID);
        }
        ArrayList<Presence> updatedPresences = new ArrayList<Presence>();
        for (JID occupantJID : affectedOccupants) {
            MUCRole.Affiliation newAffiliation;
            MUCRole.Role newRole;
            Log.info("Applying affiliation change for " + occupantJID);
            boolean kickMember = false;
            boolean isOutcast = false;
            if (this.owners.includes(occupantJID)) {
                newRole = MUCRole.Role.moderator;
                newAffiliation = MUCRole.Affiliation.owner;
            } else if (this.admins.includes(occupantJID)) {
                newRole = MUCRole.Role.moderator;
                newAffiliation = MUCRole.Affiliation.admin;
            } else if (this.outcasts.includes(occupantJID)) {
                newAffiliation = MUCRole.Affiliation.outcast;
                newRole = MUCRole.Role.none;
                kickMember = true;
                isOutcast = true;
            } else if (this.members.includesKey(occupantJID)) {
                newRole = MUCRole.Role.participant;
                newAffiliation = MUCRole.Affiliation.member;
            } else if (this.isMembersOnly()) {
                newRole = MUCRole.Role.none;
                newAffiliation = MUCRole.Affiliation.none;
                kickMember = true;
            } else {
                newRole = this.isModerated() ? MUCRole.Role.visitor : MUCRole.Role.participant;
                newAffiliation = MUCRole.Affiliation.none;
            }
            Log.info("New affiliation: " + (Object)((Object)newAffiliation));
            try {
                List<Presence> thisOccupant = this.changeOccupantAffiliation(senderRole, occupantJID, newAffiliation, newRole);
                if (kickMember) {
                    for (Presence presence : thisOccupant) {
                        presence.setType(Presence.Type.unavailable);
                        presence.setStatus(null);
                        Element x = presence.getChildElement("x", "http://jabber.org/protocol/muc#user");
                        if (reason != null && reason.trim().length() > 0) {
                            x.element("item").addElement("reason").setText(reason);
                        }
                        x.addElement("status").addAttribute("code", isOutcast ? "301" : "321");
                        this.kickPresence(presence, senderRole.getUserAddress(), senderRole.getNickname());
                    }
                }
                updatedPresences.addAll(thisOccupant);
            }
            catch (NotAllowedException e) {
                Log.error("Error updating presences for " + occupantJID, (Throwable)e);
            }
        }
        return updatedPresences;
    }

    @Override
    public boolean isLocked() {
        return this.lockedTime > 0L;
    }

    @Override
    public boolean isManuallyLocked() {
        return this.lockedTime > 0L && this.creationDate.getTime() != this.lockedTime;
    }

    @Override
    public void presenceUpdated(MUCRole occupantRole, Presence newPresence) {
        String occupantNickName = occupantRole.getNickname();
        UpdatePresence localUpdateRequest = new UpdatePresence(this, newPresence.createCopy(), occupantNickName);
        localUpdateRequest.setOriginator(true);
        localUpdateRequest.run();
        Presence updatedPresence = occupantRole.getPresence().createCopy();
        UpdatePresence clusterUpdateRequest = new UpdatePresence(this, updatedPresence, occupantNickName);
        CacheFactory.doClusterTask(clusterUpdateRequest);
        this.broadcastPresence(updatedPresence, false);
    }

    public void presenceUpdated(UpdatePresence updatePresence) {
        List<MUCRole> occupants = this.occupantsByNickname.get(updatePresence.getNickname().toLowerCase());
        if (occupants == null || occupants.size() == 0) {
            Log.debug("LocalMUCRoom: Failed to update presence of room occupant. Occupant nickname: " + updatePresence.getNickname());
        } else {
            for (MUCRole occupant : occupants) {
                occupant.setPresence(updatePresence.getPresence());
            }
        }
    }

    public void occupantUpdated(UpdateOccupant update) {
        List<MUCRole> occupants = this.occupantsByNickname.get(update.getNickname().toLowerCase());
        if (occupants == null || occupants.size() == 0) {
            Log.debug("LocalMUCRoom: Failed to update information of room occupant. Occupant nickname: " + update.getNickname());
        } else {
            for (MUCRole occupant : occupants) {
                if (!occupant.isLocal()) {
                    occupant.setPresence(update.getPresence());
                    try {
                        occupant.setRole(update.getRole());
                        occupant.setAffiliation(update.getAffiliation());
                    }
                    catch (NotAllowedException notAllowedException) {}
                    continue;
                }
                Log.error(MessageFormat.format("Ignoring update of local occupant with info from a remote occupant. Occupant nickname: {0} new role: {1} new affiliation: {2}", new Object[]{update.getNickname(), update.getRole(), update.getAffiliation()}));
            }
        }
    }

    public Presence updateOccupant(UpdateOccupantRequest updateRequest) throws NotAllowedException {
        Presence result = null;
        List<MUCRole> occupants = this.occupantsByNickname.get(updateRequest.getNickname().toLowerCase());
        if (occupants == null || occupants.size() == 0) {
            Log.debug("Failed to update information of local room occupant; nickname: " + updateRequest.getNickname());
        } else {
            for (MUCRole occupant : occupants) {
                if (updateRequest.isAffiliationChanged()) {
                    occupant.setAffiliation(updateRequest.getAffiliation());
                }
                occupant.setRole(updateRequest.getRole());
                CacheFactory.doClusterTask(new UpdateOccupant(this, occupant));
                if (result != null) continue;
                result = occupant.getPresence();
            }
        }
        return result;
    }

    public void memberAdded(AddMember addMember) {
        JID bareJID = addMember.getBareJID();
        this.removeOwner(bareJID);
        this.removeAdmin(bareJID);
        this.removeOutcast(bareJID);
        this.members.put(addMember.getBareJID(), addMember.getNickname().toLowerCase());
    }

    public void affiliationAdded(AddAffiliation affiliation) {
        JID affiliationJID = affiliation.getBareJID();
        switch (affiliation.getAffiliation()) {
            case owner: {
                this.removeMember(affiliationJID);
                this.removeAdmin(affiliationJID);
                this.removeOutcast(affiliationJID);
                this.owners.add(affiliationJID);
                break;
            }
            case admin: {
                this.removeMember(affiliationJID);
                this.removeOwner(affiliationJID);
                this.removeOutcast(affiliationJID);
                this.admins.add(affiliationJID);
                break;
            }
            case outcast: {
                this.removeMember(affiliationJID);
                this.removeAdmin(affiliationJID);
                this.removeOwner(affiliationJID);
                this.outcasts.add(affiliationJID);
                break;
            }
            default: {
                this.removeMember(affiliationJID);
                this.removeAdmin(affiliationJID);
                this.removeOwner(affiliationJID);
                this.removeOutcast(affiliationJID);
            }
        }
    }

    @Override
    public void nicknameChanged(MUCRole occupantRole, Presence newPresence, String oldNick, String newNick) {
        ChangeNickname request = new ChangeNickname(this, oldNick, newNick, newPresence.createCopy());
        CacheFactory.doClusterTask(request);
        request = new ChangeNickname(this, oldNick, newNick, newPresence.createCopy());
        request.setOriginator(true);
        request.run();
        this.broadcastPresence(occupantRole.getPresence().createCopy(), false);
    }

    public void nicknameChanged(ChangeNickname changeNickname) {
        List<MUCRole> occupants = this.occupantsByNickname.get(changeNickname.getOldNick().toLowerCase());
        if (occupants != null && occupants.size() > 0) {
            for (MUCRole occupant : occupants) {
                occupant.setPresence(changeNickname.getPresence());
                occupant.changeNickname(changeNickname.getNewNick());
            }
            if (changeNickname.isOriginator()) {
                MUCEventDispatcher.nicknameChanged(this.getRole().getRoleAddress(), occupants.get(0).getUserAddress(), changeNickname.getOldNick(), changeNickname.getNewNick());
            }
            this.occupantsByNickname.put(changeNickname.getNewNick().toLowerCase(), occupants);
            this.occupantsByNickname.remove(changeNickname.getOldNick().toLowerCase());
        }
    }

    @Override
    public void changeSubject(Message packet, MUCRole role) throws ForbiddenException {
        if (!(this.canOccupantsChangeSubject() && role.getRole().compareTo(MUCRole.Role.visitor) < 0 || MUCRole.Role.moderator == role.getRole())) {
            throw new ForbiddenException();
        }
        this.subject = packet.getSubject();
        MUCPersistenceManager.updateRoomSubject(this);
        packet.setFrom(role.getRoleAddress());
        this.send((Packet)packet);
        MUCEventDispatcher.roomSubjectChanged(this.getJID(), role.getUserAddress(), this.subject);
        CacheFactory.doClusterTask(new RoomUpdatedEvent(this));
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public void sendInvitation(JID to, String reason, MUCRole senderRole, List<Element> extensions) throws ForbiddenException, CannotBeInvitedException {
        Element frag;
        Message message;
        if (!this.isMembersOnly() || this.canOccupantsInvite() || MUCRole.Affiliation.admin == senderRole.getAffiliation() || MUCRole.Affiliation.owner == senderRole.getAffiliation()) {
            message = new Message();
            message.setFrom(this.role.getRoleAddress());
            message.setTo(to);
            if (((MultiUserChatServiceImpl)this.mucService).getMUCDelegate() != null) {
                switch (((MultiUserChatServiceImpl)this.mucService).getMUCDelegate().sendingInvitation(this, to, senderRole.getUserAddress(), reason)) {
                    case HANDLED_BY_DELEGATE: {
                        return;
                    }
                    case HANDLED_BY_OPENFIRE: {
                        break;
                    }
                    case REJECTED: {
                        throw new CannotBeInvitedException();
                    }
                }
            }
            if (extensions != null) {
                for (Element element : extensions) {
                    element.setParent(null);
                    message.getElement().add(element);
                }
            }
            frag = message.addChildElement("x", "http://jabber.org/protocol/muc#user");
            if (senderRole.getUserAddress() != null) {
                frag.addElement("invite").addAttribute("from", senderRole.getUserAddress().toBareJID());
            }
            if (reason != null && reason.length() > 0) {
                Element invite = frag.element("invite");
                if (invite == null) {
                    invite = frag.addElement("invite");
                }
                invite.addElement("reason").setText(reason);
            }
            if (this.isPasswordProtected()) {
                frag.addElement("password").setText(this.getPassword());
            }
        } else {
            throw new ForbiddenException();
        }
        frag = message.addChildElement("x", "jabber:x:conference");
        frag.addAttribute("jid", this.role.getRoleAddress().toBareJID());
        this.router.route(message);
    }

    @Override
    public void sendInvitationRejection(JID to, String reason, JID sender) {
        if (((MultiUserChatServiceImpl)this.mucService).getMUCDelegate() != null) {
            switch (((MultiUserChatServiceImpl)this.mucService).getMUCDelegate().sendingInvitationRejection(this, to, sender, reason)) {
                case HANDLED_BY_DELEGATE: {
                    return;
                }
            }
        }
        Message message = new Message();
        message.setFrom(this.role.getRoleAddress());
        message.setTo(to);
        Element frag = message.addChildElement("x", "http://jabber.org/protocol/muc#user");
        frag.addElement("decline").addAttribute("from", sender.toBareJID());
        if (reason != null && reason.length() > 0) {
            frag.element("decline").addElement("reason").setText(reason);
        }
        this.router.route(message);
    }

    @Override
    public IQOwnerHandler getIQOwnerHandler() {
        return this.iqOwnerHandler;
    }

    @Override
    public IQAdminHandler getIQAdminHandler() {
        return this.iqAdminHandler;
    }

    @Override
    public MUCRoomHistory getRoomHistory() {
        return this.roomHistory;
    }

    @Override
    public Collection<JID> getOwners() {
        return Collections.unmodifiableList(this.owners);
    }

    @Override
    public Collection<JID> getAdmins() {
        return Collections.unmodifiableList(this.admins);
    }

    @Override
    public Collection<JID> getMembers() {
        return Collections.unmodifiableMap(this.members).keySet();
    }

    @Override
    public Collection<JID> getOutcasts() {
        return Collections.unmodifiableList(this.outcasts);
    }

    @Override
    public Collection<MUCRole> getModerators() {
        ArrayList<MUCRole> moderators = new ArrayList<MUCRole>();
        for (MUCRole role : this.occupantsByFullJID.values()) {
            if (MUCRole.Role.moderator != role.getRole()) continue;
            moderators.add(role);
        }
        return moderators;
    }

    @Override
    public Collection<MUCRole> getParticipants() {
        ArrayList<MUCRole> participants = new ArrayList<MUCRole>();
        for (MUCRole role : this.occupantsByFullJID.values()) {
            if (MUCRole.Role.participant != role.getRole()) continue;
            participants.add(role);
        }
        return participants;
    }

    @Override
    public Presence addModerator(JID jid, MUCRole senderRole) throws ForbiddenException {
        if (MUCRole.Affiliation.admin != senderRole.getAffiliation() && MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
            throw new ForbiddenException();
        }
        try {
            return this.changeOccupantRole(jid, MUCRole.Role.moderator);
        }
        catch (NotAllowedException e) {
            return null;
        }
    }

    @Override
    public Presence addParticipant(JID jid, String reason, MUCRole senderRole) throws NotAllowedException, ForbiddenException {
        if (MUCRole.Role.moderator != senderRole.getRole()) {
            throw new ForbiddenException();
        }
        Presence updatedPresence = this.changeOccupantRole(jid, MUCRole.Role.participant);
        if (updatedPresence != null) {
            Element frag = updatedPresence.getChildElement("x", "http://jabber.org/protocol/muc#user");
            if (reason != null && reason.trim().length() > 0) {
                frag.element("item").addElement("reason").setText(reason);
            }
        }
        return updatedPresence;
    }

    @Override
    public Presence addVisitor(JID jid, MUCRole senderRole) throws NotAllowedException, ForbiddenException {
        if (MUCRole.Role.moderator != senderRole.getRole()) {
            throw new ForbiddenException();
        }
        return this.changeOccupantRole(jid, MUCRole.Role.visitor);
    }

    @Override
    public Presence kickOccupant(JID jid, JID actorJID, String actorNickname, String reason) throws NotAllowedException {
        Presence updatedPresence = this.changeOccupantRole(jid, MUCRole.Role.none);
        if (updatedPresence != null) {
            Element frag = updatedPresence.getChildElement("x", "http://jabber.org/protocol/muc#user");
            frag.addElement("status").addAttribute("code", "307");
            if (reason != null && reason.trim().length() > 0) {
                frag.element("item").addElement("reason").setText(reason);
            }
            this.kickPresence(updatedPresence, actorJID, actorNickname);
            this.broadcastPresence(updatedPresence, false);
        }
        return updatedPresence;
    }

    private void kickPresence(Presence kickPresence, JID actorJID, String nick) {
        ArrayList occupants = new ArrayList(this.occupantsByNickname.get(kickPresence.getFrom().getResource().toLowerCase()));
        for (MUCRole kickedRole : occupants) {
            if (actorJID != null && actorJID.toString().length() > 0) {
                Element frag = kickPresence.getChildElement("x", "http://jabber.org/protocol/muc#user");
                Element actor = frag.element("item").addElement("actor");
                actor.addAttribute("jid", actorJID.toBareJID());
                if (nick != null) {
                    actor.addAttribute("nick", nick);
                }
            }
            kickedRole.send((Packet)kickPresence);
            OccupantLeftEvent event = new OccupantLeftEvent(this, kickedRole);
            event.setOriginator(true);
            event.run();
            event = new OccupantLeftEvent(this, kickedRole);
            CacheFactory.doClusterTask(event);
        }
    }

    @Override
    public boolean canAnyoneDiscoverJID() {
        return this.canAnyoneDiscoverJID;
    }

    @Override
    public void setCanAnyoneDiscoverJID(boolean canAnyoneDiscoverJID) {
        this.canAnyoneDiscoverJID = canAnyoneDiscoverJID;
    }

    @Override
    public String canSendPrivateMessage() {
        return this.canSendPrivateMessage == null ? "anyone" : this.canSendPrivateMessage;
    }

    @Override
    public void setCanSendPrivateMessage(String role) {
        if (role == null) {
            role = "(null)";
        }
        switch (role.toLowerCase()) {
            case "none": 
            case "moderators": 
            case "participants": 
            case "anyone": {
                this.canSendPrivateMessage = role.toLowerCase();
                break;
            }
            default: {
                Log.warn("Illegal value for muc#roomconfig_allowpm: '{}'. Defaulting to 'anyone'", (Object)role.toLowerCase());
                this.canSendPrivateMessage = "anyone";
            }
        }
    }

    @Override
    public boolean canOccupantsChangeSubject() {
        return this.canOccupantsChangeSubject;
    }

    @Override
    public void setCanOccupantsChangeSubject(boolean canOccupantsChangeSubject) {
        this.canOccupantsChangeSubject = canOccupantsChangeSubject;
    }

    @Override
    public boolean canOccupantsInvite() {
        return this.canOccupantsInvite;
    }

    @Override
    public void setCanOccupantsInvite(boolean canOccupantsInvite) {
        this.canOccupantsInvite = canOccupantsInvite;
    }

    @Override
    public String getNaturalLanguageName() {
        return this.naturalLanguageName;
    }

    @Override
    public void setNaturalLanguageName(String naturalLanguageName) {
        this.naturalLanguageName = naturalLanguageName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isMembersOnly() {
        return this.membersOnly;
    }

    @Override
    public List<Presence> setMembersOnly(boolean membersOnly) {
        ArrayList<Presence> presences = new ArrayList<Presence>();
        if (membersOnly && !this.membersOnly) {
            for (MUCRole occupant : this.occupantsByFullJID.values()) {
                if (occupant.getAffiliation().compareTo(MUCRole.Affiliation.member) <= 0) continue;
                try {
                    presences.add(this.kickOccupant(occupant.getRoleAddress(), null, null, LocaleUtils.getLocalizedString("muc.roomIsNowMembersOnly")));
                }
                catch (NotAllowedException e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.membersOnly = membersOnly;
        return presences;
    }

    @Override
    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Override
    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    @Override
    public void setLoginRestrictedToNickname(boolean restricted) {
        this.loginRestrictedToNickname = restricted;
    }

    @Override
    public boolean isLoginRestrictedToNickname() {
        return this.loginRestrictedToNickname;
    }

    @Override
    public void setChangeNickname(boolean canChange) {
        this.canChangeNickname = canChange;
    }

    @Override
    public boolean canChangeNickname() {
        return this.canChangeNickname;
    }

    @Override
    public void setRegistrationEnabled(boolean registrationEnabled) {
        this.registrationEnabled = registrationEnabled;
    }

    @Override
    public boolean isRegistrationEnabled() {
        return this.registrationEnabled;
    }

    @Override
    public int getMaxUsers() {
        return this.maxUsers;
    }

    @Override
    public void setMaxUsers(int maxUsers) {
        this.maxUsers = maxUsers;
    }

    @Override
    public boolean isModerated() {
        return this.moderated;
    }

    @Override
    public void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPasswordProtected() {
        return this.password != null && this.password.trim().length() > 0;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public boolean wasSavedToDB() {
        return this.isPersistent() && this.savedToDB;
    }

    @Override
    public void setSavedToDB(boolean saved) {
        this.savedToDB = saved;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public boolean isPublicRoom() {
        return !this.isDestroyed && this.publicRoom;
    }

    @Override
    public void setPublicRoom(boolean publicRoom) {
        this.publicRoom = publicRoom;
    }

    @Override
    public List<String> getRolesToBroadcastPresence() {
        return Collections.unmodifiableList(this.rolesToBroadcastPresence);
    }

    @Override
    public void setRolesToBroadcastPresence(List<String> rolesToBroadcastPresence) {
        this.rolesToBroadcastPresence = rolesToBroadcastPresence;
    }

    private boolean hasToCheckRoleToBroadcastPresence() {
        return this.rolesToBroadcastPresence.size() < 3;
    }

    @Override
    public boolean canBroadcastPresence(String roleToBroadcast) {
        return "none".equals(roleToBroadcast) || this.rolesToBroadcastPresence.contains(roleToBroadcast);
    }

    @Override
    public void lock(MUCRole senderRole) throws ForbiddenException {
        if (MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
            throw new ForbiddenException();
        }
        if (this.isLocked()) {
            return;
        }
        this.setLocked(true);
    }

    @Override
    public void unlock(MUCRole senderRole) throws ForbiddenException {
        if (MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
            throw new ForbiddenException();
        }
        if (!this.isLocked()) {
            return;
        }
        this.setLocked(false);
    }

    private void setLocked(boolean locked) {
        this.lockedTime = locked ? System.currentTimeMillis() : 0L;
        MUCPersistenceManager.updateRoomLock(this);
    }

    void setLockedDate(Date lockedTime) {
        this.lockedTime = lockedTime.getTime();
    }

    Date getLockedDate() {
        return new Date(this.lockedTime);
    }

    @Override
    public List<Presence> addAdmins(List<JID> newAdmins, MUCRole senderRole) throws ForbiddenException, ConflictException {
        ArrayList<Presence> answer = new ArrayList<Presence>(newAdmins.size());
        for (JID newAdmin : newAdmins) {
            JID bareJID = newAdmin.asBareJID();
            if (this.admins.contains(bareJID)) continue;
            answer.addAll(this.addAdmin(bareJID, senderRole));
        }
        return answer;
    }

    @Override
    public List<Presence> addOwners(List<JID> newOwners, MUCRole senderRole) throws ForbiddenException {
        ArrayList<Presence> answer = new ArrayList<Presence>(newOwners.size());
        for (JID newOwner : newOwners) {
            JID bareJID = newOwner.asBareJID();
            if (this.owners.contains(newOwner)) continue;
            answer.addAll(this.addOwner(bareJID, senderRole));
        }
        return answer;
    }

    @Override
    public void saveToDB() {
        MUCPersistenceManager.saveToDB(this);
        if (!this.savedToDB) {
            this.savedToDB = true;
            for (JID owner : this.owners) {
                MUCPersistenceManager.saveAffiliationToDB(this, owner, null, MUCRole.Affiliation.owner, MUCRole.Affiliation.none);
            }
            for (JID admin : this.admins) {
                MUCPersistenceManager.saveAffiliationToDB(this, admin, null, MUCRole.Affiliation.admin, MUCRole.Affiliation.none);
            }
            for (JID bareJID : this.members.keySet()) {
                MUCPersistenceManager.saveAffiliationToDB(this, bareJID, (String)this.members.get(bareJID), MUCRole.Affiliation.member, MUCRole.Affiliation.none);
            }
            for (JID outcast : this.outcasts) {
                MUCPersistenceManager.saveAffiliationToDB(this, outcast, null, MUCRole.Affiliation.outcast, MUCRole.Affiliation.none);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.name);
        ExternalizableUtil.getInstance().writeLong(out, this.startTime);
        ExternalizableUtil.getInstance().writeLong(out, this.lockedTime);
        ExternalizableUtil.getInstance().writeSerializableCollection(out, this.owners);
        ExternalizableUtil.getInstance().writeSerializableCollection(out, this.admins);
        ExternalizableUtil.getInstance().writeSerializableMap(out, this.members);
        ExternalizableUtil.getInstance().writeSerializableCollection(out, this.outcasts);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.naturalLanguageName);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.description);
        ExternalizableUtil.getInstance().writeBoolean(out, this.canOccupantsChangeSubject);
        ExternalizableUtil.getInstance().writeInt(out, this.maxUsers);
        ExternalizableUtil.getInstance().writeStringList(out, this.rolesToBroadcastPresence);
        ExternalizableUtil.getInstance().writeBoolean(out, this.publicRoom);
        ExternalizableUtil.getInstance().writeBoolean(out, this.persistent);
        ExternalizableUtil.getInstance().writeBoolean(out, this.moderated);
        ExternalizableUtil.getInstance().writeBoolean(out, this.membersOnly);
        ExternalizableUtil.getInstance().writeBoolean(out, this.canOccupantsInvite);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.password);
        ExternalizableUtil.getInstance().writeBoolean(out, this.canAnyoneDiscoverJID);
        ExternalizableUtil.getInstance().writeBoolean(out, this.logEnabled);
        ExternalizableUtil.getInstance().writeBoolean(out, this.loginRestrictedToNickname);
        ExternalizableUtil.getInstance().writeBoolean(out, this.canChangeNickname);
        ExternalizableUtil.getInstance().writeBoolean(out, this.registrationEnabled);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.subject);
        ExternalizableUtil.getInstance().writeLong(out, this.roomID);
        ExternalizableUtil.getInstance().writeLong(out, this.creationDate.getTime());
        ExternalizableUtil.getInstance().writeLong(out, this.modificationDate.getTime());
        ExternalizableUtil.getInstance().writeBoolean(out, this.emptyDate != null);
        if (this.emptyDate != null) {
            ExternalizableUtil.getInstance().writeLong(out, this.emptyDate.getTime());
        }
        ExternalizableUtil.getInstance().writeBoolean(out, this.savedToDB);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.mucService.getServiceName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.startTime = ExternalizableUtil.getInstance().readLong(in);
        this.lockedTime = ExternalizableUtil.getInstance().readLong(in);
        ExternalizableUtil.getInstance().readSerializableCollection(in, this.owners, this.getClass().getClassLoader());
        ExternalizableUtil.getInstance().readSerializableCollection(in, this.admins, this.getClass().getClassLoader());
        ExternalizableUtil.getInstance().readSerializableMap(in, this.members, this.getClass().getClassLoader());
        ExternalizableUtil.getInstance().readSerializableCollection(in, this.outcasts, this.getClass().getClassLoader());
        this.naturalLanguageName = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.description = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.canOccupantsChangeSubject = ExternalizableUtil.getInstance().readBoolean(in);
        this.maxUsers = ExternalizableUtil.getInstance().readInt(in);
        this.rolesToBroadcastPresence.addAll(ExternalizableUtil.getInstance().readStringList(in));
        this.publicRoom = ExternalizableUtil.getInstance().readBoolean(in);
        this.persistent = ExternalizableUtil.getInstance().readBoolean(in);
        this.moderated = ExternalizableUtil.getInstance().readBoolean(in);
        this.membersOnly = ExternalizableUtil.getInstance().readBoolean(in);
        this.canOccupantsInvite = ExternalizableUtil.getInstance().readBoolean(in);
        this.password = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.canAnyoneDiscoverJID = ExternalizableUtil.getInstance().readBoolean(in);
        this.logEnabled = ExternalizableUtil.getInstance().readBoolean(in);
        this.loginRestrictedToNickname = ExternalizableUtil.getInstance().readBoolean(in);
        this.canChangeNickname = ExternalizableUtil.getInstance().readBoolean(in);
        this.registrationEnabled = ExternalizableUtil.getInstance().readBoolean(in);
        this.subject = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.roomID = ExternalizableUtil.getInstance().readLong(in);
        this.creationDate = new Date(ExternalizableUtil.getInstance().readLong(in));
        this.modificationDate = new Date(ExternalizableUtil.getInstance().readLong(in));
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.emptyDate = new Date(ExternalizableUtil.getInstance().readLong(in));
        }
        this.savedToDB = ExternalizableUtil.getInstance().readBoolean(in);
        String subdomain = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.mucService = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(subdomain);
        if (this.mucService == null) {
            throw new IllegalArgumentException("MUC service not found for subdomain: " + subdomain);
        }
        this.roomHistory = new MUCRoomHistory(this, new HistoryStrategy(this.mucService.getHistoryStrategy()));
        PacketRouter packetRouter = XMPPServer.getInstance().getPacketRouter();
        this.iqOwnerHandler = new IQOwnerHandler(this, packetRouter);
        this.iqAdminHandler = new IQAdminHandler(this, packetRouter);
        this.router = packetRouter;
    }

    public void updateConfiguration(LocalMUCRoom otherRoom) {
        this.startTime = otherRoom.startTime;
        this.lockedTime = otherRoom.lockedTime;
        this.owners = otherRoom.owners;
        this.admins = otherRoom.admins;
        this.members = otherRoom.members;
        this.outcasts = otherRoom.outcasts;
        this.naturalLanguageName = otherRoom.naturalLanguageName;
        this.description = otherRoom.description;
        this.canOccupantsChangeSubject = otherRoom.canOccupantsChangeSubject;
        this.maxUsers = otherRoom.maxUsers;
        this.rolesToBroadcastPresence = otherRoom.rolesToBroadcastPresence;
        this.publicRoom = otherRoom.publicRoom;
        this.persistent = otherRoom.persistent;
        this.moderated = otherRoom.moderated;
        this.membersOnly = otherRoom.membersOnly;
        this.canOccupantsInvite = otherRoom.canOccupantsInvite;
        this.password = otherRoom.password;
        this.canAnyoneDiscoverJID = otherRoom.canAnyoneDiscoverJID;
        this.logEnabled = otherRoom.logEnabled;
        this.loginRestrictedToNickname = otherRoom.loginRestrictedToNickname;
        this.canChangeNickname = otherRoom.canChangeNickname;
        this.registrationEnabled = otherRoom.registrationEnabled;
        this.subject = otherRoom.subject;
        this.roomID = otherRoom.roomID;
        this.creationDate = otherRoom.creationDate;
        this.modificationDate = otherRoom.modificationDate;
        this.emptyDate = otherRoom.emptyDate;
        this.savedToDB = otherRoom.savedToDB;
        this.mucService = otherRoom.mucService;
    }

    public String getUID() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (int)(this.roomID ^ this.roomID >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalMUCRoom other = (LocalMUCRoom)obj;
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.roomID == other.roomID;
    }

    @Override
    public void groupDeleting(Group group, Map params) {
        GroupJID groupJID = group.getJID();
        try {
            this.addNone(groupJID, this.getRole());
        }
        catch (Exception ex) {
            Log.error("Failed to remove deleted group from affiliation lists: " + (Object)((Object)groupJID), (Throwable)ex);
        }
    }

    @Override
    public void groupModified(Group group, Map params) {
        if ("nameModified".equals(params.get("type"))) {
            GroupJID originalJID = (GroupJID)((Object)params.get("originalJID"));
            GroupJID newJID = group.getJID();
            try {
                if (this.owners.contains((Object)originalJID)) {
                    this.addOwner(newJID, this.getRole());
                } else if (this.admins.contains((Object)originalJID)) {
                    this.addAdmin(newJID, this.getRole());
                } else if (this.outcasts.contains((Object)originalJID)) {
                    this.addOutcast(newJID, null, this.getRole());
                } else if (this.members.containsKey((Object)originalJID)) {
                    this.addMember(newJID, null, this.getRole());
                }
                this.addNone(originalJID, this.getRole());
            }
            catch (Exception ex) {
                Log.error("Failed to update group affiliation for " + (Object)((Object)newJID), (Throwable)ex);
            }
        }
    }

    @Override
    public void memberAdded(Group group, Map params) {
        this.applyAffiliationChangeAndSendPresence(new JID((String)params.get("member")));
    }

    @Override
    public void memberRemoved(Group group, Map params) {
        this.applyAffiliationChangeAndSendPresence(new JID((String)params.get("member")));
    }

    @Override
    public void adminAdded(Group group, Map params) {
        this.applyAffiliationChangeAndSendPresence(new JID((String)params.get("admin")));
    }

    @Override
    public void adminRemoved(Group group, Map params) {
        this.applyAffiliationChangeAndSendPresence(new JID((String)params.get("admin")));
    }

    private void applyAffiliationChangeAndSendPresence(JID groupMember) {
        List<Presence> presences = this.applyAffiliationChange(this.getRole(), groupMember, null);
        for (Presence presence : presences) {
            this.send((Packet)presence);
        }
    }

    @Override
    public void groupCreated(Group group, Map params) {
    }

    private class RoomRole
    implements MUCRole {
        private MUCRoom room;
        private JID crJID = null;

        private RoomRole(MUCRoom room) {
            this.room = room;
        }

        @Override
        public Presence getPresence() {
            return null;
        }

        @Override
        public void setPresence(Presence presence) {
        }

        @Override
        public void setRole(MUCRole.Role newRole) {
        }

        @Override
        public MUCRole.Role getRole() {
            return MUCRole.Role.moderator;
        }

        @Override
        public void setAffiliation(MUCRole.Affiliation newAffiliation) {
        }

        @Override
        public MUCRole.Affiliation getAffiliation() {
            return MUCRole.Affiliation.owner;
        }

        @Override
        public void changeNickname(String nickname) {
        }

        @Override
        public String getNickname() {
            return null;
        }

        @Override
        public boolean isVoiceOnly() {
            return false;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public NodeID getNodeID() {
            return XMPPServer.getInstance().getNodeID();
        }

        @Override
        public MUCRoom getChatRoom() {
            return this.room;
        }

        @Override
        public JID getRoleAddress() {
            if (this.crJID == null) {
                this.crJID = new JID(this.room.getName(), LocalMUCRoom.this.mucService.getServiceDomain(), null, true);
            }
            return this.crJID;
        }

        @Override
        public JID getUserAddress() {
            return null;
        }

        @Override
        public void send(Packet packet) {
            this.room.send(packet);
        }

        @Override
        public void destroy() {
        }
    }
}

