/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.cluster.QueuedTasksManager;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MUCRoomTask<V>
implements ClusterTask<V> {
    private static final Logger Log = LoggerFactory.getLogger(MUCRoomTask.class);
    private boolean originator;
    private String roomName;
    private String subdomain;

    protected MUCRoomTask() {
    }

    protected MUCRoomTask(LocalMUCRoom room) {
        this.roomName = room.getName();
        this.subdomain = room.getMUCService().getServiceName();
    }

    public LocalMUCRoom getRoom() {
        MultiUserChatService mucService = XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(this.subdomain);
        if (mucService == null) {
            throw new IllegalArgumentException("MUC service not found for subdomain: " + this.subdomain);
        }
        LocalMUCRoom room = (LocalMUCRoom)mucService.getChatRoom(this.roomName);
        if (room == null) {
            throw new IllegalArgumentException("Room not found: " + this.roomName);
        }
        return room;
    }

    protected void execute(Runnable runnable) {
        boolean clusterStarting = ClusterManager.isClusteringStarting();
        try {
            this.getRoom();
            runnable.run();
        }
        catch (IllegalArgumentException e) {
            if (clusterStarting) {
                QueuedTasksManager.getInstance().addTask(this);
            }
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isOriginator() {
        return this.originator;
    }

    public void setOriginator(boolean originator) {
        this.originator = originator;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeBoolean(out, this.originator);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.roomName);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.subdomain);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.originator = ExternalizableUtil.getInstance().readBoolean(in);
        this.roomName = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.subdomain = ExternalizableUtil.getInstance().readSafeUTF(in);
    }
}

