/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.lockout;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class LockOutFlag
implements Cacheable,
Externalizable {
    private String username;
    private Date startTime = null;
    private Date endTime = null;

    public LockOutFlag() {
    }

    public LockOutFlag(String username, Date startTime, Date endTime) {
        this.username = username;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfString(this.username);
        size += CacheSizes.sizeOfDate();
        return size += CacheSizes.sizeOfDate();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.username);
        ExternalizableUtil.getInstance().writeLong(out, this.startTime != null ? this.startTime.getTime() : -1L);
        ExternalizableUtil.getInstance().writeLong(out, this.endTime != null ? this.endTime.getTime() : -1L);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.username = ExternalizableUtil.getInstance().readSafeUTF(in);
        long st = ExternalizableUtil.getInstance().readLong(in);
        this.startTime = st != -1L ? new Date(st) : null;
        long et = ExternalizableUtil.getInstance().readLong(in);
        this.endTime = et != -1L ? new Date(et) : null;
    }
}

