/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import javax.naming.Context;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.openfire.vcard.DefaultVCardProvider;
import org.jivesoftware.openfire.vcard.PhotoResizer;
import org.jivesoftware.openfire.vcard.VCardManager;
import org.jivesoftware.openfire.vcard.VCardProvider;
import org.jivesoftware.util.AlreadyExistsException;
import org.jivesoftware.util.Base64;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.NotFoundException;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class LdapVCardProvider
implements VCardProvider,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(LdapVCardProvider.class);
    private LdapManager manager;
    private VCardTemplate template;
    private Boolean dbStorageEnabled = false;
    private DefaultVCardProvider defaultProvider = null;

    public LdapVCardProvider() {
        JiveGlobals.migrateProperty("ldap.vcard-mapping");
        this.manager = LdapManager.getInstance();
        this.initTemplate();
        PropertyEventDispatcher.addListener(this);
        this.defaultProvider = new DefaultVCardProvider();
        this.dbStorageEnabled = JiveGlobals.getBooleanProperty("ldap.override.avatar", false);
    }

    private void initTemplate() {
        String property = JiveGlobals.getProperty("ldap.vcard-mapping");
        Log.debug("LdapVCardProvider: Found vcard mapping: '" + property);
        try {
            if (property.startsWith("<![CDATA[")) {
                property = property.substring(9, property.length() - 3);
            }
            Document document = DocumentHelper.parseText((String)property);
            this.template = new VCardTemplate(document);
        }
        catch (Exception e) {
            Log.error("Error loading vcard mapping: " + e.getMessage());
        }
        Log.debug("LdapVCardProvider: attributes size==" + this.template.getAttributes().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getLdapAttributes(String username) {
        username = JID.unescapeNode((String)username);
        HashMap<String, String> map = new HashMap<String, String>();
        Context ctx = null;
        try {
            String userDN = this.manager.findUserDN(username);
            ctx = this.manager.getContext(this.manager.getUsersBaseDN(username));
            Attributes attrs = ctx.getAttributes(userDN, this.template.getAttributes());
            for (String attribute : this.template.getAttributes()) {
                String value;
                Attribute attr = attrs.get(attribute);
                if (attr == null) {
                    Log.debug("LdapVCardProvider: No ldap value found for attribute '" + attribute + "'");
                    value = "";
                } else {
                    Object ob = attrs.get(attribute).get();
                    Log.debug("LdapVCardProvider: Found attribute " + attribute + " of type: " + ob.getClass());
                    value = ob instanceof String ? (String)ob : Base64.encodeBytes((byte[])ob);
                }
                Log.debug("LdapVCardProvider: Ldap attribute '" + attribute + "'=>'" + value + "'");
                map.put(attribute, value);
            }
            HashMap<String, String> exception = map;
            return exception;
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            Map<String, String> map2 = Collections.emptyMap();
            return map2;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Element loadVCard(String username) {
        Element avatarElement;
        username = JID.unescapeNode((String)username);
        Map<String, String> map = this.getLdapAttributes(username);
        Log.debug("LdapVCardProvider: Getting mapped vcard for " + username);
        Element vcard = new VCard(this.template).getVCard(map);
        if (this.dbStorageEnabled.booleanValue() && vcard != null && (vcard.element("PHOTO") == null || vcard.element("PHOTO").element("BINVAL") == null || vcard.element("PHOTO").element("BINVAL").getText().matches("\\s*")) && (avatarElement = this.loadAvatarFromDatabase(username)) != null) {
            Log.debug("LdapVCardProvider: Adding avatar element from local storage");
            Element currentElement = vcard.element("PHOTO");
            if (currentElement != null) {
                vcard.remove(currentElement);
            }
            vcard.add(avatarElement);
        }
        if (JiveGlobals.getBooleanProperty("avatar.resize.enable-on-load", true)) {
            PhotoResizer.resizeAvatar(vcard);
        }
        Log.debug("LdapVCardProvider: Returning vcard");
        return vcard;
    }

    private Element getMergedVCard(String username, Element mergeVCard) {
        username = JID.unescapeNode((String)username);
        Map<String, String> map = this.getLdapAttributes(username);
        Log.debug("LdapVCardProvider: Retrieving LDAP mapped vcard for " + username);
        if (map.isEmpty()) {
            return null;
        }
        Element vcard = new VCard(this.template).getVCard(map);
        if (mergeVCard == null) {
            return vcard;
        }
        if (mergeVCard.element("PHOTO") == null) {
            return vcard;
        }
        Element photoElement = mergeVCard.element("PHOTO").createCopy();
        if (photoElement == null || photoElement.element("BINVAL") == null || photoElement.element("BINVAL").getText().matches("\\s*")) {
            return vcard;
        }
        if (vcard.element("PHOTO") != null && vcard.element("PHOTO").element("BINVAL") != null && !vcard.element("PHOTO").element("BINVAL").getText().matches("\\s*")) {
            return vcard;
        }
        Log.debug("LdapVCardProvider: Merging avatar element from passed vcard");
        Element currentElement = vcard.element("PHOTO");
        if (currentElement != null) {
            vcard.remove(currentElement);
        }
        vcard.add(photoElement);
        return vcard;
    }

    private Element loadAvatarFromDatabase(String username) {
        Element vcardElement = this.defaultProvider.loadVCard(username);
        Element avatarElement = null;
        if (vcardElement != null && vcardElement.element("PHOTO") != null) {
            avatarElement = vcardElement.element("PHOTO").createCopy();
        }
        return avatarElement;
    }

    @Override
    public Element createVCard(String username, Element vCardElement) throws UnsupportedOperationException, AlreadyExistsException {
        throw new UnsupportedOperationException("LdapVCardProvider: VCard changes not allowed.");
    }

    @Override
    public Element updateVCard(String username, Element vCardElement) throws UnsupportedOperationException {
        if (this.dbStorageEnabled.booleanValue() && this.defaultProvider != null) {
            if (this.isValidVCardChange(username, vCardElement).booleanValue()) {
                Element mergedVCard = this.getMergedVCard(username, vCardElement);
                try {
                    this.defaultProvider.updateVCard(username, mergedVCard);
                }
                catch (NotFoundException e) {
                    try {
                        this.defaultProvider.createVCard(username, mergedVCard);
                    }
                    catch (AlreadyExistsException alreadyExistsException) {
                        // empty catch block
                    }
                }
                return mergedVCard;
            }
            throw new UnsupportedOperationException("LdapVCardProvider: Invalid vcard changes.");
        }
        throw new UnsupportedOperationException("LdapVCardProvider: VCard changes not allowed.");
    }

    @Override
    public void deleteVCard(String username) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("LdapVCardProvider: Attempted to delete vcard in read-only mode.");
    }

    private Boolean isValidVCardChange(String username, Element newvCard) {
        Element ldapBinvalElem;
        if (newvCard == null) {
            Log.debug("LdapVCardProvider: No new vcard provided (no changes), accepting.");
            return true;
        }
        Map<String, String> map = this.getLdapAttributes(username = JID.unescapeNode((String)username));
        Element ldapvCard = new VCard(this.template).getVCard(map);
        if (ldapvCard == null) {
            Log.debug("LdapVCardProvider: User has no LDAP vcard, nothing they can change, rejecting.");
            return false;
        }
        Element ldapPhotoElem = ldapvCard.element("PHOTO");
        if (ldapPhotoElem != null && (ldapBinvalElem = ldapPhotoElem.element("BINVAL")) != null && !ldapBinvalElem.getTextTrim().matches("\\s*")) {
            Log.debug("LdapVCardProvider: LDAP has a PHOTO element set, no way to override, rejecting.");
            return false;
        }
        Element dbvCard = this.defaultProvider.loadVCard(username);
        if (dbvCard != null) {
            Element dbPhotoElem = dbvCard.element("PHOTO");
            if (dbPhotoElem == null) {
                Log.debug("LdapVCardProvider: Database has no PHOTO element, accepting update.");
                return true;
            }
            Element newPhotoElem = newvCard.element("PHOTO");
            if (newPhotoElem == null) {
                Log.debug("LdapVCardProvider: Photo element was removed, accepting update.");
                return true;
            }
            if (!dbPhotoElem.asXML().equals(newPhotoElem.asXML())) {
                Log.debug("LdapVCardProvider: PHOTO element changed, accepting update.");
                return true;
            }
        } else {
            Log.debug("LdapVCardProvider: Database has no vCard stored, accepting update.");
            return true;
        }
        Log.debug("LdapVCardProvider: PHOTO element didn't change, no reason to accept this, rejecting.");
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.dbStorageEnabled == false;
    }

    public void propertySet(String property, Map params) {
        if ("ldap.override.avatar".equals(property)) {
            this.dbStorageEnabled = Boolean.parseBoolean((String)params.get("value"));
        } else if ("ldap.vcard-mapping".equals(property)) {
            this.initTemplate();
            VCardManager.getInstance().reset();
        }
    }

    public void propertyDeleted(String property, Map params) {
        if ("ldap.override.avatar".equals(property)) {
            this.dbStorageEnabled = false;
        }
    }

    public void xmlPropertySet(String property, Map params) {
    }

    public void xmlPropertyDeleted(String property, Map params) {
    }

    private static class VCard {
        private VCardTemplate template;

        public VCard(VCardTemplate template) {
            this.template = template;
        }

        public Element getVCard(Map<String, String> map) {
            Document document = (Document)this.template.getDocument().clone();
            Element element = document.getRootElement();
            return this.treeWalk(element, map);
        }

        private Element treeWalk(Element element, Map<String, String> map) {
            int size = element.nodeCount();
            for (int i = 0; i < size; ++i) {
                Node node = element.node(i);
                if (!(node instanceof Element)) continue;
                Element emement = (Element)node;
                String elementText = emement.getTextTrim();
                if (elementText != null && !"".equals(elementText)) {
                    String format = emement.getStringValue();
                    StringTokenizer st = new StringTokenizer(elementText, ", //{}");
                    while (st.hasMoreTokens()) {
                        String field = st.nextToken();
                        String attrib = field.replaceAll("(\\{)(" + field + ")(})", "$2");
                        String value = map.get(attrib);
                        format = format.replaceFirst("(\\{)(" + field + ")(})", Matcher.quoteReplacement(value));
                    }
                    emement.setText(format);
                }
                this.treeWalk(emement, map);
            }
            return element;
        }
    }

    private static class VCardTemplate {
        private Document document;
        private String[] attributes;

        public VCardTemplate(Document document) {
            HashSet<String> set = new HashSet<String>();
            this.document = document;
            this.treeWalk(this.document.getRootElement(), set);
            this.attributes = set.toArray(new String[set.size()]);
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public Document getDocument() {
            return this.document;
        }

        private void treeWalk(Element element, Set<String> set) {
            int size = element.nodeCount();
            for (int i = 0; i < size; ++i) {
                Node node = element.node(i);
                if (!(node instanceof Element)) continue;
                Element emement = (Element)node;
                StringTokenizer st = new StringTokenizer(emement.getTextTrim(), ", //{}");
                while (st.hasMoreTokens()) {
                    String string = st.nextToken().replaceAll("(\\{)([\\d\\D&&[^}]]+)(})", "$2");
                    Log.debug("VCardTemplate: found attribute " + string);
                    set.add(string);
                }
                this.treeWalk(emement, set);
            }
        }
    }
}

