/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jivesoftware.openfire.keystore.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenfireX509TrustManager
implements X509TrustManager {
    private static final Logger Log = LoggerFactory.getLogger(OpenfireX509TrustManager.class);
    private static final Provider PROVIDER = new BouncyCastleProvider();
    protected final boolean acceptSelfSigned;
    private final boolean checkValidity;
    protected final Set<X509Certificate> trustedIssuers;

    public OpenfireX509TrustManager(KeyStore trustStore, boolean acceptSelfSigned, boolean checkValidity) throws NoSuchAlgorithmException, KeyStoreException {
        this.acceptSelfSigned = acceptSelfSigned;
        this.checkValidity = checkValidity;
        HashSet<X509Certificate> trusted = new HashSet<X509Certificate>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate certificate;
            String alias = aliases.nextElement();
            if (!trustStore.isCertificateEntry(alias) || !((certificate = trustStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            trusted.add((X509Certificate)certificate);
        }
        this.trustedIssuers = Collections.unmodifiableSet(trusted);
        Log.debug("Constructed trust manager. Number of trusted issuers: {}, accepts self-signed: {}, checks validity: {}", new Object[]{this.trustedIssuers.size(), acceptSelfSigned, checkValidity});
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate endEntityCert = CertificateUtils.identifyEndEntityCertificate(Arrays.asList(chain));
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(endEntityCert);
        try {
            this.checkChainTrusted(selector, chain);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertPathBuilderException ex) {
            throw new CertificateException(ex);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate endEntityCert = CertificateUtils.identifyEndEntityCertificate(Arrays.asList(chain));
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(endEntityCert);
        try {
            this.checkChainTrusted(selector, chain);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertPathBuilderException ex) {
            throw new CertificateException(ex);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        Set<X509Certificate> result = this.checkValidity ? CertificateUtils.filterValid(this.trustedIssuers) : this.trustedIssuers;
        return result.toArray(new X509Certificate[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CertPath checkChainTrusted(CertSelector selector, X509Certificate ... chain) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertPathBuilderException {
        CertPathBuilder pathBuilder;
        if (selector == null) {
            throw new IllegalArgumentException("Argument 'selector' cannot be null");
        }
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Argument 'chain' cannot be null or an empty array.");
        }
        Log.debug("Attempting to verify a chain of {} certificates.", (Object)chain.length);
        HashSet<X509Certificate> trustedIssuers = new HashSet<X509Certificate>();
        trustedIssuers.addAll(this.trustedIssuers);
        if (this.acceptSelfSigned && chain.length == 1) {
            Log.debug("Attempting to accept the self-signed certificate of this chain of length one, as instructed by configuration.");
            X509Certificate cert = chain[0];
            if (cert.getSubjectDN().equals(cert.getIssuerDN())) {
                Log.debug("Chain of one appears to be self-signed. Adding it to the set of trusted issuers.");
                trustedIssuers.add(cert);
            } else {
                Log.debug("Chain of one is not self-signed. Not adding it to the set of trusted issuers.");
            }
        }
        Set<X509Certificate> acceptedIssuers = this.checkValidity ? CertificateUtils.filterValid(trustedIssuers) : trustedIssuers;
        Set<TrustAnchor> trustAnchors = CertificateUtils.toTrustAnchors(acceptedIssuers);
        CertStore certificates = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Arrays.asList(chain)));
        PKIXBuilderParameters parameters = new PKIXBuilderParameters(trustAnchors, selector);
        if (!this.checkValidity) {
            Log.debug("Attempting to ignore any validity (expiry) issues, as instructed by configuration.");
            Date validPointInTime = CertificateUtils.findValidPointInTime(chain);
            if (validPointInTime == null) {
                Log.warn("The existing implementation is unable to fully ignore certificate validity periods for this chain, even though it is configured to do so. Certificate checks might fail because of expiration for end entity: " + chain[0]);
            } else {
                parameters.setDate(validPointInTime);
            }
        }
        parameters.addCertStore(certificates);
        parameters.setRevocationEnabled(false);
        Log.debug("Validating chain with {} certificates, using {} trust anchors.", (Object)chain.length, (Object)trustAnchors.size());
        try {
            pathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
        }
        catch (NoSuchProviderException e) {
            Log.warn("Unable to use the BC provider! Trying to use a fallback provider.", (Throwable)e);
            pathBuilder = CertPathBuilder.getInstance("PKIX");
        }
        try {
            CertPathBuilderResult result = pathBuilder.build(parameters);
            return result.getCertPath();
        }
        catch (CertPathBuilderException ex) {
            try {
                Log.debug("** Accepted Issuers (trust anchors, \"root CA's\"):");
                for (X509Certificate acceptedIssuer : acceptedIssuers) {
                    Log.debug("   - " + acceptedIssuer.getSubjectDN() + "/" + acceptedIssuer.getIssuerDN());
                }
                Log.debug("** Chain to be validated:");
                Log.debug("   length: " + chain.length);
                for (int i = 0; i < chain.length; ++i) {
                    Log.debug(" Certificate[{}] (valid from {} to {}):", new Object[]{i, chain[i].getNotBefore(), chain[i].getNotAfter()});
                    Log.debug("   subjectDN: " + chain[i].getSubjectDN());
                    Log.debug("   issuerDN: " + chain[i].getIssuerDN());
                    for (X509Certificate acceptedIssuer : acceptedIssuers) {
                        if (!acceptedIssuer.getIssuerDN().equals(chain[i].getIssuerDN())) continue;
                        Log.debug("Found accepted issuer with same DN: " + acceptedIssuer.getIssuerDN());
                    }
                }
            }
            finally {
                throw ex;
            }
        }
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

