/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashCrossDomainServlet
extends HttpServlet {
    private static Logger Log = LoggerFactory.getLogger(FlashCrossDomainServlet.class);
    public static String CROSS_DOMAIN_TEXT = "<?xml version=\"1.0\"?>\n<!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\">\n<cross-domain-policy>\n\t<site-control permitted-cross-domain-policies=\"all\"/>\n\t<allow-access-from domain=\"*\" to-ports=\"";
    public static String CROSS_DOMAIN_MIDDLE_TEXT = "\" secure=\"";
    public static String CROSS_DOMAIN_END_TEXT = "\"/>\n</cross-domain-policy>";
    private static String CROSS_DOMAIN_SECURE_ENABLED = "httpbind.crossdomain.secure";
    private static boolean CROSS_DOMAIN_SECURE_DEFAULT = true;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml");
        response.getOutputStream().write(FlashCrossDomainServlet.getCrossDomainContent().getBytes());
    }

    public static String getCrossDomainContent() {
        String override = FlashCrossDomainServlet.getContent(FlashCrossDomainServlet.getOverride());
        if (override != null && override.trim().length() > 0) {
            return override;
        }
        return FlashCrossDomainServlet.generateOutput();
    }

    private static File getOverride() {
        StringBuilder sb = new StringBuilder();
        sb.append(JiveGlobals.getHomeDirectory());
        if (!sb.substring(sb.length() - 1).startsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("conf");
        sb.append(File.separator);
        return new File(sb.toString(), "crossdomain.xml");
    }

    private static String getContent(File file) {
        StringBuilder content = new StringBuilder();
        if (file.canRead()) {
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                String str;
                while ((str = in.readLine()) != null) {
                    content.append(str);
                    content.append('\n');
                }
            }
            catch (IOException ex) {
                Log.warn("Unexpected exception while trying to read file: " + file.getName(), (Throwable)ex);
                return null;
            }
        }
        return content.toString();
    }

    private static String generateOutput() {
        StringBuilder builder = new StringBuilder();
        builder.append(CROSS_DOMAIN_TEXT);
        FlashCrossDomainServlet.getPortList(builder);
        builder.append(CROSS_DOMAIN_MIDDLE_TEXT);
        FlashCrossDomainServlet.getSecure(builder);
        builder.append(CROSS_DOMAIN_END_TEXT);
        builder.append("\n");
        return builder.toString();
    }

    private static StringBuilder getPortList(StringBuilder builder) {
        boolean multiple = false;
        if (XMPPServer.getInstance().getConnectionManager().getClientListenerPort() > 0) {
            builder.append(XMPPServer.getInstance().getConnectionManager().getClientListenerPort());
            multiple = true;
        }
        if (XMPPServer.getInstance().getConnectionManager().getClientSSLListenerPort() > 0) {
            if (multiple) {
                builder.append(',');
            }
            builder.append(XMPPServer.getInstance().getConnectionManager().getClientSSLListenerPort());
            multiple = true;
        }
        if (HttpBindManager.getInstance().isHttpBindEnabled()) {
            if (HttpBindManager.getInstance().getHttpBindUnsecurePort() > 0) {
                if (multiple) {
                    builder.append(',');
                }
                builder.append(HttpBindManager.getInstance().getHttpBindUnsecurePort());
                multiple = true;
            }
            if (HttpBindManager.getInstance().isHttpsBindActive()) {
                if (multiple) {
                    builder.append(',');
                }
                builder.append(HttpBindManager.getInstance().getHttpBindSecurePort());
            }
        }
        return builder;
    }

    private static StringBuilder getSecure(StringBuilder builder) {
        if (JiveGlobals.getBooleanProperty(CROSS_DOMAIN_SECURE_ENABLED, CROSS_DOMAIN_SECURE_DEFAULT)) {
            builder.append("true");
        } else {
            builder.append("false");
        }
        return builder;
    }
}

