/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

public enum BoshBindingError {
    badRequest(Type.terminate, "bad-request", 400),
    hostGone(Type.terminate, "host-gone"),
    hostUnknown(Type.terminate, "host-unknown"),
    improperAddressing(Type.terminate, "improper-addressing"),
    internalServerError(Type.terminate, "internal-server-error"),
    itemNotFound(Type.terminate, "item-not-found", 404),
    otherRequest(Type.terminate, "other-request"),
    policyViolation(Type.terminate, "policy-violation", 403),
    remoteConnectionFailed(Type.terminate, "remote-connection-failed"),
    remoteStreamError(Type.terminate, "remote-stream-error"),
    seeOtherUri(Type.terminate, "see-other-uri"),
    systemShutdown(Type.terminate, "system-shutdown"),
    undefinedCondition(Type.terminate, "undefined-condition");

    private Type errorType;
    private String condition;
    private int legacyErrorCode = 400;

    private BoshBindingError(Type errorType, String condition, int legacyErrorCode) {
        this(errorType, condition);
        this.legacyErrorCode = legacyErrorCode;
    }

    private BoshBindingError(Type errorType, String condition) {
        this.errorType = errorType;
        this.condition = condition;
    }

    public Type getErrorType() {
        return this.errorType;
    }

    public String getCondition() {
        return this.condition;
    }

    public int getLegacyErrorCode() {
        return this.legacyErrorCode;
    }

    public static enum Type {
        terminate(null),
        recoverable("error");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            if (this.type == null) {
                return this.name();
            }
            return this.type;
        }
    }
}

