/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.ChannelHandler;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.PresenceEventDispatcher;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class PresenceSubscribeHandler
extends BasicModule
implements ChannelHandler<Presence> {
    private static final Logger Log = LoggerFactory.getLogger(PresenceSubscribeHandler.class);
    private RoutingTable routingTable;
    private XMPPServer localServer;
    private String serverName;
    private PacketDeliverer deliverer;
    private PresenceManager presenceManager;
    private RosterManager rosterManager;
    private UserManager userManager;
    private static Hashtable<RosterItem.SubType, Map<String, Map<Presence.Type, Change>>> stateTable = new Hashtable();

    public PresenceSubscribeHandler() {
        super("Presence subscription handler");
    }

    @Override
    public void process(Presence presence) throws PacketException {
        if (presence == null) {
            throw new IllegalArgumentException("Argument 'presence' cannot be null.");
        }
        Presence.Type type = presence.getType();
        if (type != Presence.Type.subscribe && type != Presence.Type.unsubscribe && type != Presence.Type.subscribed && type != Presence.Type.unsubscribed) {
            throw new IllegalArgumentException("Packet processed by PresenceSubscribeHandler is not of a subscription-related type, but: " + type);
        }
        presence.setFrom(presence.getFrom().toBareJID());
        if (presence.getTo() != null) {
            presence.setTo(presence.getTo().toBareJID());
        }
        JID senderJID = presence.getFrom();
        JID recipientJID = presence.getTo();
        try {
            if (recipientJID == null || recipientJID.toString().equals(this.serverName)) {
                if (type == Presence.Type.subscribe) {
                    Presence reply = new Presence();
                    reply.setTo(senderJID);
                    reply.setFrom(recipientJID);
                    reply.setType(Presence.Type.unsubscribed);
                    this.deliverer.deliver((Packet)reply);
                }
                return;
            }
            try {
                Roster senderRoster = this.getRoster(senderJID);
                if (senderRoster != null) {
                    this.manageSub(recipientJID, true, type, senderRoster);
                }
                Roster recipientRoster = this.getRoster(recipientJID);
                boolean recipientSubChanged = false;
                if (recipientRoster != null) {
                    recipientSubChanged = this.manageSub(senderJID, false, type, recipientRoster);
                }
                if (type != Presence.Type.subscribed || recipientRoster == null || recipientSubChanged) {
                    List<JID> jids;
                    if (type == Presence.Type.subscribe && recipientRoster != null && !recipientSubChanged) {
                        try {
                            RosterItem.SubType subType = recipientRoster.getRosterItem(senderJID).getSubStatus();
                            if (subType == RosterItem.SUB_FROM || subType == RosterItem.SUB_BOTH) {
                                return;
                            }
                        }
                        catch (UserNotFoundException e) {
                            Log.error("User does not exist while trying to update roster item. This should never happen (this indicates a programming logic error). Processing stanza: " + presence.toString(), (Throwable)e);
                        }
                    }
                    if (!(jids = this.routingTable.getRoutes(recipientJID, null)).isEmpty()) {
                        for (JID jid : jids) {
                            Presence presenteToSend = presence.createCopy();
                            presenteToSend.setFrom(senderJID.toBareJID());
                            this.routingTable.routePacket(jid, (Packet)presenteToSend, false);
                        }
                    } else {
                        this.deliverer.deliver((Packet)presence.createCopy());
                    }
                    if (type == Presence.Type.subscribed) {
                        JID prober;
                        JID jID = prober = this.localServer.isLocal(recipientJID) ? recipientJID.asBareJID() : recipientJID;
                        if (this.presenceManager.canProbePresence(prober, senderJID.getNode())) {
                            this.presenceManager.probePresence(prober, senderJID);
                            PresenceEventDispatcher.subscribedToPresence(recipientJID, senderJID);
                        } else {
                            Presence nonProbablePresence = new Presence();
                            nonProbablePresence.setStatus("unavailable");
                            nonProbablePresence.setFrom(senderJID);
                            nonProbablePresence.setTo(recipientJID);
                            this.presenceManager.handleProbe(nonProbablePresence);
                        }
                    }
                }
                if (type == Presence.Type.unsubscribed) {
                    this.presenceManager.sendUnavailableFromSessions(recipientJID, senderJID);
                    PresenceEventDispatcher.unsubscribedToPresence(senderJID, recipientJID);
                }
            }
            catch (SharedGroupException e) {
                Presence result = presence.createCopy();
                JID sender = result.getFrom();
                result.setFrom(presence.getTo());
                result.setTo(sender);
                result.setError(PacketError.Condition.not_acceptable);
                this.deliverer.deliver((Packet)result);
            }
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
    }

    private Roster getRoster(JID address) {
        Roster roster = null;
        if (this.localServer.isLocal(address) && this.userManager.isRegisteredUser(address.getNode())) {
            String username = address.getNode();
            try {
                roster = this.rosterManager.getRoster(username);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
        return roster;
    }

    private boolean manageSub(JID target, boolean isSending, Presence.Type type, Roster roster) throws UserAlreadyExistsException, SharedGroupException {
        RosterItem item = null;
        RosterItem.SubType oldSub = null;
        boolean newItem = false;
        try {
            if (roster.isRosterItem(target)) {
                item = roster.getRosterItem(target);
            } else {
                if (Presence.Type.unsubscribed == type || Presence.Type.unsubscribe == type || Presence.Type.subscribed == type) {
                    return false;
                }
                item = roster.createRosterItem(target, false, true);
                newItem = true;
            }
            RosterItem.AskType oldAsk = item.getAskStatus();
            oldSub = item.getSubStatus();
            RosterItem.RecvType oldRecv = item.getRecvStatus();
            PresenceSubscribeHandler.updateState(item, type, isSending);
            if (oldAsk != item.getAskStatus() || oldSub != item.getSubStatus() || oldRecv != item.getRecvStatus()) {
                roster.updateRosterItem(item);
            } else if (newItem && (item.getSubStatus() != RosterItem.SUB_NONE || item.getRecvStatus() != RosterItem.RECV_SUBSCRIBE)) {
                roster.broadcast(item, false);
            }
        }
        catch (UserNotFoundException e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        return oldSub != item.getSubStatus();
    }

    public static Change getStateChange(RosterItem.SubType itemSubType, Presence.Type action, boolean isSending) {
        Map<String, Map<Presence.Type, Change>> srTable = stateTable.get((Object)itemSubType);
        Map<Presence.Type, Change> changeTable = srTable.get(isSending ? "send" : "recv");
        return changeTable.get(action);
    }

    private static void updateState(RosterItem item, Presence.Type action, boolean isSending) {
        Change change = PresenceSubscribeHandler.getStateChange(item.getSubStatus(), action, isSending);
        if (change.getNewAsk() != null && change.getNewAsk() != item.getAskStatus()) {
            item.setAskStatus(change.getNewAsk());
        }
        if (change.getNewSub() != null && change.getNewSub() != item.getSubStatus()) {
            item.setSubStatus(change.getNewSub());
        }
        if (change.getNewRecv() != null && change.getNewRecv() != item.getRecvStatus()) {
            item.setRecvStatus(change.getNewRecv());
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.localServer = server;
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.routingTable = server.getRoutingTable();
        this.deliverer = server.getPacketDeliverer();
        this.presenceManager = server.getPresenceManager();
        this.rosterManager = server.getRosterManager();
        this.userManager = server.getUserManager();
    }

    static {
        Hashtable sr = new Hashtable();
        Hashtable<Presence.Type, Change> subrTable = new Hashtable<Presence.Type, Change>();
        Hashtable<Presence.Type, Change> subsTable = new Hashtable<Presence.Type, Change>();
        sr.put("recv", subrTable);
        sr.put("send", subsTable);
        stateTable.put(RosterItem.SUB_NONE, sr);
        subrTable.put(Presence.Type.subscribe, new Change(RosterItem.RECV_SUBSCRIBE, null, null));
        subrTable.put(Presence.Type.subscribed, new Change(null, RosterItem.SUB_TO, RosterItem.ASK_NONE));
        subrTable.put(Presence.Type.unsubscribe, new Change(null, null, null));
        subrTable.put(Presence.Type.unsubscribed, new Change(null, null, RosterItem.ASK_NONE));
        subsTable.put(Presence.Type.subscribe, new Change(null, null, RosterItem.ASK_SUBSCRIBE));
        subsTable.put(Presence.Type.subscribed, new Change(RosterItem.RECV_NONE, RosterItem.SUB_FROM, null));
        subsTable.put(Presence.Type.unsubscribe, new Change(null, null, null));
        subsTable.put(Presence.Type.unsubscribed, new Change(RosterItem.RECV_NONE, null, null));
        sr = new Hashtable();
        subrTable = new Hashtable();
        subsTable = new Hashtable();
        sr.put("recv", subrTable);
        sr.put("send", subsTable);
        stateTable.put(RosterItem.SUB_FROM, sr);
        subsTable.put(Presence.Type.subscribe, new Change(null, null, RosterItem.ASK_SUBSCRIBE));
        subsTable.put(Presence.Type.subscribed, new Change(RosterItem.RECV_NONE, null, null));
        subsTable.put(Presence.Type.unsubscribe, new Change(null, RosterItem.SUB_NONE, null));
        subsTable.put(Presence.Type.unsubscribed, new Change(RosterItem.RECV_NONE, RosterItem.SUB_NONE, null));
        subrTable.put(Presence.Type.subscribe, new Change(RosterItem.RECV_NONE, null, null));
        subrTable.put(Presence.Type.subscribed, new Change(null, RosterItem.SUB_BOTH, RosterItem.ASK_NONE));
        subrTable.put(Presence.Type.unsubscribe, new Change(RosterItem.RECV_UNSUBSCRIBE, RosterItem.SUB_NONE, null));
        subrTable.put(Presence.Type.unsubscribed, new Change(null, null, RosterItem.ASK_NONE));
        sr = new Hashtable();
        subrTable = new Hashtable();
        subsTable = new Hashtable();
        sr.put("recv", subrTable);
        sr.put("send", subsTable);
        stateTable.put(RosterItem.SUB_TO, sr);
        subsTable.put(Presence.Type.subscribe, new Change(null, null, RosterItem.ASK_NONE));
        subsTable.put(Presence.Type.subscribed, new Change(RosterItem.RECV_NONE, RosterItem.SUB_BOTH, null));
        subsTable.put(Presence.Type.unsubscribe, new Change(null, RosterItem.SUB_NONE, RosterItem.ASK_UNSUBSCRIBE));
        subsTable.put(Presence.Type.unsubscribed, new Change(RosterItem.RECV_NONE, null, null));
        subrTable.put(Presence.Type.subscribe, new Change(RosterItem.RECV_SUBSCRIBE, null, null));
        subrTable.put(Presence.Type.subscribed, new Change(null, null, RosterItem.ASK_NONE));
        subrTable.put(Presence.Type.unsubscribe, new Change(RosterItem.RECV_NONE, RosterItem.SUB_NONE, null));
        subrTable.put(Presence.Type.unsubscribed, new Change(null, RosterItem.SUB_NONE, RosterItem.ASK_NONE));
        sr = new Hashtable();
        subrTable = new Hashtable();
        subsTable = new Hashtable();
        sr.put("recv", subrTable);
        sr.put("send", subsTable);
        stateTable.put(RosterItem.SUB_BOTH, sr);
        subsTable.put(Presence.Type.subscribe, new Change(null, null, RosterItem.ASK_NONE));
        subsTable.put(Presence.Type.subscribed, new Change(RosterItem.RECV_NONE, null, null));
        subsTable.put(Presence.Type.unsubscribe, new Change(null, RosterItem.SUB_FROM, RosterItem.ASK_UNSUBSCRIBE));
        subsTable.put(Presence.Type.unsubscribed, new Change(RosterItem.RECV_NONE, RosterItem.SUB_TO, null));
        subrTable.put(Presence.Type.subscribe, new Change(RosterItem.RECV_NONE, null, null));
        subrTable.put(Presence.Type.subscribed, new Change(null, null, RosterItem.ASK_NONE));
        subrTable.put(Presence.Type.unsubscribe, new Change(RosterItem.RECV_UNSUBSCRIBE, RosterItem.SUB_TO, null));
        subrTable.put(Presence.Type.unsubscribed, new Change(RosterItem.RECV_NONE, RosterItem.SUB_FROM, RosterItem.ASK_NONE));
    }

    public static class Change {
        private RosterItem.RecvType newRecv;
        private RosterItem.SubType newSub;
        private RosterItem.AskType newAsk;

        public Change(RosterItem.RecvType recv, RosterItem.SubType sub, RosterItem.AskType ask) {
            this.newRecv = recv;
            this.newSub = sub;
            this.newAsk = ask;
        }

        public RosterItem.RecvType getNewRecv() {
            return this.newRecv;
        }

        public RosterItem.SubType getNewSub() {
            return this.newSub;
        }

        public RosterItem.AskType getNewAsk() {
            return this.newAsk;
        }
    }
}

