/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.vcard.VCardManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class IQvCardHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQvCardHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("vCard", "vcard-temp");
    private XMPPServer server;
    private UserManager userManager;

    public IQvCardHandler() {
        super("XMPP vCard Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException, PacketException {
        IQ result = IQ.createResultIQ((IQ)packet);
        IQ.Type type = packet.getType();
        if (type.equals((Object)IQ.Type.set)) {
            try {
                User user = this.userManager.getUser(packet.getFrom().getNode());
                Element vcard = packet.getChildElement();
                if (vcard != null) {
                    VCardManager.getInstance().setVCard(user.getUsername(), vcard);
                }
            }
            catch (UserNotFoundException e) {
                result = IQ.createResultIQ((IQ)packet);
                result.setChildElement(packet.getChildElement().createCopy());
                result.setError(PacketError.Condition.item_not_found);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
                result.setError(PacketError.Condition.internal_server_error);
            }
        } else if (type.equals((Object)IQ.Type.get)) {
            JID recipient = packet.getTo();
            if (recipient == null) {
                recipient = packet.getFrom();
            }
            result.setChildElement("vCard", "vcard-temp");
            if (recipient != null) {
                if (recipient.getNode() != null && this.server.isLocal(recipient)) {
                    VCardManager vManager = VCardManager.getInstance();
                    Element userVCard = vManager.getVCard(recipient.getNode());
                    if (userVCard != null) {
                        Element filter = packet.getChildElement().element(QName.get((String)"filter", (String)"vcard-temp-filter"));
                        if (filter != null) {
                            userVCard = userVCard.createCopy();
                            Iterator toFilter = filter.elementIterator();
                            while (toFilter.hasNext()) {
                                Element field = (Element)toFilter.next();
                                Element fieldToRemove = userVCard.element(field.getName());
                                if (fieldToRemove == null) continue;
                                fieldToRemove.detach();
                            }
                        }
                        result.setChildElement(userVCard);
                    }
                } else {
                    result = IQ.createResultIQ((IQ)packet);
                    result.setChildElement(packet.getChildElement().createCopy());
                    result.setError(PacketError.Condition.item_not_found);
                }
            } else {
                result = IQ.createResultIQ((IQ)packet);
                result.setChildElement(packet.getChildElement().createCopy());
                result.setError(PacketError.Condition.item_not_found);
            }
        } else {
            result.setChildElement(packet.getChildElement().createCopy());
            result.setError(PacketError.Condition.not_acceptable);
        }
        return result;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.server = server;
        this.userManager = server.getUserManager();
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

