/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Collections;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.admin.AdminConsole;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class IQVersionHandler
extends IQHandler
implements ServerFeaturesProvider {
    private static Element bodyElement;
    private IQHandlerInfo info = new IQHandlerInfo("query", "jabber:iq:version");

    public IQVersionHandler() {
        super("XMPP Server Version Handler");
        if (bodyElement == null) {
            bodyElement = DocumentHelper.createElement((QName)QName.get((String)"query", (String)"jabber:iq:version"));
            bodyElement.addElement("name").setText(AdminConsole.getAppName());
            bodyElement.addElement("version").setText(AdminConsole.getVersionString());
        }
    }

    @Override
    public IQ handleIQ(IQ packet) throws PacketException {
        if (IQ.Type.get == packet.getType()) {
            Element answerElement = bodyElement.createCopy();
            try {
                String os = System.getProperty("os.name") + ' ' + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ')';
                String java = "Java " + System.getProperty("java.version");
                answerElement.addElement("os").setText(os + " - " + java);
            }
            catch (SecurityException os) {
                // empty catch block
            }
            IQ result = IQ.createResultIQ((IQ)packet);
            result.setChildElement(answerElement);
            return result;
        }
        if (IQ.Type.set == packet.getType()) {
            IQ result = IQ.createResultIQ((IQ)packet);
            result.setError(PacketError.Condition.not_acceptable);
            return result;
        }
        return null;
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton("jabber:iq:version").iterator();
    }
}

