/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.AbstractGroupProvider;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class JDBCGroupProvider
extends AbstractGroupProvider {
    private static final Logger Log = LoggerFactory.getLogger(JDBCGroupProvider.class);
    private String connectionString;
    private String groupCountSQL;
    private String descriptionSQL;
    private String allGroupsSQL;
    private String userGroupsSQL;
    private String loadMembersSQL;
    private String loadAdminsSQL;
    private boolean useConnectionProvider;
    private XMPPServer server = XMPPServer.getInstance();

    public JDBCGroupProvider() {
        JiveGlobals.migrateProperty("jdbcProvider.driver");
        JiveGlobals.migrateProperty("jdbcProvider.connectionString");
        JiveGlobals.migrateProperty("jdbcGroupProvider.groupCountSQL");
        JiveGlobals.migrateProperty("jdbcGroupProvider.allGroupsSQL");
        JiveGlobals.migrateProperty("jdbcGroupProvider.userGroupsSQL");
        JiveGlobals.migrateProperty("jdbcGroupProvider.descriptionSQL");
        JiveGlobals.migrateProperty("jdbcGroupProvider.loadMembersSQL");
        JiveGlobals.migrateProperty("jdbcGroupProvider.loadAdminsSQL");
        this.useConnectionProvider = JiveGlobals.getBooleanProperty("jdbcGroupProvider.useConnectionProvider");
        if (!this.useConnectionProvider) {
            String jdbcDriver = JiveGlobals.getProperty("jdbcProvider.driver");
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                Log.error("Unable to load JDBC driver: " + jdbcDriver, (Throwable)e);
                return;
            }
            this.connectionString = JiveGlobals.getProperty("jdbcProvider.connectionString");
        }
        this.groupCountSQL = JiveGlobals.getProperty("jdbcGroupProvider.groupCountSQL");
        this.allGroupsSQL = JiveGlobals.getProperty("jdbcGroupProvider.allGroupsSQL");
        this.userGroupsSQL = JiveGlobals.getProperty("jdbcGroupProvider.userGroupsSQL");
        this.descriptionSQL = JiveGlobals.getProperty("jdbcGroupProvider.descriptionSQL");
        this.loadMembersSQL = JiveGlobals.getProperty("jdbcGroupProvider.loadMembersSQL");
        this.loadAdminsSQL = JiveGlobals.getProperty("jdbcGroupProvider.loadAdminsSQL");
    }

    private Connection getConnection() throws SQLException {
        if (this.useConnectionProvider) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group getGroup(String name) throws GroupNotFoundException {
        String description = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.descriptionSQL);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new GroupNotFoundException("Group with name " + name + " not found.");
            }
            description = rs.getString(1);
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        Collection<JID> members = this.getMembers(name, false);
        Collection<JID> administrators = this.getMembers(name, true);
        return new Group(name, description, members, administrators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Collection<JID> getMembers(String groupName, boolean adminsOnly) {
        block6: {
            members = new ArrayList<JID>();
            con = null;
            pstmt = null;
            rs = null;
            con = this.getConnection();
            if (!adminsOnly) ** GOTO lbl16
            if (this.loadAdminsSQL != null) break block6;
            var7_7 = members;
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return var7_7;
        }
        try {
            block8: {
                pstmt = con.prepareStatement(this.loadAdminsSQL);
                break block8;
lbl16:
                // 1 sources

                pstmt = con.prepareStatement(this.loadMembersSQL);
            }
            pstmt.setString(1, groupName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                user = rs.getString(1);
                if (user == null) continue;
                userJID = user.contains("@") != false ? new JID(user) : this.server.createJID(user, null);
                members.add(userJID);
            }
        }
        catch (SQLException e) {
            try {
                JDBCGroupProvider.Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable var9_11) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw var9_11;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGroupCount() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        int count;
        block4: {
            count = 0;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = this.getConnection();
                pstmt = con.prepareStatement(this.groupCountSQL);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.allGroupsSQL);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getGroupNames(int start, int num) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = DbConnectionManager.createScrollablePreparedStatement(con, this.allGroupsSQL);
            rs = pstmt.executeQuery();
            DbConnectionManager.scrollResultSet(rs, start);
            for (int count = 0; rs.next() && count < num; ++count) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getGroupNames(JID user) {
        ArrayList<String> groupNames = new ArrayList<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement(this.userGroupsSQL);
            pstmt.setString(1, this.server.isLocal(user) ? user.getNode() : user.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return groupNames;
    }
}

