/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.event.GroupEventListener;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.group.DefaultGroupProvider;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupCollection;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.group.GroupProvider;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class GroupManager {
    private static final Logger Log = LoggerFactory.getLogger(GroupManager.class);
    private static final String GROUP_COUNT_KEY = "GROUP_COUNT";
    private static final String SHARED_GROUPS_KEY = "SHARED_GROUPS";
    private static final String GROUP_NAMES_KEY = "GROUP_NAMES";
    private static final String PUBLIC_GROUPS = "PUBLIC_GROUPS";
    private Cache<String, Group> groupCache = CacheFactory.createCache("Group");
    private Cache<String, Object> groupMetaCache = CacheFactory.createCache("Group Metadata Cache");
    private GroupProvider provider;

    public static GroupManager getInstance() {
        return GroupManagerContainer.instance;
    }

    private GroupManager() {
        this.initProvider();
        GroupEventDispatcher.addListener(new GroupEventListener(){

            @Override
            public void groupCreated(Group group, Map params) {
                if (group.getProperties().get("sharedRoster.showInRoster") == null) {
                    group.getProperties().put("sharedRoster.showInRoster", "nobody");
                    group.getProperties().put("sharedRoster.displayName", "");
                    group.getProperties().put("sharedRoster.groupList", "");
                }
                GroupManager.this.groupCache.put(group.getName(), group);
                GroupManager.this.groupMetaCache.remove(GroupManager.GROUP_COUNT_KEY);
                GroupManager.this.groupMetaCache.remove(GroupManager.GROUP_NAMES_KEY);
                GroupManager.this.groupMetaCache.remove(GroupManager.SHARED_GROUPS_KEY);
                GroupManager.this.evictCachedUsersForGroup(group);
                GroupManager.this.evictCachedPaginatedGroupNames();
            }

            @Override
            public void groupDeleting(Group group, Map params) {
                GroupManager.this.groupCache.remove(group.getName());
                GroupManager.this.groupMetaCache.remove(GroupManager.GROUP_COUNT_KEY);
                GroupManager.this.groupMetaCache.remove(GroupManager.GROUP_NAMES_KEY);
                GroupManager.this.groupMetaCache.remove(GroupManager.SHARED_GROUPS_KEY);
                GroupManager.this.evictCachedUsersForGroup(group);
                GroupManager.this.evictCachedPaginatedGroupNames();
            }

            @Override
            public void groupModified(Group group, Map params) {
                String type = (String)params.get("type");
                if (type != null) {
                    Object key;
                    if ((type.equals("propertyModified") || type.equals("propertyDeleted") || type.equals("propertyAdded")) && (key = params.get("propertyKey")) instanceof String && (key.equals("sharedRoster.showInRoster") || key.equals("*"))) {
                        GroupManager.this.groupMetaCache.remove(GroupManager.GROUP_NAMES_KEY);
                        GroupManager.this.groupMetaCache.remove(GroupManager.SHARED_GROUPS_KEY);
                    }
                    if (type.equals("nameModified")) {
                        String originalName = (String)params.get("originalValue");
                        if (originalName != null) {
                            GroupManager.this.groupCache.remove(originalName);
                        }
                        GroupManager.this.groupMetaCache.remove(GroupManager.GROUP_NAMES_KEY);
                        GroupManager.this.groupMetaCache.remove(GroupManager.SHARED_GROUPS_KEY);
                        GroupManager.this.evictCachedUsersForGroup(group);
                        GroupManager.this.evictCachedPaginatedGroupNames();
                    }
                }
                GroupManager.this.groupCache.put(group.getName(), group);
            }

            @Override
            public void memberAdded(Group group, Map params) {
                GroupManager.this.groupCache.put(group.getName(), group);
                String member = (String)params.get("member");
                if (member != null) {
                    GroupManager.this.groupMetaCache.remove(member);
                }
            }

            @Override
            public void memberRemoved(Group group, Map params) {
                GroupManager.this.groupCache.put(group.getName(), group);
                String member = (String)params.get("member");
                if (member != null) {
                    GroupManager.this.groupMetaCache.remove(member);
                }
            }

            @Override
            public void adminAdded(Group group, Map params) {
                GroupManager.this.groupCache.put(group.getName(), group);
                String member = (String)params.get("admin");
                if (member != null) {
                    GroupManager.this.groupMetaCache.remove(member);
                }
            }

            @Override
            public void adminRemoved(Group group, Map params) {
                GroupManager.this.groupCache.put(group.getName(), group);
                String member = (String)params.get("admin");
                if (member != null) {
                    GroupManager.this.groupMetaCache.remove(member);
                }
            }
        });
        UserEventDispatcher.addListener(new UserEventListener(){

            @Override
            public void userCreated(User user, Map<String, Object> params) {
            }

            @Override
            public void userDeleting(User user, Map<String, Object> params) {
                GroupManager.this.deleteUser(user);
            }

            @Override
            public void userModified(User user, Map<String, Object> params) {
            }
        });
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("provider.group.className".equals(property)) {
                    GroupManager.this.initProvider();
                }
            }

            public void propertyDeleted(String property, Map params) {
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }

    private void initProvider() {
        JiveGlobals.migrateProperty("provider.group.className");
        String className = JiveGlobals.getProperty("provider.group.className", "org.jivesoftware.openfire.group.DefaultGroupProvider");
        try {
            Class c = ClassUtils.forName(className);
            this.provider = (GroupProvider)c.newInstance();
        }
        catch (Exception e) {
            Log.error("Error loading group provider: " + className, (Throwable)e);
            this.provider = new DefaultGroupProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group createGroup(String name) throws GroupAlreadyExistsException {
        String string = name.intern();
        synchronized (string) {
            try {
                this.getGroup(name);
                throw new GroupAlreadyExistsException();
            }
            catch (GroupNotFoundException unfe) {
                Group newGroup = this.provider.createGroup(name);
                this.groupCache.put(name, newGroup);
                GroupEventDispatcher.dispatchEvent(newGroup, GroupEventDispatcher.EventType.group_created, Collections.emptyMap());
                return newGroup;
            }
        }
    }

    public Group getGroup(JID jid) throws GroupNotFoundException {
        JID groupJID = GroupJID.fromJID(jid);
        return groupJID instanceof GroupJID ? this.getGroup(((GroupJID)groupJID).getGroupName()) : null;
    }

    public Group getGroup(String name) throws GroupNotFoundException {
        return this.getGroup(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String name, boolean forceLookup) throws GroupNotFoundException {
        Group group = null;
        if (forceLookup) {
            this.groupCache.remove(name);
        } else {
            group = (Group)this.groupCache.get(name);
        }
        if (group == null) {
            String string = name.intern();
            synchronized (string) {
                group = (Group)this.groupCache.get(name);
                if (group == null) {
                    group = this.provider.getGroup(name);
                    this.groupCache.put(name, group);
                }
            }
        }
        return group;
    }

    public void deleteGroup(Group group) {
        GroupEventDispatcher.dispatchEvent(group, GroupEventDispatcher.EventType.group_deleting, Collections.emptyMap());
        this.provider.deleteGroup(group.getName());
        this.groupCache.remove(group.getName());
    }

    public void deleteUser(User user) {
        JID userJID = XMPPServer.getInstance().createJID(user.getUsername(), null);
        for (Group group : this.getGroups(userJID)) {
            if (group.getAdmins().contains(userJID)) {
                if (!group.getAdmins().remove(userJID)) continue;
                this.groupCache.remove(group.getName());
                continue;
            }
            if (!group.getMembers().remove(userJID)) continue;
            this.groupCache.remove(group.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupCount() {
        Integer count = (Integer)this.groupMetaCache.get(GROUP_COUNT_KEY);
        if (count == null) {
            String string = GROUP_COUNT_KEY.intern();
            synchronized (string) {
                count = (Integer)this.groupMetaCache.get(GROUP_COUNT_KEY);
                if (count == null) {
                    count = this.provider.getGroupCount();
                    this.groupMetaCache.put(GROUP_COUNT_KEY, count);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getGroups() {
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(GROUP_NAMES_KEY);
        if (groupNames == null) {
            String string = GROUP_NAMES_KEY.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(GROUP_NAMES_KEY);
                if (groupNames == null) {
                    groupNames = this.provider.getGroupNames();
                    this.groupMetaCache.put(GROUP_NAMES_KEY, groupNames);
                }
            }
        }
        return new GroupCollection(groupNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getSharedGroups() {
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(SHARED_GROUPS_KEY);
        if (groupNames == null) {
            String string = SHARED_GROUPS_KEY.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(SHARED_GROUPS_KEY);
                if (groupNames == null) {
                    groupNames = this.provider.getSharedGroupNames();
                    this.groupMetaCache.put(SHARED_GROUPS_KEY, groupNames);
                }
            }
        }
        return new GroupCollection(groupNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getSharedGroups(String userName) {
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(userName);
        if (groupNames == null) {
            String string = userName.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(userName);
                if (groupNames == null) {
                    groupNames = this.provider.getSharedGroupNames(new JID(userName, XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null));
                    this.groupMetaCache.put(userName, groupNames);
                }
            }
        }
        return new GroupCollection(groupNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getVisibleGroups(Group groupToCheck) {
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(PUBLIC_GROUPS);
        if (groupNames == null) {
            String string = PUBLIC_GROUPS.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(PUBLIC_GROUPS);
                if (groupNames == null) {
                    groupNames = this.provider.getPublicSharedGroupNames();
                    this.groupMetaCache.put(PUBLIC_GROUPS, groupNames);
                }
            }
        }
        groupNames.addAll(this.provider.getVisibleGroupNames(groupToCheck.getName()));
        return new GroupCollection(groupNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getPublicSharedGroups() {
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(PUBLIC_GROUPS);
        if (groupNames == null) {
            String string = PUBLIC_GROUPS.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(PUBLIC_GROUPS);
                if (groupNames == null) {
                    groupNames = this.provider.getPublicSharedGroupNames();
                    this.groupMetaCache.put(PUBLIC_GROUPS, groupNames);
                }
            }
        }
        return new GroupCollection(groupNames);
    }

    public Collection<Group> search(String propName, String propValue) {
        Collection<String> groupsWithProps = this.provider.search(propName, propValue);
        return new GroupCollection(groupsWithProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getGroups(int startIndex, int numResults) {
        String key = GROUP_NAMES_KEY + startIndex + "," + numResults;
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(key);
        if (groupNames == null) {
            String string = key.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(key);
                if (groupNames == null) {
                    groupNames = this.provider.getGroupNames(startIndex, numResults);
                    this.groupMetaCache.put(key, groupNames);
                }
            }
        }
        return new GroupCollection(groupNames);
    }

    public Collection<Group> getGroups(User user) {
        return this.getGroups(XMPPServer.getInstance().createJID(user.getUsername(), null, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getGroups(JID user) {
        String key = user.toBareJID();
        Collection<String> groupNames = (Collection<String>)this.groupMetaCache.get(key);
        if (groupNames == null) {
            String string = key.intern();
            synchronized (string) {
                groupNames = (Collection)this.groupMetaCache.get(key);
                if (groupNames == null) {
                    groupNames = this.provider.getGroupNames(user);
                    this.groupMetaCache.put(key, groupNames);
                }
            }
        }
        return new GroupCollection(groupNames);
    }

    public boolean isReadOnly() {
        return this.provider.isReadOnly();
    }

    public boolean isSearchSupported() {
        return this.provider.isSearchSupported();
    }

    public Collection<Group> search(String query) {
        Collection<String> groupNames = this.provider.search(query);
        return new GroupCollection(groupNames);
    }

    public Collection<Group> search(String query, int startIndex, int numResults) {
        Collection<String> groupNames = this.provider.search(query, startIndex, numResults);
        return new GroupCollection(groupNames);
    }

    public GroupProvider getProvider() {
        return this.provider;
    }

    private void evictCachedUsersForGroup(Group group) {
        for (JID user : group.getAdmins()) {
            this.groupMetaCache.remove(user.getNode());
        }
        for (JID user : group.getMembers()) {
            this.groupMetaCache.remove(user.getNode());
        }
        String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
        if (showInRoster != null) {
            switch (showInRoster.toLowerCase()) {
                case "everybody": {
                    this.groupMetaCache.clear();
                    break;
                }
                case "spefgroups": {
                    String groupList = (String)group.getProperties().get("sharedRoster.groupList");
                    if (groupList == null) break;
                    StringTokenizer tokenizer = new StringTokenizer(groupList, ",\t\n\r\f");
                    while (tokenizer.hasMoreTokens()) {
                        String spefgroup = tokenizer.nextToken().trim();
                        try {
                            Group nested = this.getGroup(spefgroup);
                            this.evictCachedUsersForGroup(nested);
                        }
                        catch (GroupNotFoundException e) {
                            Log.debug("While evicting cached users for group '{}', an unrecognized spefgroup was found: '{}'", new Object[]{group.getName(), spefgroup, e});
                        }
                    }
                    break;
                }
            }
        }
    }

    private void evictCachedPaginatedGroupNames() {
        for (Map.Entry entry : this.groupMetaCache.entrySet()) {
            if (!((String)entry.getKey()).startsWith(GROUP_NAMES_KEY)) continue;
            this.groupMetaCache.remove(entry.getKey());
        }
    }

    private static final class GroupManagerContainer {
        private static final GroupManager instance = new GroupManager();

        private GroupManagerContainer() {
        }
    }
}

