/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.filetransfer.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyOutputStream;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyTransfer;
import org.jivesoftware.util.cache.CacheSizes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyTransfer
implements ProxyTransfer {
    private static final Logger Log = LoggerFactory.getLogger(DefaultProxyTransfer.class);
    private String initiator;
    private InputStream inputStream;
    private OutputStream outputStream;
    private String target;
    private String transferDigest;
    private String streamID;
    private Future<?> future;
    private long amountWritten;
    private static final int BUFFER_SIZE = 8000;

    @Override
    public String getInitiator() {
        return this.initiator;
    }

    @Override
    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream initiatorInputStream) {
        this.inputStream = initiatorInputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public String getTransferDigest() {
        return this.transferDigest;
    }

    @Override
    public void setTransferDigest(String transferDigest) {
        this.transferDigest = transferDigest;
    }

    @Override
    public String getSessionID() {
        return this.streamID;
    }

    @Override
    public void setSessionID(String streamID) {
        this.streamID = streamID;
    }

    @Override
    public boolean isActivatable() {
        return this.inputStream != null && this.outputStream != null;
    }

    @Override
    public synchronized void setTransferFuture(Future<?> future) {
        if (this.future != null) {
            throw new IllegalStateException("Transfer is already in progress, or has completed.");
        }
        this.future = future;
    }

    @Override
    public long getAmountTransferred() {
        return this.amountWritten;
    }

    @Override
    public void doTransfer() throws IOException {
        if (!this.isActivatable()) {
            throw new IOException("Transfer missing party");
        }
        try (InputStream in = this.getInputStream();
             ProxyOutputStream out = new ProxyOutputStream(this.getOutputStream());){
            byte[] b = new byte[8000];
            int count = 0;
            this.amountWritten = 0L;
            do {
                ((OutputStream)out).write(b, 0, count);
                this.amountWritten += (long)count;
            } while ((count = in.read(b)) >= 0);
        }
    }

    @Override
    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfString(this.initiator);
        size += CacheSizes.sizeOfString(this.target);
        size += CacheSizes.sizeOfString(this.transferDigest);
        size += CacheSizes.sizeOfString(this.streamID);
        size += CacheSizes.sizeOfLong();
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfObject();
        return size += CacheSizes.sizeOfObject();
    }
}

