/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserEventDispatcher {
    private static final Logger Log = LoggerFactory.getLogger(UserEventDispatcher.class);
    private static List<UserEventListener> listeners = new CopyOnWriteArrayList<UserEventListener>();

    private UserEventDispatcher() {
    }

    public static void addListener(UserEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(UserEventListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(User user, EventType eventType, Map<String, Object> params) {
        for (UserEventListener listener : listeners) {
            try {
                switch (eventType) {
                    case user_created: {
                        listener.userCreated(user, params);
                        break;
                    }
                    case user_deleting: {
                        listener.userDeleting(user, params);
                        break;
                    }
                    case user_modified: {
                        listener.userModified(user, params);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum EventType {
        user_created,
        user_deleting,
        user_modified;

    }
}

