/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.container.CacheInfo;
import org.jivesoftware.openfire.container.PluginCacheRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCacheConfigurator {
    private static final Logger Log = LoggerFactory.getLogger(PluginCacheConfigurator.class);
    private InputStream configDataStream;

    public void setInputStream(InputStream configDataStream) {
        this.configDataStream = configDataStream;
    }

    public void configure(String pluginName) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEncoding("UTF-8");
            Document cacheXml = saxReader.read(this.configDataStream);
            List mappings = cacheXml.selectNodes("/cache-config/cache-mapping");
            for (Node mapping : mappings) {
                this.registerCache(pluginName, mapping);
            }
        }
        catch (DocumentException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void registerCache(String pluginName, Node configData) {
        String cacheName = configData.selectSingleNode("cache-name").getStringValue();
        String schemeName = configData.selectSingleNode("scheme-name").getStringValue();
        if (cacheName == null || schemeName == null) {
            throw new IllegalArgumentException("Both cache-name and scheme-name elements are required. Found cache-name: " + cacheName + " and scheme-name: " + schemeName);
        }
        Map<String, String> initParams = this.readInitParams(configData);
        CacheInfo info = new CacheInfo(cacheName, CacheInfo.Type.valueof(schemeName), initParams);
        PluginCacheRegistry.getInstance().registerCache(pluginName, info);
    }

    private Map<String, String> readInitParams(Node configData) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        List params = configData.selectNodes("init-params/init-param");
        for (Node param : params) {
            String paramName = param.selectSingleNode("param-name").getStringValue();
            String paramValue = param.selectSingleNode("param-value").getStringValue();
            paramMap.put(paramName, paramValue);
        }
        return paramMap;
    }
}

