/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class GroupModified
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/event#group-modified";
    }

    @Override
    public String getDefaultLabel() {
        return "Group modified";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData sessionData, Element command) {
        String type;
        String groupname;
        Element note = command.addElement("note");
        Map<String, List<String>> data = sessionData.getData();
        try {
            groupname = this.get(data, "groupName", 0);
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("Group name required parameter.");
            return;
        }
        try {
            type = this.get(data, "changeType", 0);
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("Change type required parameter.");
            return;
        }
        String valueVariable = null;
        String valueVariableName = null;
        if ("nameModified".equals(type) || "descriptionModified".equals(type)) {
            valueVariable = "originalValue";
            valueVariableName = "Original value";
        } else if ("propertyModified".equals(type) || "propertyAdded".equals(type) || "propertyDeleted".equals(type)) {
            valueVariable = "propertyKey";
            valueVariableName = "Property key";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (valueVariable != null) {
            try {
                String value = this.get(data, valueVariable, 0);
                params.put(valueVariable, value);
            }
            catch (NullPointerException npe) {
                note.addAttribute("type", "error");
                note.setText(valueVariableName + " required parameter.");
                return;
            }
        }
        params.put("type", type);
        try {
            Group group = GroupManager.getInstance().getGroup(groupname, true);
            GroupEventDispatcher.dispatchEvent(group, GroupEventDispatcher.EventType.group_modified, params);
        }
        catch (GroupNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("Group not found.");
        }
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Dispatching a group created event.");
        form.addInstruction("Fill out this form to dispatch a group created event.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("The group name of the group that was created");
        field.setVariable("groupName");
        field.setRequired(true);
        field.setType(FormField.Type.list_single);
        field.setLabel("Change type");
        field.setVariable("changeType");
        field.addOption("Name modified", "nameModified");
        field.addOption("Description modified", "descriptionModified");
        field.addOption("Property modified", "propertyModified");
        field.addOption("Property added", "propertyAdded");
        field.addOption("Property deleted", "propertyDeleted");
        field.addOption("Other", "other");
        field.setRequired(true);
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Original value");
        field.setVariable("originalValue");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Name of the property");
        field.setVariable("propertyKey");
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

