/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.interceptor.PacketCopier;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class PacketsNotification
extends AdHocCommand {
    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Receiving notification of packets activity");
        form.addInstruction("Fill out this form to configure packets to receive.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.list_multi);
        field.setLabel("Type of packet");
        field.setVariable("packet_type");
        field.addOption("Presence", "presence");
        field.addOption("IQ", "iq");
        field.addOption("Message", "message");
        field.setRequired(true);
        field = form.addField();
        field.setType(FormField.Type.list_single);
        field.setLabel("Direction");
        field.setVariable("direction");
        field.addOption("Incoming", "incoming");
        field.addOption("Outgoing", "outgoing");
        field.setRequired(true);
        field = form.addField();
        field.setType(FormField.Type.list_single);
        field.setLabel("Processing time");
        field.setVariable("processed");
        field.addOption("Before processing", "false");
        field.addOption("After processing", "true");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    public void execute(SessionData data, Element command) {
        boolean presenceEnabled = false;
        boolean messageEnabled = false;
        boolean iqEnabled = false;
        for (String packet_type : data.getData().get("packet_type")) {
            if ("presence".equals(packet_type)) {
                presenceEnabled = true;
                continue;
            }
            if ("iq".equals(packet_type)) {
                iqEnabled = true;
                continue;
            }
            if (!"message".equals(packet_type)) continue;
            messageEnabled = true;
        }
        boolean incoming = "incoming".equals(data.getData().get("direction").get(0));
        boolean processed = "true".equals(data.getData().get("processed").get(0));
        JID componentJID = data.getOwner();
        PacketCopier.getInstance().addSubscriber(componentJID, iqEnabled, messageEnabled, presenceEnabled, incoming, processed);
        Element note = command.addElement("note");
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#packets_notification";
    }

    @Override
    public String getDefaultLabel() {
        return "Get notifications of packet activity";
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return InternalComponentManager.getInstance().hasComponent(requester);
    }
}

