/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.container.AdminConsolePlugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class GetAdminConsoleInfo
extends AdHocCommand {
    @Override
    protected void addStageInformation(SessionData data, Element command) {
    }

    @Override
    public void execute(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        AdminConsolePlugin adminConsolePlugin = (AdminConsolePlugin)pluginManager.getPlugin("admin");
        String bindInterface = adminConsolePlugin.getBindInterface();
        int adminPort = adminConsolePlugin.getAdminUnsecurePort();
        int adminSecurePort = adminConsolePlugin.getAdminSecurePort();
        if (bindInterface == null) {
            Enumeration<NetworkInterface> nets = null;
            try {
                nets = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException e) {
                return;
            }
            for (NetworkInterface netInterface : Collections.list(nets)) {
                boolean found = false;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                for (InetAddress address : Collections.list(addresses)) {
                    if ("127.0.0.1".equals(address.getHostAddress()) || "0:0:0:0:0:0:0:1".equals(address.getHostAddress())) continue;
                    Socket socket = new Socket();
                    InetSocketAddress remoteAddress = new InetSocketAddress(address, adminPort > 0 ? adminPort : adminSecurePort);
                    try {
                        socket.connect(remoteAddress);
                        bindInterface = address.getHostAddress();
                        found = true;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
                if (!found) continue;
                break;
            }
        }
        if (bindInterface == null) {
            Element note = command.addElement("note");
            note.addAttribute("type", "error");
            note.setText("Couldn't find a valid interface.");
            return;
        }
        field = form.addField();
        field.setLabel("Bind interface");
        field.setVariable("bindInterface");
        field.addValue((Object)bindInterface);
        field = form.addField();
        field.setLabel("Port");
        field.setVariable("adminPort");
        field.addValue((Object)adminPort);
        field = form.addField();
        field.setLabel("Secure port");
        field.setVariable("adminSecurePort");
        field.addValue((Object)adminSecurePort);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return null;
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#get-console-info";
    }

    @Override
    public String getDefaultLabel() {
        return "Get admin console info.";
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return null;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 0;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

