/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.cluster;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterNodeInfo;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.JiveProperties;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager {
    private static final Logger Log = LoggerFactory.getLogger(ClusterManager.class);
    public static String CLUSTER_PROPERTY_NAME = "clustering.enabled";
    private static Queue<ClusterEventListener> listeners = new ConcurrentLinkedQueue<ClusterEventListener>();
    private static BlockingQueue<Event> events = new LinkedBlockingQueue<Event>(10000);
    private static Thread dispatcher;

    private static void initEventDispatcher() {
        if (dispatcher == null || !dispatcher.isAlive()) {
            dispatcher = new Thread("ClusterManager events dispatcher"){

                @Override
                public void run() {
                    while (ClusterManager.isClusteringEnabled()) {
                        try {
                            Event event = (Event)events.take();
                            EventType eventType = event.getType();
                            if (event.getNodeID() == null) {
                                if (eventType == EventType.joined_cluster) {
                                    CacheFactory.joinedCluster();
                                } else if (eventType == EventType.left_cluster) {
                                    CacheFactory.leftCluster();
                                }
                            }
                            for (ClusterEventListener listener : listeners) {
                                try {
                                    switch (eventType) {
                                        case joined_cluster: {
                                            if (event.getNodeID() == null) {
                                                listener.joinedCluster();
                                                break;
                                            }
                                            listener.joinedCluster(event.getNodeID());
                                            break;
                                        }
                                        case left_cluster: {
                                            if (event.getNodeID() == null) {
                                                listener.leftCluster();
                                                break;
                                            }
                                            listener.leftCluster(event.getNodeID());
                                            break;
                                        }
                                        case marked_senior_cluster_member: {
                                            listener.markedAsSeniorClusterMember();
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                            event.setProcessed(true);
                        }
                        catch (Exception e) {
                            Log.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            dispatcher.setDaemon(true);
            dispatcher.start();
        }
    }

    public static void addListener(ClusterEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(ClusterEventListener listener) {
        listeners.remove(listener);
    }

    public static void fireJoinedCluster(boolean asynchronous) {
        try {
            Event event = new Event(EventType.joined_cluster, null);
            events.put(event);
            if (!asynchronous) {
                while (!event.isProcessed()) {
                    Thread.sleep(50L);
                }
            }
        }
        catch (InterruptedException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void fireJoinedCluster(byte[] nodeID, boolean asynchronous) {
        try {
            Event event = new Event(EventType.joined_cluster, nodeID);
            events.put(event);
            if (!asynchronous) {
                while (!event.isProcessed()) {
                    Thread.sleep(50L);
                }
            }
        }
        catch (InterruptedException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void fireLeftCluster() {
        try {
            Event event = new Event(EventType.left_cluster, null);
            events.put(event);
        }
        catch (InterruptedException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void fireLeftCluster(byte[] nodeID) {
        try {
            Event event = new Event(EventType.left_cluster, nodeID);
            events.put(event);
        }
        catch (InterruptedException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void fireMarkedAsSeniorClusterMember() {
        try {
            events.put(new Event(EventType.marked_senior_cluster_member, null));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static synchronized void startup() {
        if (ClusterManager.isClusteringEnabled() && !ClusterManager.isClusteringStarted()) {
            ClusterManager.initEventDispatcher();
            CacheFactory.startClustering();
        }
    }

    public static synchronized void shutdown() {
        if (ClusterManager.isClusteringStarted()) {
            Log.debug("ClusterManager: Shutting down clustered cache service.");
            CacheFactory.stopClustering();
        }
    }

    public static void setClusteringEnabled(boolean enabled) {
        if (enabled ? ClusterManager.isClusteringEnabled() && ClusterManager.isClusteringStarted() : !ClusterManager.isClusteringEnabled()) {
            return;
        }
        JiveGlobals.setXMLProperty(CLUSTER_PROPERTY_NAME, Boolean.toString(enabled));
    }

    public static boolean isClusteringEnabled() {
        return JiveGlobals.getXMLProperty(CLUSTER_PROPERTY_NAME, false);
    }

    public static boolean isClusteringAvailable() {
        return CacheFactory.isClusteringAvailable();
    }

    public static boolean isClusteringStarting() {
        return CacheFactory.isClusteringStarting();
    }

    public static boolean isClusteringStarted() {
        return CacheFactory.isClusteringStarted();
    }

    public static boolean isSeniorClusterMember() {
        return CacheFactory.isSeniorClusterMember();
    }

    public static Collection<ClusterNodeInfo> getNodesInfo() {
        return CacheFactory.getClusterNodesInfo();
    }

    public static int getMaxClusterNodes() {
        return CacheFactory.getMaxClusterNodes();
    }

    public static NodeID getSeniorClusterMember() {
        byte[] clusterMemberID = CacheFactory.getSeniorClusterMemberID();
        if (clusterMemberID == null) {
            return XMPPServer.getInstance().getNodeID();
        }
        return NodeID.getInstance(clusterMemberID);
    }

    public static boolean isClusterMember(byte[] nodeID) {
        for (ClusterNodeInfo nodeInfo : ClusterManager.getNodesInfo()) {
            if (!nodeInfo.getNodeID().equals(nodeID)) continue;
            return true;
        }
        return false;
    }

    static {
        PropertyEventDispatcher.addListener(new PropertyEventListener(){

            @Override
            public void propertySet(String property, Map<String, Object> params) {
            }

            @Override
            public void propertyDeleted(String property, Map<String, Object> params) {
            }

            @Override
            public void xmlPropertyDeleted(String property, Map<String, Object> params) {
            }

            @Override
            public void xmlPropertySet(String property, Map<String, Object> params) {
                if (CLUSTER_PROPERTY_NAME.equals(property)) {
                    if (Boolean.parseBoolean((String)params.get("value"))) {
                        JiveProperties.getInstance().init();
                        ClusterManager.startup();
                    } else {
                        ClusterManager.shutdown();
                    }
                }
            }
        });
    }

    private static enum EventType {
        joined_cluster,
        left_cluster,
        marked_senior_cluster_member;

    }

    private static class Event {
        private EventType type;
        private byte[] nodeID;
        private boolean processed;

        public Event(EventType type, byte[] oldNodeID) {
            this.type = type;
            this.nodeID = oldNodeID;
        }

        public EventType getType() {
            return this.type;
        }

        public byte[] getNodeID() {
            return this.nodeID;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public String toString() {
            return super.toString() + " type: " + (Object)((Object)this.type);
        }
    }
}

