/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridAuthProvider
implements AuthProvider {
    private static final Logger Log = LoggerFactory.getLogger(HybridAuthProvider.class);
    private AuthProvider primaryProvider;
    private AuthProvider secondaryProvider;
    private AuthProvider tertiaryProvider;
    private Set<String> primaryOverrides = new HashSet<String>();
    private Set<String> secondaryOverrides = new HashSet<String>();
    private Set<String> tertiaryOverrides = new HashSet<String>();

    public HybridAuthProvider() {
        String tertiaryClass;
        JiveGlobals.migrateProperty("hybridAuthProvider.primaryProvider.className");
        JiveGlobals.migrateProperty("hybridAuthProvider.secondaryProvider.className");
        JiveGlobals.migrateProperty("hybridAuthProvider.tertiaryProvider.className");
        JiveGlobals.migrateProperty("hybridAuthProvider.primaryProvider.overrideList");
        JiveGlobals.migrateProperty("hybridAuthProvider.secondaryProvider.overrideList");
        JiveGlobals.migrateProperty("hybridAuthProvider.tertiaryProvider.overrideList");
        String primaryClass = JiveGlobals.getProperty("hybridAuthProvider.primaryProvider.className");
        if (primaryClass == null) {
            Log.error("A primary AuthProvider must be specified. Authentication will be disabled.");
            return;
        }
        try {
            Class c = ClassUtils.forName(primaryClass);
            this.primaryProvider = (AuthProvider)c.newInstance();
            Log.debug("Primary auth provider: " + primaryClass);
        }
        catch (Exception e) {
            Log.error("Unable to load primary auth provider: " + primaryClass + ". Authentication will be disabled.", (Throwable)e);
            return;
        }
        String secondaryClass = JiveGlobals.getProperty("hybridAuthProvider.secondaryProvider.className");
        if (secondaryClass != null) {
            try {
                Class c = ClassUtils.forName(secondaryClass);
                this.secondaryProvider = (AuthProvider)c.newInstance();
                Log.debug("Secondary auth provider: " + secondaryClass);
            }
            catch (Exception e) {
                Log.error("Unable to load secondary auth provider: " + secondaryClass, (Throwable)e);
            }
        }
        if ((tertiaryClass = JiveGlobals.getProperty("hybridAuthProvider.tertiaryProvider.className")) != null) {
            try {
                Class c = ClassUtils.forName(tertiaryClass);
                this.tertiaryProvider = (AuthProvider)c.newInstance();
                Log.debug("Tertiary auth provider: " + tertiaryClass);
            }
            catch (Exception e) {
                Log.error("Unable to load tertiary auth provider: " + tertiaryClass, (Throwable)e);
            }
        }
        String overrideList = JiveGlobals.getProperty("hybridAuthProvider.primaryProvider.overrideList", "");
        for (String user : overrideList.split(",")) {
            this.primaryOverrides.add(user.trim().toLowerCase());
        }
        if (this.secondaryProvider != null) {
            overrideList = JiveGlobals.getProperty("hybridAuthProvider.secondaryProvider.overrideList", "");
            for (String user : overrideList.split(",")) {
                this.secondaryOverrides.add(user.trim().toLowerCase());
            }
        }
        if (this.tertiaryProvider != null) {
            overrideList = JiveGlobals.getProperty("hybridAuthProvider.tertiaryProvider.overrideList", "");
            for (String user : overrideList.split(",")) {
                this.tertiaryOverrides.add(user.trim().toLowerCase());
            }
        }
    }

    @Override
    public void authenticate(String username, String password) throws UnauthorizedException, ConnectionException, InternalUnauthenticatedException {
        block9: {
            if (this.primaryOverrides.contains(username.toLowerCase())) {
                this.primaryProvider.authenticate(username, password);
                return;
            }
            if (this.secondaryOverrides.contains(username.toLowerCase())) {
                this.secondaryProvider.authenticate(username, password);
                return;
            }
            if (this.tertiaryOverrides.contains(username.toLowerCase())) {
                this.tertiaryProvider.authenticate(username, password);
                return;
            }
            try {
                this.primaryProvider.authenticate(username, password);
            }
            catch (UnauthorizedException ue) {
                if (this.secondaryProvider != null) {
                    try {
                        this.secondaryProvider.authenticate(username, password);
                    }
                    catch (UnauthorizedException ue2) {
                        if (this.tertiaryProvider != null) {
                            this.tertiaryProvider.authenticate(username, password);
                            break block9;
                        }
                        throw ue2;
                    }
                }
                throw ue;
            }
        }
    }

    @Override
    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        return false;
    }

    @Override
    public boolean isScramSupported() {
        return false;
    }

    @Override
    public String getSalt(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIterations(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServerKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStoredKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    boolean isProvider(Class<? extends AuthProvider> clazz) {
        return this.primaryProvider != null && clazz.isAssignableFrom(this.primaryProvider.getClass()) || this.secondaryProvider != null && clazz.isAssignableFrom(this.secondaryProvider.getClass()) || this.tertiaryProvider != null && clazz.isAssignableFrom(this.tertiaryProvider.getClass());
    }
}

