/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.admin.AdminProvider;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class DefaultAdminProvider
implements AdminProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultAdminProvider.class);

    public DefaultAdminProvider() {
        Log.debug("DefaultAdminProvider: Convert XML to provider.");
        this.convertXMLToProvider();
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("admin.authorizedJIDs".equals(property)) {
                    AdminManager.getInstance().refreshAdminAccounts();
                }
            }

            public void propertyDeleted(String property, Map params) {
                if ("admin.authorizedJIDs".equals(property)) {
                    AdminManager.getInstance().refreshAdminAccounts();
                }
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }

    @Override
    public List<JID> getAdmins() {
        ArrayList<JID> adminList = new ArrayList<JID>();
        String jids = JiveGlobals.getProperty("admin.authorizedJIDs");
        jids = jids == null || jids.trim().length() == 0 ? "" : jids;
        StringTokenizer tokenizer = new StringTokenizer(jids, ",");
        while (tokenizer.hasMoreTokens()) {
            String jid = tokenizer.nextToken().toLowerCase().trim();
            try {
                adminList.add(new JID(jid));
            }
            catch (IllegalArgumentException e) {
                Log.warn("Invalid JID found in admin.authorizedJIDs system property: " + jid, (Throwable)e);
            }
        }
        if (adminList.isEmpty()) {
            adminList.add(new JID("admin", XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null, true));
        }
        return adminList;
    }

    @Override
    public void setAdmins(List<JID> admins) {
        ArrayList<String> adminList = new ArrayList<String>();
        for (JID admin : admins) {
            adminList.add(admin.toBareJID());
        }
        JiveGlobals.setProperty("admin.authorizedJIDs", StringUtils.collectionToString(adminList));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private void convertXMLToProvider() {
        if (JiveGlobals.getXMLProperty("admin.authorizedJIDs") == null && JiveGlobals.getXMLProperty("admin.authorizedUsernames") == null && JiveGlobals.getXMLProperty("adminConsole.authorizedUsernames") == null) {
            return;
        }
        ArrayList<JID> adminList = new ArrayList<JID>();
        String jids = JiveGlobals.getXMLProperty("admin.authorizedJIDs");
        jids = jids == null || jids.trim().length() == 0 ? "" : jids;
        StringTokenizer tokenizer = new StringTokenizer(jids, ",");
        while (tokenizer.hasMoreTokens()) {
            String jid = tokenizer.nextToken().toLowerCase().trim();
            try {
                adminList.add(new JID(jid));
            }
            catch (IllegalArgumentException e) {
                Log.warn("Invalid JID found in authorizedJIDs at openfire.xml: " + jid, (Throwable)e);
            }
        }
        String usernames = JiveGlobals.getXMLProperty("admin.authorizedUsernames");
        if (usernames == null) {
            usernames = JiveGlobals.getXMLProperty("adminConsole.authorizedUsernames");
        }
        usernames = usernames == null || usernames.trim().length() == 0 ? (adminList.size() == 0 ? "admin" : "") : usernames;
        tokenizer = new StringTokenizer(usernames, ",");
        while (tokenizer.hasMoreTokens()) {
            String username = tokenizer.nextToken();
            try {
                adminList.add(XMPPServer.getInstance().createJID(username.toLowerCase().trim(), null));
            }
            catch (IllegalArgumentException e) {
                Log.warn("Invalid username found in authorizedUsernames at openfire.xml: " + username, (Throwable)e);
            }
        }
        this.setAdmins(adminList);
        JiveGlobals.deleteXMLProperty("admin.authorizedJIDs");
        JiveGlobals.deleteXMLProperty("admin.authorizedUsernames");
        JiveGlobals.deleteXMLProperty("adminConsole.authorizedUsernames");
    }
}

