/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.mina.util.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginFilter
implements Filter {
    private static final Logger Log = LoggerFactory.getLogger(PluginFilter.class);
    @Deprecated
    private static List<SimpleFilter> pluginFilters = new CopyOnWriteArrayList<SimpleFilter>();
    private static Map<String, List<Filter>> filters = new CopyOnWriteMap();

    @Deprecated
    public static void addPluginFilter(SimpleFilter filter) {
        pluginFilters.add(filter);
    }

    public static void addPluginFilter(String filterUrl, Filter filter) {
        List<Filter> urlFilters;
        if (filterUrl == null || filterUrl.isEmpty() || filter == null) {
            throw new IllegalArgumentException();
        }
        if (!filters.containsKey(filterUrl)) {
            filters.put(filterUrl, new ArrayList());
        }
        if ((urlFilters = filters.get(filterUrl)).contains(filter)) {
            Log.warn("Cannot add filter '{}' as it was already added for URL '{}'!", (Object)filter, (Object)filterUrl);
        } else {
            urlFilters.add(filter);
            Log.debug("Added filter '{}' for URL '{}'", (Object)filter, (Object)filterUrl);
        }
    }

    @Deprecated
    public static void removePluginFilter(SimpleFilter filter) {
        pluginFilters.remove(filter);
    }

    public static Filter removePluginFilter(String filterUrl, String filterClassName) {
        if (filterUrl == null || filterUrl.isEmpty() || filterClassName == null || filterClassName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Filter result = null;
        if (filters.containsKey(filterUrl)) {
            List<Filter> urlFilters = filters.get(filterUrl);
            Iterator<Filter> iterator = urlFilters.iterator();
            while (iterator.hasNext()) {
                Filter filter = iterator.next();
                if (!filter.getClass().getName().equals(filterClassName)) continue;
                iterator.remove();
                result = filter;
            }
            if (urlFilters.isEmpty()) {
                filters.remove(filterUrl);
            }
        }
        if (result == null) {
            Log.warn("Unable to removed filter of class '{}' for URL '{}'. No such filter is present.", (Object)filterClassName, (Object)filterUrl);
        } else {
            Log.debug("Removed filter '{}' for URL '{}'", result, (Object)filterUrl);
        }
        return result;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean continueChain = true;
        for (SimpleFilter filter : pluginFilters) {
            Log.trace("(deprecated) Executing wrapped simple filter '{}'...", (Object)filter);
            if (filter.doFilter(servletRequest, servletResponse)) continue;
            Log.debug("The simple filter returned false so no further filters in the chain should be run.");
            continueChain = false;
            break;
        }
        if (continueChain) {
            if (servletRequest instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                String requestPath = (httpServletRequest.getContextPath() + httpServletRequest.getServletPath() + httpServletRequest.getPathInfo()).toLowerCase();
                ArrayList<Filter> applicableFilters = new ArrayList<Filter>();
                for (Map.Entry<String, List<Filter>> entry : filters.entrySet()) {
                    String filterUrl = entry.getKey();
                    if (filterUrl.endsWith("*")) {
                        filterUrl = filterUrl.substring(0, filterUrl.length() - 1);
                    }
                    if (!requestPath.startsWith(filterUrl = filterUrl.toLowerCase())) continue;
                    for (Filter filter : entry.getValue()) {
                        applicableFilters.add(filter);
                    }
                }
                if (!applicableFilters.isEmpty()) {
                    Log.debug("Wrapping filter chain in order to run plugin-specific filters.");
                    filterChain = new FilterChainInjector(filterChain, applicableFilters);
                }
            } else {
                Log.warn("ServletRequest is not an instance of an HttpServletRequest.");
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        pluginFilters.clear();
        filters.clear();
    }

    private static class FilterChainInjector
    implements FilterChain {
        private static final Logger Log = LoggerFactory.getLogger(FilterChainInjector.class);
        private final FilterChain parentChain;
        private final List<Filter> filters;
        private int index = 0;

        private FilterChainInjector(FilterChain parentChain, List<Filter> filters) {
            if (parentChain == null || filters == null) {
                throw new IllegalArgumentException();
            }
            this.parentChain = parentChain;
            this.filters = filters;
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            if (this.index < this.filters.size()) {
                Log.trace("Executing injected filter {} of {}...", (Object)(this.index + 1), (Object)this.filters.size());
                this.filters.get(this.index++).doFilter(servletRequest, servletResponse, (FilterChain)this);
            } else {
                Log.trace("Executed all injected filters. Resuming original chain.");
                this.parentChain.doFilter(servletRequest, servletResponse);
            }
        }
    }

    @Deprecated
    public static interface SimpleFilter {
        public boolean doFilter(ServletRequest var1, ServletResponse var2) throws IOException, ServletException;
    }
}

