/*
 * Decompiled with CFR 0.152.
 */
package org.icepear.echarts;

import java.util.ArrayList;
import java.util.List;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Option;
import org.icepear.echarts.components.coord.parallel.CategoryParallelAxis;
import org.icepear.echarts.components.coord.parallel.LogParallelAxis;
import org.icepear.echarts.components.coord.parallel.TimeParallelAxis;
import org.icepear.echarts.components.coord.parallel.ValueParallelAxis;
import org.icepear.echarts.origin.coord.parallel.ParallelAxisOption;
import org.icepear.echarts.origin.util.SeriesOption;

public abstract class ParallelCoordChart<T extends Chart<?, ?>, E extends SeriesOption>
extends Chart<T, E> {
    protected List<ParallelAxisOption> parallelAxes = new ArrayList<ParallelAxisOption>();

    public ParallelCoordChart(Class<T> clazz, Class<E> seriesClazz) {
        super(clazz, seriesClazz);
    }

    @Override
    public Option getOption() {
        return super.getOption().setParallelAxis(this.parallelAxes.toArray(new ParallelAxisOption[0]));
    }

    public T addParallelAxis(Number dim) {
        this.parallelAxes.add(new ValueParallelAxis().setDim(dim));
        return (T)this.self;
    }

    public T addParallelAxis(String name, Number dim) {
        this.parallelAxes.add(new ValueParallelAxis().setName(name).setDim(dim));
        return (T)this.self;
    }

    public T addParallelAxis(Number dim, String[] data) {
        this.parallelAxes.add(this.createCategoryParallelAxis().setDim(dim).setData(data));
        return (T)this.self;
    }

    public T addParallelAxis(String name, Number dim, String[] data) {
        this.parallelAxes.add(this.createCategoryParallelAxis().setName(name).setDim(dim).setData(data));
        return (T)this.self;
    }

    public T addParallelAxis(ParallelAxisOption parallelAxis) {
        this.parallelAxes.add(parallelAxis);
        return (T)this.self;
    }

    protected CategoryParallelAxis createCategoryParallelAxis() {
        return new CategoryParallelAxis().setType("category");
    }

    protected ValueParallelAxis createValueParallelAxis() {
        return new ValueParallelAxis().setType("value");
    }

    protected LogParallelAxis createLogParallelAxis() {
        return new LogParallelAxis().setType("log");
    }

    protected TimeParallelAxis createTimeParallelAxis() {
        return new TimeParallelAxis().setType("time");
    }
}

