/*
 * Decompiled with CFR 0.152.
 */
package org.icepear.echarts;

import java.util.ArrayList;
import java.util.List;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Option;
import org.icepear.echarts.components.coord.cartesian.CategoryAxis;
import org.icepear.echarts.components.coord.cartesian.LogAxis;
import org.icepear.echarts.components.coord.cartesian.TimeAxis;
import org.icepear.echarts.components.coord.cartesian.ValueAxis;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;

public abstract class CartesianCoordChart<T extends Chart<?, ?>, E extends SeriesOption>
extends Chart<T, E> {
    protected List<AxisOption> xAxes = new ArrayList<AxisOption>();
    protected List<AxisOption> yAxes = new ArrayList<AxisOption>();

    public CartesianCoordChart(Class<T> clazz, Class<E> seriesClazz) {
        super(clazz, seriesClazz);
    }

    @Override
    public Option getOption() {
        return super.getOption().setXAxis(this.xAxes.toArray(new AxisOption[0])).setYAxis(this.yAxes.toArray(new AxisOption[0]));
    }

    public T addXAxis() {
        this.xAxes.add(this.createValueAxis());
        return (T)this.self;
    }

    public T addXAxis(String name) {
        this.xAxes.add(this.createValueAxis().setName(name));
        return (T)this.self;
    }

    public T addXAxis(String[] data) {
        this.xAxes.add(this.createCategoryAxis().setData(data));
        return (T)this.self;
    }

    public T addXAxis(String name, String[] data) {
        this.xAxes.add(this.createCategoryAxis().setName(name).setData(data));
        return (T)this.self;
    }

    public T addXAxis(AxisOption xAxis) {
        this.xAxes.add(xAxis);
        return (T)this.self;
    }

    public T addYAxis() {
        this.yAxes.add(this.createValueAxis());
        return (T)this.self;
    }

    public T addYAxis(String name) {
        this.yAxes.add(this.createValueAxis().setName(name));
        return (T)this.self;
    }

    public T addYAxis(String[] data) {
        this.yAxes.add(this.createCategoryAxis().setData(data));
        return (T)this.self;
    }

    public T addYAxis(String name, String[] data) {
        this.yAxes.add(this.createCategoryAxis().setName(name).setData(data));
        return (T)this.self;
    }

    public T addYAxis(AxisOption yAxis) {
        this.yAxes.add(yAxis);
        return (T)this.self;
    }

    protected CategoryAxis createCategoryAxis() {
        return new CategoryAxis().setType("category");
    }

    protected ValueAxis createValueAxis() {
        return new ValueAxis().setType("value");
    }

    protected LogAxis createLogAxis() {
        return new LogAxis().setType("log");
    }

    protected TimeAxis createTimeAxis() {
        return new TimeAxis().setType("time");
    }
}

