/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

public class SeamUtilities {
    private static Logger log = Logger.getLogger("com.icesoft.faces.compat");
    private static Class seamManagerClass;
    private static Class[] seamClassArgs;
    private static Object[] seamInstanceArgs;
    private static Class[] seamGetEncodeMethodArgs;
    private static Object[] seamEncodeMethodArgs;
    private static Class[] seamGetSwitchConversationStackMethodArgs;
    private static Object[] seamSwitchConversationStackMethodArgs;
    private static Object[] seamMethodNoArgs;
    private static Method seamConversationIdMethodInstance;
    private static Method seamLongRunningMethodInstance;
    private static Method seamAppendConversationMethodInstance;
    private static Method seamInstanceMethod;
    private static Method seamSwitchCurrentConversationIdInstanceMethod;
    private static Method seamConversationIdParameterMethod;
    private static String conversationIdParameter;
    private static String conversationParentParameter;
    private static String seamVersion;
    private static String flowIdParameterName;
    private static String SPRING_CLASS_NAME;
    private static String SPRING_CONTEXT_HOLDER;
    private static String SPRING_REQUEST_CONTEXT;
    private static String SPRING_FLOW_EXECUTION_CONTEXT;
    private static Class mRequestContextHolderClass;
    private static Method mGetRequestContext;
    private static Method mGetFlowExecutionContext;
    private static Method mGetKey;
    private static int springLoaded;
    private static ClassLoader seamDebugPhaseListenerClassLoader;

    public static boolean isSeamEnvironment() {
        return seamManagerClass != null;
    }

    public static boolean requiresSeamExpressionFactory() {
        return seamVersion.startsWith("1.2.1");
    }

    public static void switchToCurrentSeamConversation(String uri) {
        if (conversationIdParameter == null) {
            SeamUtilities.getConversationIdParameterName();
        }
        String reqCid = SeamUtilities.stripCidFromRequest(uri);
        String ceId = SeamUtilities.getSeamConversationId();
        if (!reqCid.equals("") && !reqCid.equals(ceId)) {
            try {
                int convId = Integer.parseInt(reqCid);
                Object seamManagerInstance = seamInstanceMethod.invoke(null, seamInstanceArgs);
                if (seamSwitchCurrentConversationIdInstanceMethod != null) {
                    SeamUtilities.seamSwitchConversationStackMethodArgs[0] = reqCid;
                }
                Boolean updated = (Boolean)seamSwitchCurrentConversationIdInstanceMethod.invoke(seamManagerInstance, seamSwitchConversationStackMethodArgs);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("updated conversation from cid: " + ceId + ", to: " + reqCid + "  successful=" + updated);
                }
            }
            catch (Exception e) {
                seamInstanceMethod = null;
                seamManagerClass = null;
                log.log(Level.SEVERE, "Exception updating Seam's conversation Stack: ", e);
            }
        }
    }

    public static String encodeSeamConversationId(String uri, String viewId) {
        String token;
        if (!SeamUtilities.isSeamEnvironment()) {
            return uri;
        }
        String cleanedUrl = uri;
        if (conversationIdParameter == null) {
            SeamUtilities.getConversationIdParameterName();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "SeamConversationURLParam: " + conversationIdParameter);
        }
        StringTokenizer st = new StringTokenizer(uri, "?&");
        StringBuffer builder = new StringBuffer();
        ArrayList<String> tokenList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.indexOf(conversationIdParameter) != -1 || token.indexOf(conversationParentParameter) != -1 || token.indexOf("rvn") != -1) continue;
            tokenList.add(token);
        }
        for (int pdx = 0; pdx < tokenList.size(); ++pdx) {
            token = (String)tokenList.get(pdx);
            builder.append(token);
            if (pdx == 0 && tokenList.size() > 1) {
                builder.append('?');
                continue;
            }
            if (pdx <= 0 || pdx >= tokenList.size() - 1) continue;
            builder.append('&');
        }
        if (builder.length() > 0) {
            cleanedUrl = builder.toString();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Cleaned URI: " + builder);
            }
        }
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamInstanceArgs);
            if (seamAppendConversationMethodInstance != null) {
                SeamUtilities.seamEncodeMethodArgs[0] = cleanedUrl;
                if (seamEncodeMethodArgs.length == 2) {
                    SeamUtilities.seamEncodeMethodArgs[1] = viewId;
                }
                cleanedUrl = (String)seamAppendConversationMethodInstance.invoke(seamManagerInstance, seamEncodeMethodArgs);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Enabled redirect from: " + uri + ", to: " + cleanedUrl);
                }
            }
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.log(Level.INFO, "Exception encoding seam conversationId: ", e);
        }
        return cleanedUrl;
    }

    private static String stripCidFromRequest(String uri) {
        String returnVal = "";
        if (conversationIdParameter == null) {
            SeamUtilities.getConversationIdParameterName();
        }
        int index = uri.indexOf(conversationIdParameter);
        int length = conversationIdParameter.length() + 1;
        if (index > 0) {
            String substring = uri.substring(index);
            returnVal = uri.substring(index + length);
            int end = returnVal.indexOf(38);
            returnVal = end > 0 ? returnVal.substring(0, end) : uri.substring(index + length);
        }
        return returnVal;
    }

    public static String getSeamConversationId() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return null;
        }
        String returnVal = null;
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamMethodNoArgs);
            if (seamConversationIdMethodInstance != null) {
                String conversationId = (String)seamConversationIdMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                Boolean is = (Boolean)seamLongRunningMethodInstance.invoke(seamManagerInstance, seamMethodNoArgs);
                if (is.booleanValue()) {
                    returnVal = conversationId;
                }
            }
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.log(Level.INFO, "Exception determining Seam ConversationId: ", e);
        }
        return returnVal;
    }

    private static void loadSeamEnvironment() {
        try {
            seamManagerClass = Class.forName("org.jboss.seam.core.Manager");
            seamInstanceMethod = seamManagerClass.getMethod("instance", seamClassArgs);
            Class<?> seamELResolver = null;
            try {
                seamELResolver = Class.forName("org.jboss.seam.jsf.SeamELResolver");
                if (seamELResolver != null) {
                    seamVersion = "1.2.1.GA";
                }
            }
            catch (Exception e) {
                seamVersion = "not1.2.1.GA";
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("\t ->>> Using seamVersion=" + seamVersion);
            }
            try {
                seamAppendConversationMethodInstance = seamManagerClass.getMethod("encodeConversationId", seamGetEncodeMethodArgs);
                seamSwitchCurrentConversationIdInstanceMethod = seamManagerClass.getMethod("switchConversation", seamGetSwitchConversationStackMethodArgs);
            }
            catch (NoSuchMethodException e) {
                seamGetEncodeMethodArgs = new Class[]{String.class};
                seamEncodeMethodArgs = new Object[1];
                seamAppendConversationMethodInstance = seamManagerClass.getMethod("encodeConversationId", seamGetEncodeMethodArgs);
            }
            seamConversationIdMethodInstance = seamManagerClass.getMethod("getCurrentConversationId", seamClassArgs);
            seamLongRunningMethodInstance = seamManagerClass.getMethod("isLongRunningConversation", seamClassArgs);
            seamConversationIdParameterMethod = seamManagerClass.getMethod("getConversationIdParameter", seamClassArgs);
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (Exception e) {
            seamInstanceMethod = null;
            seamManagerClass = null;
            log.log(Level.INFO, "Exception loading seam environment: ", e);
        }
        if (seamManagerClass != null) {
            log.info("Seam environment detected ");
        }
    }

    public static String getConversationIdParameterName() {
        if (!SeamUtilities.isSeamEnvironment()) {
            return null;
        }
        if (conversationIdParameter != null) {
            return conversationIdParameter;
        }
        String returnVal = null;
        try {
            Object seamManagerInstance = seamInstanceMethod.invoke(null, seamMethodNoArgs);
            if (seamConversationIdParameterMethod != null) {
                conversationIdParameter = returnVal = (String)seamConversationIdParameterMethod.invoke(seamManagerInstance, seamMethodNoArgs);
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "Exception fetching conversationId Parameter name: ", e);
        }
        return returnVal;
    }

    public static void removeSeamDebugPhaseListener(Lifecycle lifecycle) {
        PhaseListener[] phaseListeners = lifecycle.getPhaseListeners();
        for (int i = 0; i < phaseListeners.length; ++i) {
            if (!phaseListeners[i].getClass().getName().equals("org.jboss.seam.debug.jsf.SeamDebugPhaseListener")) continue;
            lifecycle.removePhaseListener(phaseListeners[i]);
            seamDebugPhaseListenerClassLoader = phaseListeners[i].getClass().getClassLoader();
        }
    }

    public static ClassLoader getSeamDebugPhaseListenerClassLoader() {
        return seamDebugPhaseListenerClassLoader;
    }

    private static void loadSpringEnvironment() {
        Class<?> springClass;
        block9: {
            block8: {
                springClass = null;
                try {
                    springClass = Class.forName(SPRING_CLASS_NAME);
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.fine("Spring webflow 1.x not detected: " + t);
                }
            }
            if (null != springClass) {
                springLoaded = 1;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Spring webflow detected: " + springClass);
                }
            }
            springClass = null;
            try {
                springClass = Class.forName(SPRING_CONTEXT_HOLDER);
            }
            catch (Throwable t) {
                if (!log.isLoggable(Level.FINE)) break block9;
                log.fine("Spring webflow 2.x not detected: " + t);
            }
        }
        if (null != springClass) {
            springLoaded = 2;
            mRequestContextHolderClass = springClass;
            SeamUtilities.findWebflowMethods();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Spring webflow detected: " + springClass);
            }
        }
    }

    public static boolean isSpringEnvironment() {
        return springLoaded > 0;
    }

    public static boolean isSpring1Environment() {
        return springLoaded == 1;
    }

    public static boolean isSpring2Environment() {
        return springLoaded == 2;
    }

    public static String getSpringFlowId() {
        if (!SeamUtilities.isSpringEnvironment()) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object value = null;
        if (1 == springLoaded) {
            value = facesContext.getApplication().createValueBinding("#{flowExecutionKey}").getValue(facesContext);
            if (null != value) {
                flowIdParameterName = "_flowExecutionKey";
            }
        } else if (2 == springLoaded) {
            value = SeamUtilities.fetchSpringWebflow2KeyByIntrospection();
        }
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public static String getFlowIdParameterName() {
        return flowIdParameterName;
    }

    private static String fetchSpringWebflow2KeyByIntrospection() {
        try {
            Object requestHolderInstance = mGetRequestContext.invoke((Object)mRequestContextHolderClass, new Object[0]);
            log.fine("Retrieved requestContextHolder instance ");
            Object flowExecutionContextInstance = mGetFlowExecutionContext.invoke(requestHolderInstance, new Object[0]);
            log.fine("Retrieved flowExecutionContext instance");
            Object keyInstance = mGetKey.invoke(flowExecutionContextInstance, new Object[0]);
            log.fine("Retrieved FlowExecutionKey instance -- Success! " + keyInstance.toString());
            return keyInstance.toString();
        }
        catch (Exception e) {
            log.severe("Exception fetching webflow 2 key by introspection: " + e);
            return null;
        }
    }

    private static void findWebflowMethods() {
        log.fine("Constructing FlowExecutionKeyFinder. Looking for Webflow classes... ");
        try {
            mGetRequestContext = mRequestContextHolderClass.getMethod("getRequestContext", new Class[0]);
            log.fine("Retrieved getRequestContext method from holder");
            Class<?> temp = Class.forName(SPRING_REQUEST_CONTEXT);
            mGetFlowExecutionContext = temp.getMethod("getFlowExecutionContext", new Class[0]);
            log.fine("Retrieved getFlowExcutionContext method ");
            temp = Class.forName(SPRING_FLOW_EXECUTION_CONTEXT);
            mGetKey = temp.getMethod("getKey", new Class[0]);
            log.fine("Retrieved getKey method ");
        }
        catch (ClassNotFoundException cnf) {
            log.severe("No RequestContextHolder class found. Not SpringWebflow environment. ");
        }
        catch (NoSuchMethodException nsme) {
            log.severe("NoSuchMethodException: " + nsme);
        }
    }

    static {
        seamClassArgs = new Class[0];
        seamInstanceArgs = new Object[0];
        seamGetEncodeMethodArgs = new Class[]{String.class, String.class};
        seamEncodeMethodArgs = new Object[2];
        seamGetSwitchConversationStackMethodArgs = new Class[]{String.class};
        seamSwitchConversationStackMethodArgs = new Object[1];
        seamMethodNoArgs = new Object[0];
        conversationParentParameter = "parentConversationId";
        seamVersion = "2.0.0.GA";
        flowIdParameterName = null;
        SPRING_CLASS_NAME = "org.springframework.webflow.executor.jsf.FlowVariableResolver";
        SPRING_CONTEXT_HOLDER = "org.springframework.webflow.execution.RequestContextHolder";
        SPRING_REQUEST_CONTEXT = "org.springframework.webflow.execution.RequestContext";
        SPRING_FLOW_EXECUTION_CONTEXT = "org.springframework.webflow.execution.FlowExecutionContext";
        springLoaded = 0;
        SeamUtilities.loadSeamEnvironment();
        SeamUtilities.loadSpringEnvironment();
    }
}

