/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class CoreComponentUtils {
    private static final Pattern ClientIdPattern = Pattern.compile("^(([\\w\\_]*)\\" + UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()) + "([\\w\\_]*))*$");

    public static UIComponent findComponent(String clientId, UIComponent base) {
        char separatorChar = CoreComponentUtils.getSeparatorChar();
        String delimeter = String.valueOf(separatorChar);
        int count = CoreComponentUtils.getNumberOfLeadingNamingContainerSeparators(clientId);
        if (count == 1) {
            while (base.getParent() != null) {
                base = base.getParent();
            }
            clientId = clientId.substring(delimeter.length());
        } else if (count == 0) {
            while (base.getParent() != null && !(base instanceof NamingContainer)) {
                base = base.getParent();
            }
        } else if (count > 1) {
            int numNamingContainersUp = count - 1;
            while (!(base.getParent() == null || base instanceof NamingContainer && --numNamingContainersUp == 0)) {
                base = base.getParent();
            }
            clientId = clientId.substring(delimeter.length() * count);
        }
        String id = null;
        UIComponent result = null;
        while (clientId.length() > 0) {
            int separator = clientId.indexOf(separatorChar);
            if (base instanceof UIData) {
                if (separator >= 0) {
                    clientId = clientId.substring(separator + 1);
                }
                separator = clientId.indexOf(separatorChar);
            }
            if (separator >= 0) {
                id = clientId.substring(0, separator);
                clientId = clientId.substring(separator + 1);
            } else {
                id = clientId;
                clientId = "";
            }
            result = CoreComponentUtils.findComponent(base, id);
            if (result == null || clientId.length() == 0) break;
            if (!(result instanceof NamingContainer)) continue;
            result = CoreComponentUtils.findComponent(clientId, result);
            break;
        }
        return result;
    }

    private static int getNumberOfLeadingNamingContainerSeparators(String clientId) {
        int count = 0;
        String delimeter = String.valueOf(CoreComponentUtils.getSeparatorChar());
        for (int index = 0; clientId.indexOf(delimeter, index) == index; index += delimeter.length()) {
            ++count;
        }
        return count;
    }

    private static char getSeparatorChar() {
        return UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
    }

    private static UIComponent findComponent(UIComponent uiComponent, String componentId) {
        UIComponent component = null;
        UIComponent child = null;
        if (componentId.equals(uiComponent.getId())) {
            return uiComponent;
        }
        Iterator children = uiComponent.getFacetsAndChildren();
        while (children.hasNext() && component == null) {
            child = (UIComponent)children.next();
            if (!(child instanceof NamingContainer)) {
                component = CoreComponentUtils.findComponent(child, componentId);
                if (component == null) continue;
                break;
            }
            if (child.getId() == null || !componentId.equals(child.getId())) continue;
            component = child;
            break;
        }
        return component;
    }

    public static UIComponent findComponentInView(UIComponent uiComponent, String componentId) {
        UIComponent component = null;
        UIComponent child = null;
        if (componentId.equals(uiComponent.getId())) {
            return uiComponent;
        }
        Iterator children = uiComponent.getFacetsAndChildren();
        while (children.hasNext() && component == null && (component = CoreComponentUtils.findComponentInView(child = (UIComponent)children.next(), componentId)) == null) {
            if (child.getId() == null || !componentId.endsWith(child.getId())) continue;
            component = child;
            break;
        }
        return component;
    }

    public static void setFocusId(String focusId) {
    }

    public static String getFocusId(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map map = externalContext.getRequestParameterMap();
        String focusedElement = (String)map.get("ice.focus");
        return focusedElement != null && ClientIdPattern.matcher(focusedElement).matches() ? focusedElement : "";
    }
}

