/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.effects.CurrentStyle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.util.EnvUtils;

public class PassThruAttributeWriter {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static List passThruAttributeNames = new ArrayList();
    private static List booleanPassThruAttributeNames = new ArrayList();

    public static void renderAttributes(ResponseWriter writer, UIComponent uiComponent, String[] excludedAttributes) throws IOException {
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, excludedAttributes);
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, excludedAttributes);
    }

    public static void renderOnFocus(ResponseWriter writer) throws IOException {
        writer.writeAttribute("onfocus", (Object)"setFocus(this.id);", "onfocus");
    }

    public static void renderOnBlur(ResponseWriter writer) throws IOException {
        writer.writeAttribute("onfocus", (Object)"setFocus('');", "onfocus");
    }

    public static void renderBooleanAttributes(ResponseWriter writer, UIComponent uiComponent, String[] excludedAttributes) throws IOException {
        if (writer == null) {
            throw new FacesException("Null pointer exception");
        }
        if (uiComponent == null) {
            throw new FacesException("Null pointer exception");
        }
        List<String> excludedAttributesList = null;
        if (excludedAttributes != null && excludedAttributes.length > 0) {
            excludedAttributesList = Arrays.asList(excludedAttributes);
        }
        Object nextPassThruAttributeValue = null;
        for (Object nextPassThruAttributeName : booleanPassThruAttributeNames) {
            boolean primitiveAttributeValue;
            if (excludedAttributesList != null && excludedAttributesList.contains(nextPassThruAttributeName) || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null) continue;
            if (nextPassThruAttributeValue instanceof Boolean) {
                primitiveAttributeValue = (Boolean)nextPassThruAttributeValue;
            } else {
                if (!(nextPassThruAttributeValue instanceof String)) {
                    nextPassThruAttributeValue = nextPassThruAttributeValue.toString();
                }
                primitiveAttributeValue = new Boolean((String)nextPassThruAttributeValue);
            }
            if (!primitiveAttributeValue) continue;
            writer.writeAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeValue, nextPassThruAttributeName.toString());
        }
    }

    private static void renderNonBooleanAttributes(ResponseWriter writer, UIComponent uiComponent, String[] excludedAttributes) throws IOException {
        if (writer == null) {
            throw new FacesException("Null pointer exception");
        }
        if (uiComponent == null) {
            throw new FacesException("Component instance is null");
        }
        List<String> excludedAttributesList = null;
        if (excludedAttributes != null && excludedAttributes.length > 0) {
            excludedAttributesList = Arrays.asList(excludedAttributes);
        }
        Object nextPassThruAttributeName2 = null;
        Object nextPassThruAttributeValue = null;
        for (Object nextPassThruAttributeName2 : passThruAttributeNames) {
            if (excludedAttributesList != null && excludedAttributesList.contains(nextPassThruAttributeName2) || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName2)) == null || PassThruAttributeWriter.attributeValueIsSentinel(nextPassThruAttributeValue)) continue;
            writer.writeAttribute(nextPassThruAttributeName2.toString(), nextPassThruAttributeValue, nextPassThruAttributeValue.toString());
        }
    }

    public static boolean passThruAttributeExists(UIComponent uiComponent) {
        if (uiComponent == null) {
            return false;
        }
        Map componentAttributes = uiComponent.getAttributes();
        if (componentAttributes.size() <= 0) {
            return false;
        }
        if (PassThruAttributeWriter.componentAttributesIncludePassThruAttribute(componentAttributes, passThruAttributeNames)) {
            return true;
        }
        return PassThruAttributeWriter.componentAttributesIncludePassThruAttribute(componentAttributes, booleanPassThruAttributeNames);
    }

    private static boolean attributeValueIsSentinel(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return (Integer)value == Integer.MIN_VALUE;
            }
            if (value instanceof Long) {
                return (Long)value == Long.MIN_VALUE;
            }
            if (value instanceof Short) {
                return (Short)value == Short.MIN_VALUE;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Double) {
                return (Double)value == Double.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return (Byte)value == -128;
            }
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() == '\u0000';
        }
        return false;
    }

    private static boolean componentAttributesIncludePassThruAttribute(Map componentAttributes, List passThru) {
        for (Object componentAttributeKey : componentAttributes.keySet()) {
            Object componentAttributeValue;
            if (!passThru.contains(componentAttributeKey) || (componentAttributeValue = componentAttributes.get(componentAttributeKey)) == null || componentAttributeValue == "") continue;
            return true;
        }
        return false;
    }

    static final List getpassThruAttributeNames() {
        return passThruAttributeNames;
    }

    public static void renderHtmlAttributes(ResponseWriter writer, UIComponent uiComponent, String[] htmlAttributes) throws IOException {
        List attributesThatAreSet;
        if (writer == null) {
            throw new FacesException("Null pointer exception");
        }
        if (uiComponent == null) {
            throw new FacesException("Component instance is null");
        }
        boolean stockAttribTracking = EnvUtils.isStockAttributeTracking();
        boolean attribTracking = stockAttribTracking && uiComponent.getClass().getName().startsWith("javax.faces.component.");
        List list = attributesThatAreSet = !attribTracking ? null : (List)uiComponent.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (!attribTracking || attributesThatAreSet != null && attributesThatAreSet.size() > 0) {
            String nextPassThruAttributeName = null;
            Object nextPassThruAttributeValue = null;
            for (int i = 0; i < htmlAttributes.length; ++i) {
                nextPassThruAttributeName = htmlAttributes[i];
                if (attribTracking && (attributesThatAreSet == null || !attributesThatAreSet.contains(nextPassThruAttributeName)) || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null || PassThruAttributeWriter.valueIsIntegerSentinelValue(nextPassThruAttributeValue)) continue;
                writer.writeAttribute(nextPassThruAttributeName, nextPassThruAttributeValue, nextPassThruAttributeValue.toString());
            }
        }
        CurrentStyle.apply(FacesContext.getCurrentInstance(), uiComponent, writer);
    }

    private static boolean valueIsIntegerSentinelValue(Object value) {
        if (value instanceof String) {
            return false;
        }
        if (value instanceof Number && value instanceof Integer) {
            return (Integer)value == Integer.MIN_VALUE;
        }
        return false;
    }

    static {
        passThruAttributeNames.add("accept");
        passThruAttributeNames.add("accesskey");
        passThruAttributeNames.add("alt");
        passThruAttributeNames.add("bgcolor");
        passThruAttributeNames.add("border");
        passThruAttributeNames.add("cellpadding");
        passThruAttributeNames.add("cellspacing");
        passThruAttributeNames.add("charset");
        passThruAttributeNames.add("cols");
        passThruAttributeNames.add("coords");
        passThruAttributeNames.add("dir");
        passThruAttributeNames.add("enctype");
        passThruAttributeNames.add("frame");
        passThruAttributeNames.add("height");
        passThruAttributeNames.add("hreflang");
        passThruAttributeNames.add("lang");
        passThruAttributeNames.add("longdesc");
        passThruAttributeNames.add("maxlength");
        passThruAttributeNames.add("onblur");
        passThruAttributeNames.add("onchange");
        passThruAttributeNames.add("onclick");
        passThruAttributeNames.add("ondblclick");
        passThruAttributeNames.add("onfocus");
        passThruAttributeNames.add("onkeydown");
        passThruAttributeNames.add("onkeypress");
        passThruAttributeNames.add("onkeyup");
        passThruAttributeNames.add("onload");
        passThruAttributeNames.add("onmousedown");
        passThruAttributeNames.add("onmousemove");
        passThruAttributeNames.add("onmouseout");
        passThruAttributeNames.add("onmouseover");
        passThruAttributeNames.add("onmouseup");
        passThruAttributeNames.add("onreset");
        passThruAttributeNames.add("onselect");
        passThruAttributeNames.add("onsubmit");
        passThruAttributeNames.add("onunload");
        passThruAttributeNames.add("rel");
        passThruAttributeNames.add("rev");
        passThruAttributeNames.add("rows");
        passThruAttributeNames.add("rules");
        passThruAttributeNames.add("shape");
        passThruAttributeNames.add("size");
        passThruAttributeNames.add("style");
        passThruAttributeNames.add("summary");
        passThruAttributeNames.add("tabindex");
        passThruAttributeNames.add("target");
        passThruAttributeNames.add("title");
        passThruAttributeNames.add("usemap");
        passThruAttributeNames.add("width");
        passThruAttributeNames.add("width");
        passThruAttributeNames.add("onclickeffect");
        passThruAttributeNames.add("ondblclickeffect");
        passThruAttributeNames.add("onmousedowneffect");
        passThruAttributeNames.add("onmouseupeffect");
        passThruAttributeNames.add("onmousemoveeffect");
        passThruAttributeNames.add("onmouseovereffect");
        passThruAttributeNames.add("onmouseouteffect");
        passThruAttributeNames.add("onchangeeffect");
        passThruAttributeNames.add("onreseteffect");
        passThruAttributeNames.add("onsubmiteffect");
        passThruAttributeNames.add("onkeypresseffect");
        passThruAttributeNames.add("onkeydowneffect");
        passThruAttributeNames.add("onkeyupeffect");
        passThruAttributeNames.add("autocomplete");
        booleanPassThruAttributeNames.add("disabled");
        booleanPassThruAttributeNames.add("readonly");
        booleanPassThruAttributeNames.add("ismap");
    }
}

