/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputrichtext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.util.Base64;
import org.icefaces.impl.util.Util;
import org.icefaces.util.EnvUtils;

public class InputRichTextResourceHandler
extends ResourceHandlerWrapper {
    private static final String CKEDITOR_DIR = "ckeditor/";
    private static final String INPUTRICHTEXT_LIB = "inputrichtext";
    private static final String META_INF_RESOURCES = "/META-INF/resources/";
    private static final String CKEDITOR_MAPPING_JS = "ckeditor.mapping.js";
    private static final String CKEDITOR_JS = "ckeditor.js";
    private ResourceHandler handler;
    private String extensionMapping;
    private HashMap<String, ResourceEntry> cssResources = new HashMap();
    private ResourceEntry codeResource;
    private String prefixMapping;

    public InputRichTextResourceHandler(ResourceHandler handler) {
        this.handler = handler;
        final ArrayList<String> imageResources = new ArrayList<String>();
        final ArrayList<String> allResources = new ArrayList<String>();
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            InputStream in = thisClass.getResourceAsStream("/META-INF/resources/inputrichtext/ckeditor.resources");
            String resourceList = new String(InputRichTextResourceHandler.readIntoByteArray(in), "UTF-8");
            String[] paths = resourceList.split(" ");
            for (int i = 0; i < paths.length; ++i) {
                String localPath = paths[i];
                byte[] content = InputRichTextResourceHandler.readIntoByteArray(thisClass.getResourceAsStream("/META-INF/resources/inputrichtext/" + localPath));
                if (localPath.endsWith(".css")) {
                    this.cssResources.put(localPath, new ResourceEntry(localPath, content));
                    continue;
                }
                if (localPath.endsWith(".jpg") || localPath.endsWith(".gif") || localPath.endsWith(".png")) {
                    imageResources.add(localPath);
                    continue;
                }
                allResources.add(localPath);
            }
            FacesContext.getCurrentInstance().getApplication().subscribeToEvent(PreRenderViewEvent.class, new SystemEventListener(){

                public void processEvent(SystemEvent event) throws AbortProcessingException {
                    FacesContext context = FacesContext.getCurrentInstance();
                    try {
                        InputRichTextResourceHandler.this.calculateExtensionMapping();
                        InputRichTextResourceHandler.this.calculateMappings(context, allResources, InputRichTextResourceHandler.this.cssResources, imageResources);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AbortProcessingException((Throwable)e);
                    }
                }

                public boolean isListenerForSource(Object source) {
                    return EnvUtils.isICEfacesView((FacesContext)FacesContext.getCurrentInstance());
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void calculateExtensionMapping() {
        if (this.extensionMapping == null || this.prefixMapping == null) {
            Resource resource = super.createResource("ckeditor/ckeditor.js", INPUTRICHTEXT_LIB);
            String path = resource.getRequestPath();
            int extensionPosition = path.indexOf(".js");
            int queryPosition = path.indexOf("?");
            this.extensionMapping = queryPosition > 0 && queryPosition < extensionPosition ? "" : (extensionPosition < 0 ? "" : path.substring(extensionPosition + 3));
            int prefixPosition = path.indexOf("/javax.faces.resource/ckeditor/");
            this.prefixMapping = prefixPosition < 0 ? "" : path.substring(0, prefixPosition);
        }
    }

    private void calculateMappings(FacesContext context, ArrayList allResources, HashMap cssResources, ArrayList imageResources) throws UnsupportedEncodingException {
        ExternalContext externalContext = context.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        String value = (String)applicationMap.get(InputRichTextResourceHandler.class.getName());
        if (value == null) {
            for (ResourceEntry css : cssResources.values()) {
                String content = css.getContentAsString("UTF-8");
                String dir = this.toRelativeLocalDir(css.localPath);
                for (String entry : imageResources) {
                    String path = InputRichTextResourceHandler.toRelativeLocalPath(entry);
                    if (!path.startsWith(dir)) continue;
                    String relativePath = path.substring(dir.length() + 1);
                    String requestPath = externalContext.encodeResourceURL(this.toRequestPath(context, entry));
                    content = content.replaceAll(relativePath, requestPath);
                }
                css.setContentAsString(content, "UTF-8");
            }
            allResources.addAll(cssResources.keySet());
            allResources.addAll(imageResources);
            StringBuffer code = new StringBuffer();
            code.append("window.CKEDITOR_GETURL = function(r) { var mappings = [");
            Iterator entries = allResources.iterator();
            while (entries.hasNext()) {
                String next = (String)entries.next();
                code.append("{i: '");
                code.append(InputRichTextResourceHandler.toRelativeLocalPath(next));
                code.append("', o: '");
                code.append(externalContext.encodeResourceURL(this.toRequestPath(context, next)));
                code.append("'}");
                if (!entries.hasNext()) continue;
                code.append(",");
            }
            code.append("]; if (r.indexOf('://') > -1) { var i = document.location.href.lastIndexOf('/'); r = r.substring(i + 1); }; for (var i = 0, l = mappings.length; i < l; i++) { var m = mappings[i]; if (m.i == r) { return m.o;} } return false; };");
            value = code.toString();
            applicationMap.put(InputRichTextResourceHandler.class.getName(), value);
        }
        if (this.codeResource == null) {
            this.codeResource = new ResourceEntry("ckeditor/ckeditor.mapping.js", value.getBytes("UTF-8"));
        }
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        if (this.codeResource != null && this.codeResource.localPath != null && this.codeResource.localPath.equals(resourceName)) {
            return this.codeResource;
        }
        if (this.cssResources != null && this.cssResources.containsKey(resourceName)) {
            return this.cssResources.get(resourceName);
        }
        return super.createResource(resourceName, libraryName, contentType);
    }

    private static byte[] readIntoByteArray(InputStream in) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
        return out.toByteArray();
    }

    private static String toRelativeLocalPath(String localPath) {
        return localPath.substring(CKEDITOR_DIR.length());
    }

    public String toRequestPath(FacesContext context, String localPath) {
        return this.prefixMapping + "/javax.faces.resource" + "/" + localPath + this.extensionMapping;
    }

    private String toRelativeLocalDir(String localPath) {
        int position = localPath.lastIndexOf("/");
        return CKEDITOR_DIR.length() > position ? "/" : localPath.substring(CKEDITOR_DIR.length(), position);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceEntry
    extends Resource {
        private Date lastModified = new Date();
        private String localPath;
        private byte[] content;
        private String mimeType;

        private ResourceEntry(String localPath, byte[] content) {
            this.localPath = localPath;
            this.content = content;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            this.mimeType = externalContext.getMimeType(localPath);
        }

        public String getResourceName() {
            return this.localPath;
        }

        public String getLibraryName() {
            return InputRichTextResourceHandler.INPUTRICHTEXT_LIB;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public Map<String, String> getResponseHeaders() {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("ETag", this.eTag());
            headers.put("Cache-Control", "public");
            headers.put("Content-Type", this.mimeType);
            headers.put("Date", Util.HTTP_DATE.format(new Date()));
            headers.put("Last-Modified", Util.HTTP_DATE.format(this.lastModified));
            return headers;
        }

        public String getContentType() {
            return this.mimeType;
        }

        public String getRequestPath() {
            return InputRichTextResourceHandler.this.toRequestPath(FacesContext.getCurrentInstance(), this.localPath);
        }

        public URL getURL() {
            try {
                return FacesContext.getCurrentInstance().getExternalContext().getResource(this.localPath);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            try {
                Date modifiedSince = Util.HTTP_DATE.parse((String)context.getExternalContext().getRequestHeaderMap().get("If-Modified-Since"));
                return this.lastModified.getTime() > modifiedSince.getTime() + 1000L;
            }
            catch (Throwable e) {
                return true;
            }
        }

        private String getContentAsString(String encoding) throws UnsupportedEncodingException {
            return new String(this.content, encoding);
        }

        private void setContentAsString(String newContent, String encoding) throws UnsupportedEncodingException {
            this.content = newContent.getBytes(encoding);
        }

        private String eTag() {
            return Base64.encode((String)String.valueOf(this.localPath.hashCode()));
        }
    }
}

