/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class GMapLatLng
extends UIPanel
implements Serializable {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.GMapLatLng";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.GMapLatLng";
    private String longitude;
    private String latitude;
    private String localeLng;
    private String localeLat;
    private transient Object[] values;

    public GMapLatLng() {
        this.setRendererType(null);
    }

    public GMapLatLng(String latitude, String longitude) {
        this();
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getFamily() {
        return "com.icesoft.faces.GMapLatLng";
    }

    public String getComponentType() {
        return "com.icesoft.faces.GMapLatLng";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.setRendererType(null);
        super.encodeBegin(context);
        this.generateLatLngScript();
    }

    public String getLongitude() {
        if (this.longitude != null) {
            return this.longitude;
        }
        ValueBinding vb = this.getValueBinding("longitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "-122.1419";
    }

    public String getLatitude() {
        if (this.latitude != null) {
            return this.latitude;
        }
        ValueBinding vb = this.getValueBinding("latitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "37.4419";
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void generateLatLngScript() {
        String currentLat = this.getLatitude();
        String currentLng = this.getLongitude();
        String changed = "";
        if (this.localeLat != null && !this.localeLat.equals(currentLat)) {
            changed = "changed";
        }
        if (this.localeLng != null && !this.localeLng.equals(currentLng)) {
            changed = "changed";
        }
        this.localeLat = currentLat;
        this.localeLng = currentLng;
        String script = "new google.maps.LatLng(" + this.getLatitude() + "," + this.getLongitude() + ")" + changed;
        this.getAttributes().put("latLngScript", script);
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.latitude = (String)this.values[1];
        this.longitude = (String)this.values[2];
        this.localeLat = (String)this.values[3];
        this.localeLng = (String)this.values[4];
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[5];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.latitude;
        this.values[2] = this.longitude;
        this.values[3] = this.localeLat;
        this.values[4] = this.localeLng;
        return this.values;
    }
}

