/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.renderkit;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.commandsortheader.CommandSortHeader;
import com.icesoft.faces.component.ext.ColumnGroup;
import com.icesoft.faces.component.ext.HeaderRow;
import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelector;
import com.icesoft.faces.component.ext.UIColumn;
import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.FormRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeWriter;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.CSSNamePool;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableRenderer
extends com.icesoft.faces.renderkit.dom_html_basic.TableRenderer {
    private static final String SELECTED_ROWS = "sel_rows";
    private static final String CLICKED_ROW = "click_row";
    private static final String CLICK_COUNT = "click_count";
    private static final String[] passThruAttributes = ExtendedAttributeConstants.getAttributes(66);

    public String getComponentStyleClass(UIComponent uiComponent) {
        return (String)uiComponent.getAttributes().get("styleClass");
    }

    public String getHeaderClass(UIComponent component) {
        return (String)component.getAttributes().get("headerClass");
    }

    public String getFooterClass(UIComponent component) {
        return (String)component.getAttributes().get("footerClass");
    }

    public String[] getRowStyles(UIComponent uiComponent) {
        if (this.getRowStyleClasses(uiComponent).length <= 0) {
            String[] rowStyles = new String[]{Util.getQualifiedStyleClass(uiComponent, "Row1"), Util.getQualifiedStyleClass(uiComponent, "Row2")};
            return rowStyles;
        }
        return this.getRowStyleClasses(uiComponent);
    }

    public String[] getHeaderStyles(UIComponent uiComponent) {
        String headerClass = this.getHeaderClass(uiComponent).replaceAll("iceDatTblHdr", "");
        if (this.getHeaderStyleClasses(uiComponent).length <= 0) {
            String[] headerStyles = new String[]{CSSNamePool.get(Util.getQualifiedStyleClass(uiComponent, "ColHdr1") + (headerClass.length() > 0 ? headerClass : "")), CSSNamePool.get(Util.getQualifiedStyleClass(uiComponent, "ColHdr2") + (headerClass.length() > 0 ? headerClass : ""))};
            return headerStyles;
        }
        return this.getHeaderStyleClasses(uiComponent);
    }

    public void writeColStyles(String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, Element td, UIComponent uiComponent) {
        if (columnStyles.length > 0 && columnStylesMaxIndex >= 0) {
            td.setAttribute("class", columnStyles[columnStyleIndex]);
        }
    }

    protected void renderFacet(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext, boolean header) throws IOException {
        String facetClass;
        String element;
        String tag;
        String facet;
        if (header) {
            facet = "header";
            tag = "thead";
            element = "th";
            facetClass = this.getHeaderClass(uiComponent);
        } else {
            facet = "footer";
            tag = "tfoot";
            element = "td";
            facetClass = this.getFooterClass(uiComponent);
        }
        HtmlDataTable uiData = (HtmlDataTable)uiComponent;
        uiData.setRowIndex(-1);
        Element root = (Element)domContext.getRootNode();
        if (this.isScrollable(uiComponent)) {
            if (header) {
                root = this.getScrollableHeaderTableElement(root);
                ((Element)root.getParentNode()).setAttribute("class", Util.getQualifiedStyleClass(uiComponent, "ScrlSpr"));
            } else if (uiData.isScrollFooter()) {
                root = this.getScrollableBodyTableElement(root);
            } else {
                root = this.getScrollableFooterTableElement(root);
                ((Element)root.getParentNode()).setAttribute("class", Util.getQualifiedStyleClass(uiComponent, "ScrlSprFtr"));
            }
        }
        UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)uiData, facet);
        boolean childHeaderFacetExists = this.childColumnHasFacetWithName((UIComponent)uiData, facet);
        Element thead = null;
        if (headerFacet != null || childHeaderFacetExists) {
            String clientId = uiData.getContainerClientId(facesContext);
            thead = domContext.createElement(tag);
            thead.setAttribute("id", ClientIdPool.get(clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + tag));
            root.appendChild(thead);
            if (header) {
                if (CoreUtils.getPortletStyleClass("portlet-section-header").length() > 1) {
                    thead.setAttribute("class", "portlet-section-header");
                }
                this.renderTableHeader(facesContext, uiComponent, headerFacet, thead, facetClass, element);
                this.renderColumnGroup(facesContext, uiComponent, headerFacet, thead, facetClass, element);
                if (childHeaderFacetExists) {
                    this.renderColumnHeader(facesContext, uiComponent, thead, facet, element, header);
                    if (!uiData.isClientOnly()) {
                        Element clientOnly = domContext.createElement("input");
                        clientOnly.setAttribute("type", "hidden");
                        clientOnly.setAttribute("id", clientId + "clientOnly");
                        clientOnly.setAttribute("name", clientId + "clientOnly");
                        root.appendChild(clientOnly);
                        uiData.resetResizableTblColumnsWidthIndex();
                    }
                }
            } else {
                if (CoreUtils.getPortletStyleClass("portlet-section-footer").length() > 1) {
                    thead.setAttribute("class", "portlet-section-footer");
                }
                if (childHeaderFacetExists) {
                    this.renderColumnHeader(facesContext, uiComponent, thead, facet, element, header);
                }
                this.renderColumnGroup(facesContext, uiComponent, headerFacet, thead, facetClass, element);
                this.renderTableHeader(facesContext, uiComponent, headerFacet, thead, facetClass, element);
            }
            domContext.setCursorParent(root);
        }
    }

    private void renderColumnHeader(FacesContext facesContext, UIComponent uiComponent, Element thead, String facet, String element, boolean header) throws IOException {
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element tr = domContext.createElement("tr");
        thead.appendChild(tr);
        List childList = uiComponent.getChildren();
        Iterator childColumns = childList.iterator();
        int columnIndex = 1;
        int headerStyleLength = this.getHeaderStyles(uiComponent).length;
        int styleIndex = 0;
        String[] columnWidths = this.getColumnWidthsArray(htmlDataTable);
        htmlDataTable.setColNumber(-1);
        while (childColumns.hasNext()) {
            UIComponent nextColumn = (UIComponent)childColumns.next();
            if (nextColumn instanceof javax.faces.component.UIColumn) {
                htmlDataTable.setColNumber(htmlDataTable.getColNumber() + 1);
            }
            if (!nextColumn.isRendered()) continue;
            if (nextColumn instanceof javax.faces.component.UIColumn) {
                this.processUIColumnHeader(facesContext, uiComponent, (javax.faces.component.UIColumn)nextColumn, tr, domContext, facet, element, columnIndex, styleIndex, !childColumns.hasNext(), columnWidths);
                ++columnIndex;
            } else if (nextColumn instanceof UIColumns) {
                columnIndex = this.processUIColumnsHeader(facesContext, uiComponent, (UIColumns)nextColumn, tr, domContext, facet, element, columnIndex, styleIndex, headerStyleLength, columnWidths);
            }
            if (styleIndex++ != headerStyleLength - 1) continue;
            styleIndex = 0;
        }
        if (header && this.isScrollable(uiComponent)) {
            tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
        }
    }

    private void renderColumnGroup(FacesContext facesContext, UIComponent uiComponent, UIComponent headerFacet, Element thead, String facetClass, String element) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        if (headerFacet == null || !(headerFacet instanceof ColumnGroup)) {
            return;
        }
        if (!headerFacet.isRendered()) {
            return;
        }
        String sourceClass = "Hdr";
        if (!"th".equals(element)) {
            sourceClass = "Ftr";
        }
        String baseClass = Util.getQualifiedStyleClass(uiComponent, "ColGrp" + sourceClass);
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        for (UIComponent child : headerFacet.getChildren()) {
            if (!(child instanceof HeaderRow) || !child.isRendered()) continue;
            Element tr = domContext.createElement("tr");
            String rowStyleClass = ((HeaderRow)child).getStyleClass();
            rowStyleClass = rowStyleClass == null ? baseClass.replaceAll(sourceClass, sourceClass + "Row") : baseClass.replaceAll(sourceClass, sourceClass + "Row ") + rowStyleClass;
            tr.setAttribute("class", CSSNamePool.get(rowStyleClass));
            String rowStyle = ((HeaderRow)child).getStyle();
            if (rowStyle != null) {
                tr.setAttribute("style", rowStyle);
            }
            thead.appendChild(tr);
            for (UIComponent column : child.getChildren()) {
                String style;
                String rowspan;
                if (!(column instanceof javax.faces.component.UIColumn) || !column.isRendered()) continue;
                Element th = domContext.createElement(element);
                tr.appendChild(th);
                String styleClass = ((UIColumn)column).getStyleClass();
                styleClass = styleClass == null ? baseClass.replaceAll(sourceClass, sourceClass + "Col") : baseClass.replaceAll(sourceClass, sourceClass + "Col ") + styleClass;
                String sortColumn = htmlDataTable.getSortColumn();
                if (sortColumn != null) {
                    for (UIComponent columnChild : column.getChildren()) {
                        if (!(columnChild instanceof CommandSortHeader)) continue;
                        String columnName = ((CommandSortHeader)columnChild).getColumnName();
                        if (!sortColumn.equals(columnName)) break;
                        styleClass = styleClass + " iceDatTblActvSrtHdr";
                        break;
                    }
                }
                th.setAttribute("class", CSSNamePool.get(styleClass));
                Integer colspan = null;
                try {
                    colspan = Integer.valueOf(((UIColumn)column).getColspan());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (htmlDataTable.isResizable()) {
                    colspan = colspan != null ? new Integer(colspan + colspan) : new Integer(2);
                }
                if (colspan != null) {
                    th.setAttribute("colspan", colspan.toString());
                }
                if ((rowspan = ((UIColumn)column).getRowspan()) != null) {
                    th.setAttribute("rowspan", rowspan);
                }
                if ((style = ((UIColumn)column).getStyle()) != null) {
                    th.setAttribute("style", style);
                }
                domContext.setCursorParent(th);
                TableRenderer.encodeParentAndChildren(facesContext, column);
            }
            if (!this.isScrollable(uiComponent)) continue;
            tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
        }
    }

    private void renderTableHeader(FacesContext facesContext, UIComponent uiComponent, UIComponent headerFacet, Element thead, String facetClass, String element) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        if (headerFacet != null && headerFacet.isRendered()) {
            if (headerFacet instanceof ColumnGroup) {
                return;
            }
            this.resetFacetChildId(headerFacet);
            Element tr = domContext.createElement("tr");
            thead.appendChild(tr);
            Element th = domContext.createElement(element);
            tr.appendChild(th);
            if (facetClass != null) {
                th.setAttribute("class", facetClass);
            }
            int columns = this.getNumberOfChildColumns(uiComponent);
            if (((HtmlDataTable)uiComponent).isResizable()) {
                columns += columns - 1;
            }
            th.setAttribute("colspan", String.valueOf(columns));
            th.setAttribute("scope", "colgroup");
            domContext.setCursorParent(th);
            TableRenderer.encodeParentAndChildren(facesContext, headerFacet);
            if (this.isScrollable(uiComponent)) {
                tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
            }
        }
    }

    private void processUIColumnHeader(FacesContext facesContext, UIComponent uiComponent, javax.faces.component.UIColumn nextColumn, Element tr, DOMContext domContext, String facet, String element, int columnIndex, int styleIndex, boolean lastChild, String[] columnsWidth) throws IOException {
        UIComponent nextFacet;
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        Element th = domContext.createElement(element);
        tr.appendChild(th);
        th.setAttribute("scope", "col");
        Element cursorParent = th;
        if (htmlDataTable.isResizable()) {
            String nextWidth;
            if (!lastChild) {
                Element handlerTd = domContext.createElement(element);
                handlerTd.setAttribute("valign", "top");
                handlerTd.setAttribute("class", "iceDatTblResBor");
                handlerTd.setAttribute("onmouseover", "ResizableUtil.adjustHeight(this)");
                Element resizeHandler = domContext.createElement("div");
                resizeHandler.setAttribute("style", "cursor: e-resize; display:block;  height:100%;");
                resizeHandler.setAttribute("onmousedown", "new Ice.ResizableGrid(event);");
                resizeHandler.setAttribute("class", "iceDatTblResHdlr");
                resizeHandler.appendChild(domContext.createTextNodeUnescaped("&#160;"));
                handlerTd.appendChild(resizeHandler);
                tr.appendChild(handlerTd);
            }
            Element columnHeaderDiv = domContext.createElement("div");
            columnHeaderDiv.setAttribute("id", ClientIdPool.get(htmlDataTable.getContainerClientId(facesContext) + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "hdrDv" + columnIndex));
            th.appendChild(columnHeaderDiv);
            if (htmlDataTable.isResizable() && (nextWidth = htmlDataTable.getNextResizableTblColumnWidth()) != null) {
                columnHeaderDiv.setAttribute("style", "width:" + nextWidth + ";");
            }
            cursorParent = columnHeaderDiv;
        }
        if ("header".equalsIgnoreCase(facet)) {
            String columnName;
            String styles = this.getHeaderStyles(uiComponent)[styleIndex];
            String sortColumn = htmlDataTable.getSortColumn();
            UIComponent headerFacet = nextColumn.getFacet("header");
            if (sortColumn != null && headerFacet instanceof CommandSortHeader && sortColumn.equals(columnName = ((CommandSortHeader)headerFacet).getColumnName())) {
                styles = styles + " iceDatTblActvSrtHdr";
                Element columnHeaderDiv = domContext.createElement("div");
                columnHeaderDiv.setAttribute("style", "display:inline-table");
                th.appendChild(columnHeaderDiv);
                cursorParent = columnHeaderDiv;
            }
            th.setAttribute("class", styles);
        } else {
            th.setAttribute("class", this.getFooterClass((UIComponent)htmlDataTable));
        }
        String width = this.getWidthFromColumnWidthsArray(htmlDataTable, columnsWidth);
        if (width != null) {
            th.setAttribute("style", width);
        }
        if ((nextFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, facet)) != null) {
            this.resetFacetChildId(nextFacet);
            domContext.setCursorParent(cursorParent);
            TableRenderer.encodeParentAndChildren(facesContext, nextFacet);
        }
    }

    private int processUIColumnsHeader(FacesContext facesContext, UIComponent uiComponent, UIColumns nextColumn, Element tr, DOMContext domContext, String facet, String element, int columnIndex, int styleIndex, int headerStyleLength, String[] columnsWidth) throws IOException {
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        int rowIndex = nextColumn.getFirst();
        nextColumn.encodeBegin(facesContext);
        nextColumn.setRowIndex(rowIndex);
        String sortColumn = htmlDataTable.getSortColumn();
        while (nextColumn.isRowAvailable()) {
            UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, facet);
            htmlDataTable.setColNumber(htmlDataTable.getColNumber() + 1);
            if (headerFacet != null) {
                String columnName;
                Node oldParent = domContext.getCursorParent();
                Element th = domContext.createElement(element);
                tr.appendChild(th);
                th.setAttribute("scope", "col");
                String styleClass = this.getHeaderStyles(uiComponent)[styleIndex];
                if (headerFacet instanceof CommandSortHeader && sortColumn.equals(columnName = ((CommandSortHeader)headerFacet).getColumnName())) {
                    styleClass = styleClass + " iceDatTblActvSrtHdr";
                }
                th.setAttribute("class", styleClass);
                String width = null;
                Element cursorParent = th;
                if (htmlDataTable.isResizable()) {
                    Element columnHeaderDiv = domContext.createElement("div");
                    columnHeaderDiv.setAttribute("id", ClientIdPool.get(htmlDataTable.getContainerClientId(facesContext) + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "hdrDv" + columnIndex));
                    th.appendChild(columnHeaderDiv);
                    width = htmlDataTable.getNextResizableTblColumnWidth();
                    if (width != null) {
                        width = "width:" + width + ";";
                        columnHeaderDiv.setAttribute("style", width);
                    }
                    cursorParent = columnHeaderDiv;
                }
                if (width == null) {
                    width = this.getWidthFromColumnWidthsArray(htmlDataTable, columnsWidth);
                }
                if (width != null) {
                    th.setAttribute("style", width);
                }
                domContext.setCursorParent(cursorParent);
                TableRenderer.encodeParentAndChildren(facesContext, headerFacet);
                domContext.setCursorParent(oldParent);
            }
            if (styleIndex++ == headerStyleLength - 1) {
                styleIndex = 0;
            }
            ++columnIndex;
            nextColumn.setRowIndex(++rowIndex);
            if (!htmlDataTable.isResizable() || nextColumn.getRowCount() <= rowIndex) continue;
            Element handlerTd = domContext.createElement(element);
            handlerTd.setAttribute("valign", "top");
            handlerTd.setAttribute("class", "iceDatTblResBor");
            handlerTd.setAttribute("onmouseover", "ResizableUtil.adjustHeight(this)");
            Element resizeHandler = domContext.createElement("div");
            resizeHandler.setAttribute("style", "cursor: e-resize; display:block;  height:100%;");
            resizeHandler.setAttribute("onmousedown", "new Ice.ResizableGrid(event);");
            resizeHandler.setAttribute("class", "iceDatTblResHdlr");
            resizeHandler.appendChild(domContext.createTextNodeUnescaped("&#160;"));
            handlerTd.appendChild(resizeHandler);
            tr.appendChild(handlerTd);
        }
        nextColumn.setRowIndex(-1);
        return columnIndex;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        TableRenderer.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element originalRoot = root = (Element)domContext.getRootNode();
        String clientId = uiComponent.getContainerClientId(facesContext);
        boolean scrollable = this.isScrollable(uiComponent);
        if (scrollable) {
            Element hdrTbl = this.getScrollableHeaderTableElement(root);
            hdrTbl.setAttribute("class", Util.getQualifiedStyleClass(uiComponent, "ScrlHdrTbl"));
            root = this.getScrollableBodyTableElement(root);
            root.setAttribute("class", Util.getQualifiedStyleClass(uiComponent, "ScrlBdyTbl"));
        }
        DOMContext.removeChildrenByTagName(root, "tbody");
        Element tBody = domContext.createElement("tbody");
        tBody.setAttribute("id", ClientIdPool.get(clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + "tbody"));
        root.appendChild(tBody);
        HtmlDataTable uiData = (HtmlDataTable)uiComponent;
        uiData.ensureFirstRowInRange();
        int rowIndex = uiData.getFirst();
        int rowCount = uiData.getRowCount();
        if (rowCount == 0) {
            Element tr = domContext.createElement("tr");
            tBody.appendChild(tr);
            int cols = 0;
            for (UIComponent component : this.getRenderedChildColumnsList((UIComponent)uiData)) {
                if (component instanceof UIColumns) {
                    cols += ((UIColumns)component).getRowCount();
                    continue;
                }
                if (!(component instanceof javax.faces.component.UIColumn)) continue;
                ++cols;
            }
            if (cols == 0) {
                cols = 1;
            }
            for (int i = 0; i < cols; ++i) {
                Element td = domContext.createElement("td");
                tr.appendChild(td);
            }
            domContext.stepOver();
            return;
        }
        if (rowCount >= 0 && rowCount <= rowIndex) {
            domContext.stepOver();
            return;
        }
        uiData.setRowIndex(rowIndex);
        int numberOfRowsToDisplay = uiData.getRows();
        int countOfRowsDisplayed = 0;
        String[] rowStyles = this.getRowStyles(uiComponent);
        int rowStyleIndex = 0;
        int rowStylesMaxIndex = rowStyles.length - 1;
        RowSelector rowSelector = TableRenderer.getRowSelector(uiComponent);
        boolean rowSelectorFound = rowSelector != null;
        boolean toggleOnClick = false;
        String rowSelectionFunctionName = null;
        String rowSelectionUseEvent = "false";
        boolean rowSelectorCodeAdded = false;
        Node scriptNode = null;
        Element hiddenInputNode = null;
        Element hiddenClickedRowField = null;
        Element hiddenClickCountField = null;
        UIComponent form = DomBasicRenderer.findForm(uiComponent);
        String formId = form == null ? "" : form.getClientId(facesContext);
        String paramId = TableRenderer.getSelectedRowParameterName(facesContext, uiData);
        if (rowSelectorFound) {
            FormRenderer.addHiddenField(facesContext, paramId + "ctrKy");
            FormRenderer.addHiddenField(facesContext, paramId + "sftKy");
            toggleOnClick = rowSelector.getToggleOnClick();
            Element rowSelectedField = domContext.createElement("input");
            boolean toggleOnInput = rowSelector.getToggleOnInput();
            rowSelectionUseEvent = toggleOnInput ? "false" : "true";
            rowSelectedField.setAttribute("id", paramId);
            rowSelectedField.setAttribute("name", paramId);
            rowSelectedField.setAttribute("type", "hidden");
            hiddenInputNode = rowSelectedField;
            rowSelectionFunctionName = "Ice.tableRowClicked";
            Element clickedRowField = domContext.createElement("input");
            String clickedRowParam = TableRenderer.getClickedRowParameterName(facesContext, uiData);
            clickedRowField.setAttribute("type", "hidden");
            clickedRowField.setAttribute("name", clickedRowParam);
            Element clickCountField = domContext.createElement("input");
            String clickCountParam = TableRenderer.getClickCountParameterName(facesContext, uiData);
            clickCountField.setAttribute("type", "hidden");
            clickCountField.setAttribute("name", clickCountParam);
            hiddenClickedRowField = clickedRowField;
            hiddenClickCountField = clickCountField;
        }
        Boolean isResizable = null;
        String[] columnStyles = this.getColumnStyleClasses(uiComponent);
        int columnStylesMaxIndex = columnStyles.length - 1;
        this.resetGroupState((UIComponent)uiData);
        while (uiData.isRowAvailable()) {
            int columnStyleIndex = 0;
            String selectedClass = null;
            if (rowStylesMaxIndex >= 0) {
                selectedClass = rowStyles[rowStyleIndex];
            }
            Iterator childs = uiData.getChildren().iterator();
            Element tr = domContext.createElement("tr");
            tr.setAttribute("tabindex", "0");
            if (rowSelectorFound) {
                if (toggleOnClick) {
                    String toggleClass = "";
                    if (rowSelector.isPreStyleOnSelection()) {
                        toggleClass = Boolean.TRUE.equals(rowSelector.getValue()) ? selectedClass + " " + rowSelector.getStyleClass() : selectedClass + " " + rowSelector.getSelectedClass();
                    }
                    toggleClass = CSSNamePool.get(this.getPortletAlternateRowClass(toggleClass, rowIndex));
                    if (null == rowSelector.getClickListener() && null == rowSelector.getClickAction()) {
                        tr.setAttribute("onclick", rowSelectionFunctionName + "(event, " + rowSelectionUseEvent + ",'" + uiData.getRowIndex() + "', '" + formId + "', '" + paramId + "','" + toggleClass + "', this);");
                    } else {
                        String delay = String.valueOf(rowSelector.getDblClickDelay());
                        tr.setAttribute("onclick", "Ice.registerClick(this,'" + TableRenderer.getClickedRowParameterName(facesContext, uiData) + "','" + TableRenderer.getClickCountParameterName(facesContext, uiData) + "'," + "'" + uiData.getRowIndex() + "','" + formId + "'," + delay + ",true,event," + rowSelectionUseEvent + "," + "'" + paramId + "','" + toggleClass + "');");
                        tr.setAttribute("ondblclick", "Ice.registerDblClick(this);");
                    }
                } else if (rowSelector.getClickListener() != null || rowSelector.getClickAction() != null) {
                    String delay = String.valueOf(rowSelector.getDblClickDelay());
                    tr.setAttribute("onclick", "Ice.registerClick(this,'" + TableRenderer.getClickedRowParameterName(facesContext, uiData) + "','" + TableRenderer.getClickCountParameterName(facesContext, uiData) + "'," + "'" + uiData.getRowIndex() + "','" + formId + "'," + delay + ",false);");
                    tr.setAttribute("ondblclick", "Ice.registerDblClick(this);");
                }
                if (rowSelector.getClickListener() != null || rowSelector.getClickAction() != null || rowSelector.isEnhancedMultiple()) {
                    tr.setAttribute("onmousedown", "return Ice.preventTextSelection(event);");
                }
            }
            String id = uiComponent.getContainerClientId(facesContext);
            tr.setAttribute("id", ClientIdPool.get(id));
            Element anchor = domContext.createElement("a");
            if (rowSelectorFound) {
                if (Boolean.TRUE.equals(rowSelector.getValue())) {
                    selectedClass = selectedClass + " " + rowSelector.getSelectedClass();
                    tr.setAttribute("onmouseover", "this.className='" + CoreUtils.getPortletStyleClass("portlet-section-body-hover") + " " + rowSelector.getSelectedMouseOverClass() + "';");
                } else {
                    selectedClass = selectedClass + " " + rowSelector.getStyleClass();
                    tr.setAttribute("onmouseover", "this.className='" + CoreUtils.getPortletStyleClass("portlet-section-body-hover") + " " + rowSelector.getMouseOverClass() + "';");
                }
                tr.setAttribute("onmouseout", "Ice.enableTxtSelection(document.body); this.className='" + this.getPortletAlternateRowClass(selectedClass, rowIndex) + "'");
            }
            domContext.setCursorParent(tBody);
            tBody.appendChild(tr);
            selectedClass = this.getPortletAlternateRowClass(selectedClass, rowIndex);
            tr.setAttribute("class", CSSNamePool.get(selectedClass));
            if (rowStylesMaxIndex >= 0 && ++rowStyleIndex > rowStylesMaxIndex) {
                rowStyleIndex = 0;
            }
            uiData.setColNumber(-1);
            String[] columnWidths = this.getColumnWidthsArray(uiData);
            while (childs.hasNext()) {
                UIComponent nextChild = (UIComponent)childs.next();
                if (nextChild.isRendered()) {
                    if (nextChild instanceof javax.faces.component.UIColumn) {
                        uiData.setColNumber(uiData.getColNumber() + 1);
                        Element td = domContext.createElement("td");
                        if (uiData.getColNumber() == 0) {
                            td.setAttribute("scope", "row");
                        }
                        if (uiData.getColNumber() == 0 && rowSelectorFound && rowSelector.isKeyboardNavigationEnabled()) {
                            boolean singleSelection = false;
                            if (!rowSelector.isEnhancedMultiple() && !rowSelector.getMultiple().booleanValue() && rowSelector.isSingleRowAutoSelect()) {
                                singleSelection = true;
                            }
                            anchor.setAttribute("id", clientId + "_idx_" + countOfRowsDisplayed);
                            anchor.setAttribute("class", "iceHdnLnk");
                            anchor.setAttribute("href", "#");
                            anchor.appendChild(domContext.createTextNodeUnescaped("<img src='" + CoreUtils.resolveResourceURL(facesContext, "/xmlhttp/css/xp/css-images/spacer.gif") + "' alt=''/>"));
                            anchor.setAttribute("onfocus", "return Ice.tblRowFocus(this, " + singleSelection + ");");
                            anchor.setAttribute("onblur", "return Ice.tblRowBlur(this);");
                            td.appendChild(anchor);
                            Node oldCursorParent = domContext.getCursorParent();
                            domContext.setCursorParent(anchor);
                            PassThruAttributeWriter.renderHtmlAttributes(facesContext.getResponseWriter(), (UIComponent)rowSelector, passThruAttributes);
                            domContext.setCursorParent(oldCursorParent);
                        }
                        String iceColumnStyle = null;
                        String iceColumnStyleClass = null;
                        if (nextChild instanceof UIColumn) {
                            UIColumn iceColumn = (UIColumn)nextChild;
                            iceColumnStyle = iceColumn.getStyle();
                            iceColumnStyleClass = iceColumn.getStyleClass();
                            if (iceColumn.getGroupOn() != null) {
                                if (iceColumn.groupFound()) {
                                    Element groupedTd = iceColumn.getGroupedTd();
                                    groupedTd.setAttribute("rowspan", String.valueOf(iceColumn.getGroupCount()));
                                    if (isResizable == null) {
                                        isResizable = uiData.isResizable();
                                    }
                                    if (!isResizable.booleanValue() || !childs.hasNext()) continue;
                                    Element eTd = domContext.createElement("td");
                                    eTd.setAttribute("class", "iceDatTblBlkTd");
                                    Element img = domContext.createElement("img");
                                    img.setAttribute("src", CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), "/xmlhttp/css/xp/css-images/spacer.gif"));
                                    img.setAttribute("alt", "");
                                    eTd.appendChild(img);
                                    tr.appendChild(eTd);
                                    continue;
                                }
                                iceColumn.setGroupedTd(td);
                            }
                        }
                        if (!rowSelectorCodeAdded && scriptNode != null) {
                            td.appendChild(scriptNode);
                        }
                        if (null != hiddenInputNode) {
                            td.appendChild(hiddenInputNode);
                        }
                        if (null != hiddenClickedRowField && null != hiddenClickCountField) {
                            td.appendChild(hiddenClickedRowField);
                            td.appendChild(hiddenClickCountField);
                        }
                        this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, uiComponent);
                        String width = this.getWidthFromColumnWidthsArray(uiData, columnWidths);
                        if (width != null) {
                            td.setAttribute("style", width);
                        }
                        if (iceColumnStyle != null) {
                            String existingStyle = td.getAttribute("style");
                            if (existingStyle != null) {
                                td.setAttribute("style", existingStyle + ";" + iceColumnStyle);
                            } else {
                                td.setAttribute("style", iceColumnStyle);
                            }
                        }
                        if (iceColumnStyleClass != null) {
                            String existingStyleClass = td.getAttribute("class");
                            if (existingStyleClass != null) {
                                td.setAttribute("class", CSSNamePool.get(existingStyleClass + " " + iceColumnStyleClass));
                            } else {
                                td.setAttribute("class", CSSNamePool.get(iceColumnStyleClass));
                            }
                        }
                        tr.appendChild(td);
                        if (isResizable == null) {
                            isResizable = uiData.isResizable();
                        }
                        if (isResizable.booleanValue() && childs.hasNext()) {
                            Element eTd = domContext.createElement("td");
                            eTd.setAttribute("class", "iceDatTblBlkTd");
                            Element img = domContext.createElement("img");
                            img.setAttribute("src", CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), "/xmlhttp/css/xp/css-images/spacer.gif"));
                            img.setAttribute("alt", "");
                            eTd.appendChild(img);
                            tr.appendChild(eTd);
                        }
                        if (++columnStyleIndex > columnStylesMaxIndex) {
                            columnStyleIndex = 0;
                        }
                        Node oldCursorParent = domContext.getCursorParent();
                        domContext.setCursorParent(td);
                        TableRenderer.encodeParentAndChildren(facesContext, nextChild);
                        domContext.setCursorParent(oldCursorParent);
                        continue;
                    }
                    if (!(nextChild instanceof UIColumns)) continue;
                    if (isResizable == null) {
                        isResizable = uiData.isResizable();
                    }
                    nextChild.encodeBegin(facesContext);
                    this.encodeColumns(facesContext, nextChild, domContext, tr, columnStyles, columnStylesMaxIndex, columnStyleIndex, hiddenInputNode, hiddenClickedRowField, hiddenClickCountField, columnWidths, isResizable);
                    nextChild.encodeEnd(facesContext);
                    continue;
                }
                if (!(nextChild instanceof javax.faces.component.UIColumn)) continue;
                uiData.setColNumber(uiData.getColNumber() + 1);
            }
            if (numberOfRowsToDisplay > 0 && ++countOfRowsDisplayed >= numberOfRowsToDisplay || rowCount >= 0 && ++rowIndex >= rowCount) break;
            uiData.setRowIndex(rowIndex);
        }
        uiData.setRowIndex(-1);
        domContext.stepOver();
    }

    private void encodeColumns(FacesContext facesContext, UIComponent columns, DOMContext domContext, Node tr, String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, Element rowSelectorHiddenField, Element clickEventRowField, Element clickEventCountField, String[] columnWidths, boolean isResizable) throws IOException {
        UIColumns uiList = (UIColumns)columns;
        HtmlDataTable table = (HtmlDataTable)uiList.getParent();
        int rowIndex = uiList.getFirst();
        uiList.setRowIndex(rowIndex);
        int numberOfRowsToDisplay = uiList.getRows();
        domContext.setCursorParent(tr);
        Node oldCursorParent = domContext.getCursorParent();
        for (int countOfRowsDisplayed = 0; uiList.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay); ++countOfRowsDisplayed) {
            String width;
            table.setColNumber(table.getColNumber() + 1);
            Element td = domContext.createElement("td");
            if (table.getColNumber() == 0) {
                td.setAttribute("scope", "row");
            }
            Iterator childs = columns.getChildren().iterator();
            if (null != rowSelectorHiddenField) {
                td.appendChild(rowSelectorHiddenField);
            }
            if (null != clickEventRowField && null != clickEventCountField) {
                td.appendChild(clickEventRowField);
                td.appendChild(clickEventCountField);
            }
            if ((width = this.getWidthFromColumnWidthsArray(table, columnWidths)) != null) {
                td.setAttribute("style", width);
            }
            domContext.setCursorParent(oldCursorParent);
            tr.appendChild(td);
            while (childs.hasNext()) {
                UIComponent nextChild = (UIComponent)childs.next();
                if (!nextChild.isRendered()) continue;
                domContext.setCursorParent(td);
                this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, columns.getParent());
                if (++columnStyleIndex > columnStylesMaxIndex) {
                    columnStyleIndex = 0;
                }
                TableRenderer.encodeParentAndChildren(facesContext, nextChild);
                domContext.setCursorParent(oldCursorParent);
            }
            uiList.setRowIndex(++rowIndex);
            if (!isResizable || uiList.getRowCount() <= rowIndex) continue;
            Element eTd = domContext.createElement("td");
            eTd.setAttribute("class", "iceDatTblBlkTd");
            Element img = domContext.createElement("img");
            img.setAttribute("src", CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), "/xmlhttp/css/xp/css-images/spacer.gif"));
            img.setAttribute("alt", "");
            eTd.appendChild(img);
            tr.appendChild(eTd);
        }
        uiList.setRowIndex(-1);
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        for (UIComponent kid : component.getChildren()) {
            if ((!(kid instanceof javax.faces.component.UIColumn) || !kid.isRendered()) && !(kid instanceof UIColumns)) continue;
            results.add(kid);
        }
        return results;
    }

    protected boolean childColumnHasFacetWithName(UIComponent component, String facetName) {
        Iterator childColumns = this.getRenderedChildColumnsIterator(component);
        while (childColumns.hasNext()) {
            UIComponent nextChildColumn = (UIComponent)childColumns.next();
            if (TableRenderer.getFacetByName(nextChildColumn, facetName) == null) continue;
            return true;
        }
        return false;
    }

    public static String getSelectedRowParameterName(FacesContext facesContext, HtmlDataTable dataTable) {
        String dataTableId = dataTable.getClientId(facesContext);
        return dataTableId + SELECTED_ROWS;
    }

    public static String getClickedRowParameterName(FacesContext facesContext, HtmlDataTable dataTable) {
        String dataTableId = dataTable.getClientId(facesContext);
        return dataTableId + CLICKED_ROW;
    }

    public static String getClickCountParameterName(FacesContext facesContext, HtmlDataTable dataTable) {
        String dataTableId = dataTable.getClientId(facesContext);
        return dataTableId + CLICK_COUNT;
    }

    public static RowSelector getRowSelector(UIComponent comp) {
        if (comp instanceof RowSelector) {
            return (RowSelector)comp;
        }
        for (UIComponent kid : comp.getChildren()) {
            RowSelector rs;
            if (kid instanceof HtmlDataTable || (rs = TableRenderer.getRowSelector(kid)) == null) continue;
            if (!rs.isRendered()) {
                return null;
            }
            return rs;
        }
        return null;
    }

    private int rowSelectorNumber(FacesContext context) {
        Map m = context.getExternalContext().getRequestMap();
        String key = RowSelector.class.getName() + "-Selector";
        Integer I = (Integer)m.get(key);
        int i = 0;
        if (I != null) {
            i = I;
            ++i;
        }
        I = new Integer(i);
        m.put(key, I);
        return i;
    }

    protected int getNumberOfChildColumns(UIComponent component) {
        int size = this.getRenderedChildColumnsList(component).size();
        for (UIComponent uiComponent : this.getRenderedChildColumnsList(component)) {
            if (!(uiComponent instanceof UIColumns)) continue;
            size += ((UIColumns)uiComponent).getRowCount();
        }
        return size;
    }

    protected String[] getColumnStyleClasses(UIComponent uiComponent) {
        String[] columnStyles = super.getColumnStyleClasses(uiComponent);
        if (columnStyles.length == 0) {
            columnStyles = new String[]{Util.getQualifiedStyleClass(uiComponent, "Col1"), Util.getQualifiedStyleClass(uiComponent, "Col2")};
        } else {
            for (int i = 0; i < columnStyles.length; ++i) {
                columnStyles[i] = Util.getQualifiedStyleClass(uiComponent, columnStyles[i], "Col", "columnClasses");
            }
        }
        return columnStyles;
    }

    public String[] getRowStyleClasses(UIComponent uiComponent) {
        String[] rowClasses = super.getRowStyleClasses(uiComponent);
        for (int i = 0; i < rowClasses.length; ++i) {
            rowClasses[i] = Util.getQualifiedStyleClass(uiComponent, rowClasses[i], "Row", "rowClasses");
        }
        return rowClasses;
    }

    public String[] getHeaderStyleClasses(UIComponent uiComponent) {
        String headerClass = this.getHeaderClass(uiComponent).replaceAll("iceDatTblHdr", "");
        String[] headerClasses = this.getStyleClasses(uiComponent, "headerClasses");
        for (int i = 0; i < headerClasses.length; ++i) {
            headerClasses[i] = CSSNamePool.get(Util.getQualifiedStyleClass(uiComponent, headerClasses[i], "ColHdr", "headerClasses") + (headerClass.length() > 0 ? headerClass : ""));
        }
        return headerClasses;
    }

    String getPortletAlternateRowClass(String selectedClass, int rowIndex) {
        String rowClass = "portlet-section-alternate";
        if (rowIndex % 2 == 0) {
            rowClass = "portlet-section-body";
        }
        if (selectedClass.indexOf(32) > 1) {
            return selectedClass.replaceFirst(" ", " " + CoreUtils.getPortletStyleClass(rowClass + " "));
        }
        selectedClass = selectedClass + CoreUtils.getPortletStyleClass("" + rowClass);
        return selectedClass;
    }

    void resetGroupState(UIComponent uiComponent) {
        for (UIComponent child : uiComponent.getChildren()) {
            if (!(child instanceof UIColumn)) continue;
            ((UIColumn)child).resetGroupState();
        }
    }

    protected String getWidthFromColumnWidthsArray(HtmlDataTable htmlDataTable, String[] columnWidths) {
        StringBuffer width = new StringBuffer();
        if (columnWidths.length > 0 && htmlDataTable.getColNumber() < columnWidths.length) {
            try {
                width.append("width:");
                width.append(columnWidths[htmlDataTable.getColNumber()]);
                width.append(";");
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (NumberFormatException nfe) {}
        } else if (this.isScrollable((UIComponent)htmlDataTable)) {
            width.append("width:100%;");
        }
        if (this.isScrollable((UIComponent)htmlDataTable)) {
            width.append("overflow:hidden;");
        }
        return width.length() > 0 ? width.toString() : null;
    }

    protected String[] getColumnWidthsArray(HtmlDataTable htmlDataTable) {
        String columnWidths = htmlDataTable.getColumnWidths();
        return columnWidths != null ? columnWidths.split(",") : new String[]{};
    }
}

