/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import com.cloudant.client.api.Database;
import com.cloudant.client.org.lightcouch.DocumentConflictException;
import com.cloudant.client.org.lightcouch.NoDocumentException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.spi.WalletStore;

public final class CloudantWalletStore
implements WalletStore {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private final Database database;

    public CloudantWalletStore(Database database) {
        this.database = database;
    }

    @Override
    public void remove(String label) {
        IdentityDocument document = this.getDocument(label);
        if (document != null) {
            try {
                this.database.remove((Object)document);
            }
            catch (NoDocumentException noDocumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream get(String label) {
        IdentityDocument document = this.getDocument(label);
        return document != null ? document.getData() : null;
    }

    private IdentityDocument getDocument(String label) {
        try {
            return (IdentityDocument)this.database.find(IdentityDocument.class, label);
        }
        catch (NoDocumentException e) {
            return null;
        }
    }

    @Override
    public Set<String> list() throws IOException {
        List ids = this.database.getAllDocsRequestBuilder().build().getResponse().getDocIds();
        return new HashSet<String>(ids);
    }

    @Override
    public void put(String label, InputStream data) throws IOException {
        IdentityDocument document = this.getDocument(label);
        try {
            if (document != null) {
                document.setData(data);
                this.database.update((Object)document);
            } else {
                document = new IdentityDocument(label, data);
                this.database.save((Object)document);
            }
        }
        catch (DocumentConflictException e) {
            throw new IOException(e);
        }
    }

    private static final class IdentityDocument {
        private String _id;
        private String _rev;
        private String data;

        IdentityDocument(String id, InputStream dataIn) throws IOException {
            this._id = id;
            this.setData(dataIn);
        }

        public InputStream getData() {
            return new ByteArrayInputStream(this.data.getBytes(ENCODING));
        }

        public void setData(InputStream dataIn) throws IOException {
            try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
                GatewayUtils.copy(dataIn, byteOut);
                this.data = new String(byteOut.toByteArray(), ENCODING);
            }
        }
    }
}

