/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSource;
import org.hyperledger.fabric.gateway.impl.event.BlockListenerSession;
import org.hyperledger.fabric.gateway.impl.event.ListenerSession;
import org.hyperledger.fabric.gateway.impl.event.Listeners;
import org.hyperledger.fabric.gateway.impl.event.PeerDisconnectListenerSession;
import org.hyperledger.fabric.gateway.spi.CommitListener;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class CommitListenerSession
implements ListenerSession {
    private final BlockListenerSession blockListenerSession;
    private final Collection<PeerDisconnectListenerSession> disconnectListenerSessions;

    public CommitListenerSession(BlockEventSource blockSource, CommitListener commitListener, Collection<Peer> peers, String transactionId) {
        Consumer<BlockEvent.TransactionEvent> transactionListener = Listeners.transaction(commitListener, peers, transactionId);
        Consumer<BlockEvent> blockListener = Listeners.fromTransaction(transactionListener);
        this.blockListenerSession = new BlockListenerSession(blockSource, blockListener);
        Consumer<PeerDisconnectEvent> disconnectListener = commitListener::acceptDisconnect;
        this.disconnectListenerSessions = peers.stream().map(peer -> new PeerDisconnectListenerSession((Peer)peer, disconnectListener)).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.blockListenerSession.close();
        this.disconnectListenerSessions.forEach(PeerDisconnectListenerSession::close);
    }

    public String toString() {
        return GatewayUtils.toString(this, "blockListenerSession=" + this.blockListenerSession, "disconnectListenerSessions=" + this.disconnectListenerSessions);
    }
}

