/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.hyperledger.fabric.gateway.Contract;
import org.hyperledger.fabric.gateway.ContractEvent;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.Transaction;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.NetworkImpl;
import org.hyperledger.fabric.gateway.impl.TransactionImpl;
import org.hyperledger.fabric.gateway.impl.event.BlockListenerSession;
import org.hyperledger.fabric.gateway.impl.event.ListenerSession;
import org.hyperledger.fabric.gateway.impl.event.Listeners;
import org.hyperledger.fabric.gateway.impl.event.ReplayListenerSession;
import org.hyperledger.fabric.gateway.spi.Checkpointer;
import org.hyperledger.fabric.sdk.BlockEvent;

public final class ContractImpl
implements Contract,
AutoCloseable {
    private final NetworkImpl network;
    private final String chaincodeId;
    private final String name;
    private final Map<Consumer<ContractEvent>, ListenerSession> contractListenerSessions = new HashMap<Consumer<ContractEvent>, ListenerSession>();

    ContractImpl(NetworkImpl network, String chaincodeId, String name) {
        this.network = network;
        this.chaincodeId = chaincodeId;
        this.name = name;
    }

    @Override
    public Transaction createTransaction(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Transaction must be a non-empty string");
        }
        String qualifiedName = this.getQualifiedName(name);
        return new TransactionImpl(this, qualifiedName);
    }

    @Override
    public byte[] submitTransaction(String name, String ... args) throws ContractException, TimeoutException, InterruptedException {
        return this.createTransaction(name).submit(args);
    }

    @Override
    public byte[] evaluateTransaction(String name, String ... args) throws ContractException {
        return this.createTransaction(name).evaluate(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<ContractEvent> addContractListener(Consumer<ContractEvent> listener) {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            this.contractListenerSessions.computeIfAbsent(listener, k -> {
                Consumer<ContractEvent> contractListener = Listeners.contract(listener, this.chaincodeId);
                return new BlockListenerSession(this.network.getBlockSource(), Listeners.fromContract(contractListener));
            });
        }
        return listener;
    }

    @Override
    public Consumer<ContractEvent> addContractListener(Consumer<ContractEvent> listener, String eventName) {
        return this.addContractListener(listener, this.getEventNamePattern(eventName));
    }

    private Pattern getEventNamePattern(String eventName) {
        return Pattern.compile(Pattern.quote(eventName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<ContractEvent> addContractListener(Consumer<ContractEvent> listener, Pattern eventNamePattern) {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            this.contractListenerSessions.computeIfAbsent(listener, k -> {
                Consumer<ContractEvent> contractListener = Listeners.contract(listener, this.chaincodeId, eventNamePattern);
                return new BlockListenerSession(this.network.getBlockSource(), Listeners.fromContract(contractListener));
            });
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<ContractEvent> addContractListener(Checkpointer checkpointer, Consumer<ContractEvent> listener) throws IOException {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            if (!this.contractListenerSessions.containsKey(listener)) {
                Consumer<ContractEvent> contractListener = Listeners.contract(listener, this.chaincodeId);
                ListenerSession session = this.newCheckpointListenerSession(checkpointer, contractListener);
                this.contractListenerSessions.put(listener, session);
            }
        }
        return listener;
    }

    private ListenerSession newCheckpointListenerSession(Checkpointer checkpointer, Consumer<ContractEvent> contractListener) throws IOException {
        Consumer<BlockEvent> checkpointListener = Listeners.checkpointContract(checkpointer, contractListener);
        return this.network.newCheckpointListenerSession(checkpointer, checkpointListener);
    }

    @Override
    public Consumer<ContractEvent> addContractListener(Checkpointer checkpointer, Consumer<ContractEvent> listener, String eventName) throws IOException {
        return this.addContractListener(checkpointer, listener, this.getEventNamePattern(eventName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<ContractEvent> addContractListener(Checkpointer checkpointer, Consumer<ContractEvent> listener, Pattern eventNamePattern) throws IOException {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            if (!this.contractListenerSessions.containsKey(listener)) {
                Consumer<ContractEvent> contractListener = Listeners.contract(listener, this.chaincodeId, eventNamePattern);
                ListenerSession session = this.newCheckpointListenerSession(checkpointer, contractListener);
                this.contractListenerSessions.put(listener, session);
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<ContractEvent> addContractListener(long startBlock, Consumer<ContractEvent> listener) {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            if (!this.contractListenerSessions.containsKey(listener)) {
                Consumer<ContractEvent> contractListener = Listeners.contract(listener, this.chaincodeId);
                ListenerSession session = this.newReplayListenerSession(startBlock, contractListener);
                this.contractListenerSessions.put(listener, session);
            }
        }
        return listener;
    }

    private ListenerSession newReplayListenerSession(long startBlock, Consumer<ContractEvent> contractListener) {
        Consumer<BlockEvent> blockListener = Listeners.fromContract(contractListener);
        return new ReplayListenerSession(this.network, blockListener, startBlock);
    }

    @Override
    public Consumer<ContractEvent> addContractListener(long startBlock, Consumer<ContractEvent> listener, String eventName) {
        return this.addContractListener(startBlock, listener, this.getEventNamePattern(eventName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<ContractEvent> addContractListener(long startBlock, Consumer<ContractEvent> listener, Pattern eventNamePattern) {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            if (!this.contractListenerSessions.containsKey(listener)) {
                Consumer<ContractEvent> contractListener = Listeners.contract(listener, this.chaincodeId, eventNamePattern);
                ListenerSession session = this.newReplayListenerSession(startBlock, contractListener);
                this.contractListenerSessions.put(listener, session);
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContractListener(Consumer<ContractEvent> listener) {
        ListenerSession session;
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            session = this.contractListenerSessions.remove(listener);
        }
        if (session != null) {
            session.close();
        }
    }

    public NetworkImpl getNetwork() {
        return this.network;
    }

    public String getChaincodeId() {
        return this.chaincodeId;
    }

    private String getQualifiedName(String tname) {
        return this.name.isEmpty() ? tname : this.name + ':' + tname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Consumer<ContractEvent>, ListenerSession> map = this.contractListenerSessions;
        synchronized (map) {
            this.contractListenerSessions.values().forEach(ListenerSession::close);
            this.contractListenerSessions.clear();
        }
    }

    public String toString() {
        return GatewayUtils.toString(this, "name=" + (this.name.isEmpty() ? this.chaincodeId : this.chaincodeId + ':' + this.name), "contractListenerSessions=" + this.contractListenerSessions);
    }
}

