/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import java.time.Instant;
import org.hyperledger.fabric.protos.ledger.queryresult.KeyModification;

public final class KeyModificationImpl
implements org.hyperledger.fabric.shim.ledger.KeyModification {
    private final String txId;
    private final ByteString value;
    private final Instant timestamp;
    private final boolean deleted;

    KeyModificationImpl(KeyModification km) {
        this.txId = km.getTxId();
        this.value = km.getValue();
        this.timestamp = Instant.ofEpochSecond(km.getTimestamp().getSeconds(), km.getTimestamp().getNanos());
        this.deleted = km.getIsDelete();
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    @Override
    public byte[] getValue() {
        return this.value.toByteArray();
    }

    @Override
    public String getStringValue() {
        return this.value.toStringUtf8();
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public int hashCode() {
        int prime = 31;
        int result = Boolean.hashCode(this.deleted);
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + this.txId.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KeyModificationImpl that = (KeyModificationImpl)other;
        return this.deleted == that.deleted && this.timestamp.equals(that.timestamp) && this.txId.equals(that.txId) && this.value.equals((Object)that.value);
    }
}

