/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.Context;
import org.hyperledger.fabric.contract.ContractInterface;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Contract;
import org.hyperledger.fabric.contract.annotation.Default;
import org.hyperledger.fabric.contract.routing.ContractDefinition;
import org.hyperledger.fabric.contract.routing.TxFunction;
import org.hyperledger.fabric.contract.routing.impl.TxFunctionImpl;

public final class ContractDefinitionImpl
implements ContractDefinition {
    private static final Logger LOGGER = Logger.getLogger(ContractDefinitionImpl.class);
    private final Map<String, TxFunction> txFunctions = new HashMap<String, TxFunction>();
    private final String name;
    private final boolean isDefault;
    private final Class<? extends ContractInterface> contractClz;
    private final Contract contractAnnotation;
    private final TxFunction unknownTx;

    public ContractDefinitionImpl(Class<? extends ContractInterface> cl) {
        Contract annotation = cl.getAnnotation(Contract.class);
        LOGGER.debug(() -> "Class Contract Annotation: " + String.valueOf(annotation));
        String annotationName = annotation.name();
        this.name = annotationName == null || annotationName.isEmpty() ? cl.getSimpleName() : annotationName;
        this.isDefault = cl.getAnnotation(Default.class) != null;
        this.contractAnnotation = cl.getAnnotation(Contract.class);
        this.contractClz = cl;
        try {
            Method m = cl.getMethod("unknownTransaction", Context.class);
            this.unknownTx = new TxFunctionImpl(m, this);
            this.unknownTx.setUnknownTx(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            ContractRuntimeException cre = new ContractRuntimeException("Failure to find unknownTransaction method", e);
            LOGGER.severe(() -> LOGGER.formatError(cre));
            throw cre;
        }
        LOGGER.info(() -> "Found class: " + cl.getCanonicalName());
        LOGGER.debug(() -> "Namespace: " + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<TxFunction> getTxFunctions() {
        return this.txFunctions.values();
    }

    @Override
    public Class<? extends ContractInterface> getContractImpl() {
        return this.contractClz;
    }

    @Override
    public TxFunction addTxFunction(Method m) {
        LOGGER.debug(() -> "Adding method " + m.getName());
        TxFunctionImpl txFn = new TxFunctionImpl(m, this);
        TxFunction previousTxnFn = this.txFunctions.put(txFn.getName(), txFn);
        if (previousTxnFn != null) {
            String message = String.format("Duplicate transaction method %s", previousTxnFn.getName());
            ContractRuntimeException cre = new ContractRuntimeException(message);
            LOGGER.severe(() -> LOGGER.formatError(cre));
            throw cre;
        }
        return txFn;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public TxFunction getTxFunction(String method) {
        return this.txFunctions.get(method);
    }

    @Override
    public boolean hasTxFunction(String method) {
        return this.txFunctions.containsKey(method);
    }

    @Override
    public TxFunction getUnknownRoute() {
        return this.unknownTx;
    }

    @Override
    public Contract getAnnotation() {
        return this.contractAnnotation;
    }

    public String toString() {
        return this.name + ":" + String.valueOf(this.txFunctions) + " @" + Integer.toHexString(System.identityHashCode(this));
    }
}

